/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    Tree parent;
    int id;
    int lastWidth;
    int lastPosition;
    int iconRef;
    boolean resizable = true;
    String toolTipText;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, tree.getColumnCount());
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.GetDataBrowserPropertyFlags(this.parent.handle, this.id, nArray);
        return (nArray[0] & 0x20000) != 0;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.parent.handle, this.id, sArray);
        return Math.max(0, sArray[0] + this.parent.getLeftDisclosureInset(this.id));
    }

    public void pack() {
        this.checkWidget();
        GC gC = new GC(this.parent);
        int n = gC.stringExtent((String)this.text).x;
        if (this.iconRef != 0 || this.image != null && OS.VERSION >= 4160) {
            n += this.parent.headerHeight;
            if (this.text.length() != 0) {
                n += this.parent.getGap();
            }
        }
        int n2 = this.parent.indexOf(this);
        n = Math.max(n, this.calculateWidth(this.parent.childIds, n2, gC, n));
        gC.dispose();
        this.setWidth(n + this.parent.getInsetWidth(this.id, true));
    }

    int calculateWidth(int[] nArray, int n, GC gC, int n2) {
        int n3 = n2;
        if (nArray == null) {
            return n3;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            TreeItem treeItem = this.parent._getItem(nArray[n4], false);
            if (treeItem != null && treeItem.cached) {
                n3 = Math.max(n3, treeItem.calculateWidth(n, gC));
                if (treeItem.getExpanded()) {
                    n3 = Math.max(n3, this.calculateWidth(treeItem.childIds, n, gC, n3));
                }
            }
            ++n4;
        }
        return n3;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.id = -1;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
        if (this.iconRef != 0) {
            OS.ReleaseIconRef(this.iconRef);
        }
        this.iconRef = 0;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resized(int n) {
        this.lastWidth = n;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        boolean bl = false;
        int[] nArray = this.parent.getColumnOrder();
        TreeColumn[] treeColumnArray = this.parent.getColumns();
        int n2 = 0;
        while (n2 < nArray.length) {
            TreeColumn treeColumn = treeColumnArray[nArray[n2]];
            if (bl && !treeColumn.isDisposed()) {
                treeColumn.sendEvent(10);
            }
            if (treeColumn == this) {
                bl = true;
            }
            ++n2;
        }
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.updateHeader();
    }

    public void setImage(Image image) {
        int n;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.iconRef != 0) {
            OS.ReleaseIconRef(this.iconRef);
            this.iconRef = 0;
        }
        super.setImage(image);
        if (image != null && OS.VERSION < 4160) {
            this.iconRef = this.createIconRef(image);
        }
        this.updateHeader();
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.GetDataBrowserPropertyFlags(this.parent.handle, this.id, nArray);
        nArray[0] = bl ? nArray[0] | 0x20000 : nArray[0] & 0xFFFDFFFF;
        OS.SetDataBrowserPropertyFlags(this.parent.handle, this.id, nArray[0]);
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
        this.updateHeader();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        this.updateHeader();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if ((n -= this.parent.getLeftDisclosureInset(this.id)) < 0) {
            n = 0;
        }
        OS.SetDataBrowserTableViewNamedColumnWidth(this.parent.handle, this.id, (short)n);
        this.updateHeader();
        if (n != this.lastWidth) {
            this.resized(n);
        }
    }

    void updateHeader() {
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        if (n2 == 0) {
            this.error(13);
        }
        DataBrowserListViewHeaderDesc dataBrowserListViewHeaderDesc = new DataBrowserListViewHeaderDesc();
        dataBrowserListViewHeaderDesc.version = 0;
        dataBrowserListViewHeaderDesc.btnFontStyle_just = (short)-2;
        if (this.parent.indexOf(this) != 0) {
            if ((this.style & 0x1000000) != 0) {
                dataBrowserListViewHeaderDesc.btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                dataBrowserListViewHeaderDesc.btnFontStyle_just = (short)-1;
            }
        }
        dataBrowserListViewHeaderDesc.btnFontStyle_flags = (short)(dataBrowserListViewHeaderDesc.btnFontStyle_flags | 0x40);
        if (this.resizable) {
            dataBrowserListViewHeaderDesc.minimumWidth = 0;
            dataBrowserListViewHeaderDesc.maximumWidth = Short.MAX_VALUE;
        } else {
            short[] sArray = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.parent.handle, this.id, sArray);
            dataBrowserListViewHeaderDesc.minimumWidth = dataBrowserListViewHeaderDesc.maximumWidth = sArray[0];
        }
        dataBrowserListViewHeaderDesc.titleString = n2;
        if (OS.VERSION < 4160) {
            dataBrowserListViewHeaderDesc.btnContentInfo_contentType = (short)(this.iconRef != 0 ? 132 : 0);
            dataBrowserListViewHeaderDesc.btnContentInfo_iconRef = this.iconRef;
        } else if (this.image != null) {
            dataBrowserListViewHeaderDesc.btnContentInfo_contentType = (short)134;
            dataBrowserListViewHeaderDesc.btnContentInfo_iconRef = this.image.handle;
        }
        OS.SetDataBrowserListViewHeaderDesc(this.parent.handle, this.id, dataBrowserListViewHeaderDesc);
        OS.CFRelease(n2);
    }
}

