/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIScrollBarTrackInfo;
import org.eclipse.swt.internal.carbon.HIThemeTrackDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.ScrollBarTrackInfo;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    HIScrollBarTrackInfo getArrowsInfo() {
        int n = this.state[1];
        int n2 = this.state[2];
        int n3 = this.state[3];
        int n4 = this.state[4];
        int n5 = this.state[5];
        int n6 = 0;
        if ((n & 8) != 0) {
            n6 |= 1;
        }
        if ((n2 & 8) != 0) {
            n6 |= 0x40;
        }
        if ((n3 & 8) != 0) {
            n6 |= 2;
        }
        if ((n4 & 8) != 0) {
            n6 |= 0x20;
        }
        if ((n5 & 8) != 0) {
            n6 |= 8;
        }
        int n7 = 3;
        if ((this.state[0] & 0x10) != 0) {
            n7 = 0;
        }
        if ((this.state[0] & 0x20) != 0) {
            n7 = 1;
        }
        HIScrollBarTrackInfo hIScrollBarTrackInfo = new HIScrollBarTrackInfo();
        hIScrollBarTrackInfo.pressState = (byte)n6;
        hIScrollBarTrackInfo.enableState = (byte)n7;
        hIScrollBarTrackInfo.viewsize = this.thumb;
        return hIScrollBarTrackInfo;
    }

    HIThemeTrackDrawInfo getInfo() {
        int n = this.state[1];
        int n2 = this.state[2];
        int n3 = this.state[3];
        int n4 = this.state[4];
        int n5 = this.state[5];
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = new HIThemeTrackDrawInfo();
        hIThemeTrackDrawInfo.min = this.minimum;
        hIThemeTrackDrawInfo.max = Math.max(this.minimum, this.maximum - this.thumb);
        hIThemeTrackDrawInfo.value = this.selection;
        hIThemeTrackDrawInfo.kind = 0;
        hIThemeTrackDrawInfo.attributes = (short)4;
        if ((this.style & 0x100) != 0) {
            hIThemeTrackDrawInfo.attributes = (short)(hIThemeTrackDrawInfo.attributes | 1);
        }
        hIThemeTrackDrawInfo.enableState = (byte)3;
        if ((this.state[0] & 0x10) != 0) {
            hIThemeTrackDrawInfo.enableState = 0;
        }
        if ((this.state[0] & 0x20) != 0) {
            hIThemeTrackDrawInfo.enableState = 1;
        }
        hIThemeTrackDrawInfo.scrollbar = new ScrollBarTrackInfo();
        int n6 = 0;
        if ((n & 8) != 0) {
            n6 |= 1;
        }
        if ((n2 & 8) != 0) {
            n6 |= 0x40;
        }
        if ((n3 & 8) != 0) {
            n6 |= 2;
        }
        if ((n4 & 8) != 0) {
            n6 |= 0x20;
        }
        if ((n5 & 8) != 0) {
            n6 |= 8;
        }
        hIThemeTrackDrawInfo.scrollbar.pressState = (byte)n6;
        hIThemeTrackDrawInfo.scrollbar.viewsize = this.thumb;
        return hIThemeTrackDrawInfo;
    }

    Rectangle getBounds(int n, Rectangle rectangle) {
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        hIThemeTrackDrawInfo.bounds_x = rectangle.x;
        hIThemeTrackDrawInfo.bounds_y = rectangle.y;
        hIThemeTrackDrawInfo.bounds_width = rectangle.width;
        hIThemeTrackDrawInfo.bounds_height = rectangle.height;
        CGRect cGRect = new CGRect();
        short s = 0;
        switch (n) {
            case 1: {
                s = 20;
                break;
            }
            case 2: {
                s = 21;
                break;
            }
            case 3: {
                s = 22;
                break;
            }
            case 5: {
                s = 129;
                break;
            }
            case 4: {
                s = 23;
            }
        }
        OS.HIThemeGetTrackPartBounds(hIThemeTrackDrawInfo, s, cGRect);
        return new Rectangle((int)cGRect.x, (int)cGRect.y, (int)cGRect.width, (int)cGRect.height);
    }

    int getSelection(Point point, Rectangle rectangle) {
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        hIThemeTrackDrawInfo.bounds_x = rectangle.x;
        hIThemeTrackDrawInfo.bounds_y = rectangle.y;
        hIThemeTrackDrawInfo.bounds_width = rectangle.width;
        hIThemeTrackDrawInfo.bounds_height = rectangle.height;
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = point.x;
        cGPoint.y = point.y;
        float[] fArray = new float[1];
        OS.HIThemeGetTrackThumbPositionFromOffset(hIThemeTrackDrawInfo, cGPoint, fArray);
        int[] nArray = new int[1];
        OS.HIThemeGetTrackLiveValue(hIThemeTrackDrawInfo, fArray[0], nArray);
        return nArray[0];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        hIThemeTrackDrawInfo.bounds_x = rectangle.x;
        hIThemeTrackDrawInfo.bounds_y = rectangle.y;
        hIThemeTrackDrawInfo.bounds_width = rectangle.width;
        hIThemeTrackDrawInfo.bounds_height = rectangle.height;
        OS.HIThemeDrawTrack(hIThemeTrackDrawInfo, null, gC.handle, 0);
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = point.x;
        cGPoint.y = point.y;
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        short[] sArray = new short[1];
        HIScrollBarTrackInfo hIScrollBarTrackInfo = this.getArrowsInfo();
        OS.HIThemeHitTestScrollBarArrows(cGRect, hIScrollBarTrackInfo, (this.style & 0x100) != 0, cGPoint, null, sArray);
        switch (sArray[0]) {
            case 20: {
                return 1;
            }
            case 21: {
                return 2;
            }
        }
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        hIThemeTrackDrawInfo.bounds_x = rectangle.x;
        hIThemeTrackDrawInfo.bounds_y = rectangle.y;
        hIThemeTrackDrawInfo.bounds_width = rectangle.width;
        hIThemeTrackDrawInfo.bounds_height = rectangle.height;
        if (OS.HIThemeHitTestTrack(hIThemeTrackDrawInfo, cGPoint, sArray)) {
            switch (sArray[0]) {
                case 22: {
                    return 3;
                }
                case 23: {
                    return 4;
                }
                case 129: {
                    return 5;
                }
            }
        }
        return -1;
    }
}

