/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private Vector filelists = new Vector();
    private boolean relative = false;
    private boolean parallel = false;
    private boolean forwardSlash = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;
    private boolean skipEmpty = false;
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    private int maxParallel = -1;
    private boolean addSourceFile = true;
    private boolean verbose = false;
    private boolean ignoreMissing = true;
    private boolean force = false;
    protected boolean srcIsFirst = true;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void addDirset(DirSet set) {
        this.filesets.addElement(set);
    }

    public void addFilelist(FileList list) {
        this.filelists.addElement(list);
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setType(FileDirBoth type) {
        this.type = type.getValue();
    }

    public void setSkipEmptyFilesets(boolean skip) {
        this.skipEmpty = skip;
    }

    public void setDest(File destDir) {
        this.destDir = destDir;
    }

    public void setForwardslash(boolean forwardSlash) {
        this.forwardSlash = forwardSlash;
    }

    public void setMaxParallel(int max) {
        this.maxParallel = max;
    }

    public void setAddsourcefile(boolean b) {
        this.addSourceFile = b;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setIgnoremissing(boolean b) {
        this.ignoreMissing = b;
    }

    public void setForce(boolean b) {
        this.force = b;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple " + "srcfile elements.", this.getLocation());
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple " + "targetfile elements.", this.getLocation());
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    protected void checkConfiguration() {
        if ("execon".equals(this.getTaskName())) {
            this.log("!! execon is deprecated. Use apply instead. !!");
        }
        super.checkConfiguration();
        if (this.filesets.size() == 0 && this.filelists.size() == 0) {
            throw new BuildException("no filesets and no filelists specified", this.getLocation());
        }
        if (this.targetFilePos != null && this.mapperElement == null) {
            throw new BuildException("targetfile specified without mapper", this.getLocation());
        }
        if (this.destDir != null && this.mapperElement == null) {
            throw new BuildException("dest specified without mapper", this.getLocation());
        }
        if (this.mapperElement != null) {
            this.mapper = this.mapperElement.getImplementation();
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirectorElement == null ? super.createHandler() : new PumpStreamHandler();
    }

    protected void setupRedirector() {
        super.setupRedirector();
        this.redirector.setAppendProperties(true);
    }

    protected void runExec(Execute exe) throws BuildException {
        int totalFiles = 0;
        int totalDirs = 0;
        boolean haveExecuted = false;
        try {
            int i;
            Vector<Object> fileNames = new Vector<Object>();
            Vector<File> baseDirs = new Vector<File>();
            for (i = 0; i < this.filesets.size(); ++i) {
                int j;
                Object[] s;
                String currentType = this.type;
                AbstractFileSet fs = (AbstractFileSet)this.filesets.elementAt(i);
                if (fs instanceof DirSet && !"dir".equals(this.type)) {
                    this.log("Found a nested dirset but type is " + this.type + ". " + "Temporarily switching to type=\"dir\" on the" + " assumption that you really did mean" + " <dirset> not <fileset>.", 4);
                    currentType = "dir";
                }
                File base = fs.getDir(this.getProject());
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                if (!"dir".equals(currentType)) {
                    s = this.getFiles(base, ds);
                    for (j = 0; j < s.length; ++j) {
                        ++totalFiles;
                        fileNames.addElement(s[j]);
                        baseDirs.addElement(base);
                    }
                }
                if (!"file".equals(currentType)) {
                    s = this.getDirs(base, ds);
                    for (j = 0; j < s.length; ++j) {
                        ++totalDirs;
                        fileNames.addElement(s[j]);
                        baseDirs.addElement(base);
                    }
                }
                if (fileNames.size() == 0 && this.skipEmpty) {
                    int includedCount = (!"dir".equals(currentType) ? ds.getIncludedFilesCount() : 0) + (!"file".equals(currentType) ? ds.getIncludedDirsCount() : 0);
                    this.log("Skipping fileset for directory " + base + ". It is " + (includedCount > 0 ? "up to date." : "empty."), 2);
                    continue;
                }
                if (this.parallel) continue;
                s = new String[fileNames.size()];
                fileNames.copyInto(s);
                for (j = 0; j < s.length; ++j) {
                    String[] command = this.getCommandline((String)s[j], base);
                    this.log(Commandline.describeCommand(command), 3);
                    exe.setCommandline(command);
                    if (this.redirectorElement != null) {
                        this.setupRedirector();
                        this.redirectorElement.configure(this.redirector, (String)s[j]);
                    }
                    if (this.redirectorElement != null || haveExecuted) {
                        exe.setStreamHandler(this.redirector.createHandler());
                    }
                    this.runExecute(exe);
                    haveExecuted = true;
                }
                fileNames.removeAllElements();
                baseDirs.removeAllElements();
            }
            for (i = 0; i < this.filelists.size(); ++i) {
                FileList list = (FileList)this.filelists.elementAt(i);
                File base = list.getDir(this.getProject());
                String[] names = this.getFilesAndDirs(list);
                for (int j = 0; j < names.length; ++j) {
                    File f = new File(base, names[j]);
                    if (this.ignoreMissing && (!f.isFile() || "dir".equals(this.type)) && (!f.isDirectory() || "file".equals(this.type))) continue;
                    if (this.ignoreMissing || f.isFile()) {
                        ++totalFiles;
                    } else {
                        ++totalDirs;
                    }
                    fileNames.addElement(names[j]);
                    baseDirs.addElement(base);
                }
                if (fileNames.size() == 0 && this.skipEmpty) {
                    DirectoryScanner ds = new DirectoryScanner();
                    ds.setBasedir(base);
                    ds.setIncludes(list.getFiles(this.getProject()));
                    ds.scan();
                    int includedCount = ds.getIncludedFilesCount() + ds.getIncludedDirsCount();
                    this.log("Skipping filelist for directory " + base + ". It is " + (includedCount > 0 ? "up to date." : "empty."), 2);
                    continue;
                }
                if (this.parallel) continue;
                Object[] s = new String[fileNames.size()];
                fileNames.copyInto(s);
                for (int j = 0; j < s.length; ++j) {
                    String[] command = this.getCommandline((String)s[j], base);
                    this.log(Commandline.describeCommand(command), 3);
                    exe.setCommandline(command);
                    if (this.redirectorElement != null) {
                        this.setupRedirector();
                        this.redirectorElement.configure(this.redirector, (String)s[j]);
                    }
                    if (this.redirectorElement != null || haveExecuted) {
                        exe.setStreamHandler(this.redirector.createHandler());
                    }
                    this.runExecute(exe);
                    haveExecuted = true;
                }
                fileNames.removeAllElements();
                baseDirs.removeAllElements();
            }
            if (this.parallel && (fileNames.size() > 0 || !this.skipEmpty)) {
                this.runParallel(exe, fileNames, baseDirs);
                haveExecuted = true;
            }
            if (haveExecuted) {
                this.log("Applied " + this.cmdl.getExecutable() + " to " + totalFiles + " file" + (totalFiles != 1 ? "s" : "") + " and " + totalDirs + " director" + (totalDirs != 1 ? "ies" : "y") + ".", this.verbose ? 2 : 3);
            }
        }
        catch (IOException e) {
            throw new BuildException("Execute failed: " + e, e, this.getLocation());
        }
        finally {
            this.logFlush();
            this.redirector.setAppendProperties(false);
            this.redirector.setProperties();
        }
    }

    protected String[] getCommandline(String[] srcFiles, File[] baseDirs) {
        char fileSeparator = File.separatorChar;
        Vector<String> targets = new Vector<String>();
        if (this.targetFilePos != null) {
            Hashtable<String, String> addedFiles = new Hashtable<String, String>();
            for (int i = 0; i < srcFiles.length; ++i) {
                String[] subTargets = this.mapper.mapFileName(srcFiles[i]);
                if (subTargets == null) continue;
                for (int j = 0; j < subTargets.length; ++j) {
                    String name = null;
                    name = !this.relative ? new File(this.destDir, subTargets[j]).getAbsolutePath() : subTargets[j];
                    if (this.forwardSlash && fileSeparator != '/') {
                        name = name.replace(fileSeparator, '/');
                    }
                    if (addedFiles.contains(name)) continue;
                    targets.addElement(name);
                    addedFiles.put(name, name);
                }
            }
        }
        Object[] targetFiles = new String[targets.size()];
        targets.copyInto(targetFiles);
        if (!this.addSourceFile) {
            srcFiles = new String[]{};
        }
        String[] orig = this.cmdl.getCommandline();
        String[] result = new String[orig.length + srcFiles.length + targetFiles.length];
        int srcIndex = orig.length;
        if (this.srcFilePos != null) {
            srcIndex = this.srcFilePos.getPosition();
        }
        if (this.targetFilePos != null) {
            int targetIndex = this.targetFilePos.getPosition();
            if (srcIndex < targetIndex || srcIndex == targetIndex && this.srcIsFirst) {
                System.arraycopy(orig, 0, result, 0, srcIndex);
                System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length, targetIndex - srcIndex);
                System.arraycopy(targetFiles, 0, result, targetIndex + srcFiles.length, targetFiles.length);
                System.arraycopy(orig, targetIndex, result, targetIndex + srcFiles.length + targetFiles.length, orig.length - targetIndex);
            } else {
                System.arraycopy(orig, 0, result, 0, targetIndex);
                System.arraycopy(targetFiles, 0, result, targetIndex, targetFiles.length);
                System.arraycopy(orig, targetIndex, result, targetIndex + targetFiles.length, srcIndex - targetIndex);
                System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length + targetFiles.length, orig.length - srcIndex);
                srcIndex += targetFiles.length;
            }
        } else {
            System.arraycopy(orig, 0, result, 0, srcIndex);
            System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length, orig.length - srcIndex);
        }
        for (int i = 0; i < srcFiles.length; ++i) {
            result[srcIndex + i] = !this.relative ? new File(baseDirs[i], srcFiles[i]).getAbsolutePath() : srcFiles[i];
            if (!this.forwardSlash || fileSeparator == '/') continue;
            result[srcIndex + i] = result[srcIndex + i].replace(fileSeparator, '/');
        }
        return result;
    }

    protected String[] getCommandline(String srcFile, File baseDir) {
        return this.getCommandline(new String[]{srcFile}, new File[]{baseDir});
    }

    protected String[] getFiles(File baseDir, DirectoryScanner ds) {
        return this.restrict(ds.getIncludedFiles(), baseDir);
    }

    protected String[] getDirs(File baseDir, DirectoryScanner ds) {
        return this.restrict(ds.getIncludedDirectories(), baseDir);
    }

    protected String[] getFilesAndDirs(FileList list) {
        return this.restrict(list.getFiles(this.getProject()), list.getDir(this.getProject()));
    }

    private String[] restrict(String[] s, File baseDir) {
        return this.mapper == null || this.force ? s : new SourceFileScanner(this).restrict(s, baseDir, this.destDir, this.mapper);
    }

    protected void runParallel(Execute exe, Vector fileNames, Vector baseDirs) throws IOException, BuildException {
        Object[] s = new String[fileNames.size()];
        fileNames.copyInto(s);
        Object[] b = new File[baseDirs.size()];
        baseDirs.copyInto(b);
        if (this.maxParallel <= 0 || s.length == 0) {
            String[] command = this.getCommandline((String[])s, (File[])b);
            this.log(Commandline.describeCommand(command), 3);
            exe.setCommandline(command);
            this.runExecute(exe);
        } else {
            int stillToDo = fileNames.size();
            int currentOffset = 0;
            while (stillToDo > 0) {
                int currentAmount = Math.min(stillToDo, this.maxParallel);
                String[] cs = new String[currentAmount];
                System.arraycopy(s, currentOffset, cs, 0, currentAmount);
                File[] cb = new File[currentAmount];
                System.arraycopy(b, currentOffset, cb, 0, currentAmount);
                String[] command = this.getCommandline(cs, cb);
                this.log(Commandline.describeCommand(command), 3);
                exe.setCommandline(command);
                if (this.redirectorElement != null) {
                    this.setupRedirector();
                    this.redirectorElement.configure(this.redirector, null);
                }
                if (this.redirectorElement != null || currentOffset > 0) {
                    exe.setStreamHandler(this.redirector.createHandler());
                }
                this.runExecute(exe);
                stillToDo -= currentAmount;
                currentOffset += currentAmount;
            }
        }
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

