/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileWriter;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.__builtin__;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInterpreter {
    PyModule module;
    protected PySystemState systemState;
    PyObject locals;
    protected CompilerFlags cflags = new CompilerFlags();

    public static void initialize(Properties preProperties, Properties postProperties, String[] argv) {
        PySystemState.initialize(preProperties, postProperties, argv);
    }

    public PythonInterpreter() {
        this(null, null);
    }

    public PythonInterpreter(PyObject dict) {
        this(dict, null);
    }

    public PythonInterpreter(PyObject dict, PySystemState systemState) {
        if (dict == null) {
            dict = new PyStringMap();
        }
        if (systemState == null && (systemState = Py.getSystemState()) == null) {
            systemState = new PySystemState();
        }
        this.systemState = systemState;
        this.setState();
        this.module = new PyModule("__main__", dict);
        systemState.modules.__setitem__("__main__", (PyObject)this.module);
        this.locals = dict;
    }

    protected void setState() {
        Py.setSystemState(this.systemState);
    }

    public void setOut(PyObject outStream) {
        this.systemState.stdout = outStream;
    }

    @Deprecated
    public void setOut(Writer outStream) {
        this.setOut(new PyFileWriter(outStream));
    }

    public void setOut(OutputStream outStream) {
        this.setOut(new PyFile(outStream));
    }

    public void setErr(PyObject outStream) {
        this.systemState.stderr = outStream;
    }

    @Deprecated
    public void setErr(Writer outStream) {
        this.setErr(new PyFileWriter(outStream));
    }

    public void setErr(OutputStream outStream) {
        this.setErr(new PyFile(outStream));
    }

    public PyObject eval(String s) {
        this.setState();
        return __builtin__.eval(new PyString(s), this.locals);
    }

    public void exec(String s) {
        this.setState();
        Py.exec(Py.compile_flags(s, "<string>", CompileMode.exec, this.cflags), this.locals, this.locals);
        Py.flushLine();
    }

    public void exec(PyObject code) {
        this.setState();
        Py.exec(code, this.locals, this.locals);
        Py.flushLine();
    }

    public void execfile(String filename) {
        this.setState();
        __builtin__.execfile_flags(filename, this.locals, this.locals, this.cflags);
        Py.flushLine();
    }

    public void execfile(InputStream s) {
        this.execfile(s, "<iostream>");
    }

    public void execfile(InputStream s, String name) {
        this.setState();
        Py.runCode(Py.compile_flags(s, name, CompileMode.exec, this.cflags), this.locals, this.locals);
        Py.flushLine();
    }

    public PyObject getLocals() {
        return this.locals;
    }

    public void setLocals(PyObject d) {
        this.locals = d;
    }

    public void set(String name, Object value) {
        this.locals.__setitem__(name.intern(), Py.java2py(value));
    }

    public void set(String name, PyObject value) {
        this.locals.__setitem__(name.intern(), value);
    }

    public PyObject get(String name) {
        return this.locals.__finditem__(name.intern());
    }

    public <T> T get(String name, Class<T> javaclass) {
        PyObject val = this.locals.__finditem__(name.intern());
        if (val == null) {
            return null;
        }
        return Py.tojava(val, javaclass);
    }

    public void cleanup() {
        this.systemState.callExitFunc();
        try {
            Py.getSystemState().stdout.invoke("flush");
        }
        catch (PyException pye) {
            // empty catch block
        }
        try {
            Py.getSystemState().stderr.invoke("flush");
        }
        catch (PyException pyException) {
            // empty catch block
        }
    }
}

