/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = System.getProperty("file.separator");

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        boolean bl;
        boolean bl2 = bl = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (bl) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        long l;
        Object object;
        Object object2;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l2 = this.parent.topHandle();
        long l3 = OS.gtk_file_chooser_dialog_new(byArray, l2, 2, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L);
        long l4 = OS.gtk_window_get_icon_list(l2);
        if (l4 != 0L) {
            OS.gtk_window_set_icon_list(l3, l4);
            OS.g_list_free(l4);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            object2 = new StringBuffer();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                ((StringBuffer)object2).append(SEPARATOR);
            }
            ((StringBuffer)object2).append(this.filterPath);
            object = Converter.wcsToMbcs(null, ((StringBuffer)object2).toString(), true);
            long l5 = OS.realpath((byte[])object, null);
            if (l5 != 0L) {
                OS.gtk_file_chooser_set_current_folder(l3, l5);
                OS.g_free(l5);
            }
        }
        if (this.message.length() > 0) {
            long l6;
            object2 = Converter.wcsToMbcs(null, this.message, true);
            long l7 = OS.gtk_hbox_new(false, 0);
            if (l7 == 0L) {
                this.error(2);
            }
            if ((l6 = OS.gtk_label_new((byte[])object2)) == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(l7, l6);
            OS.gtk_widget_show(l6);
            OS.gtk_label_set_line_wrap(l6, true);
            OS.gtk_label_set_justify(l6, 2);
            OS.gtk_file_chooser_set_extra_widget(l3, l7);
        }
        object2 = null;
        object = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        ((Display)object).addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l3)) {
            dialog = ((Display)object).getModalDialog();
            ((Display)object).setModalDialog(this);
        }
        int n = 0;
        long l8 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l8 = OS.g_signal_add_emission_hook(n, 0, ((Display)object).emissionProc, l3, 0L);
        }
        int n2 = OS.gtk_dialog_run(l3);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l8);
        }
        if (OS.gtk_window_get_modal(l3)) {
            ((Display)object).setModalDialog(dialog);
        }
        if (n2 == -5 && (l = OS.gtk_file_chooser_get_filename(l3)) != 0L) {
            long l9 = OS.g_filename_to_utf8(l, -1L, null, null, null);
            OS.g_free(l);
            if (l9 != 0L) {
                long[] lArray = new long[1];
                long l10 = OS.g_utf8_to_utf16(l9, -1L, null, lArray, null);
                OS.g_free(l9);
                if (l10 != 0L) {
                    int n3 = (int)lArray[0];
                    char[] cArray = new char[n3];
                    OS.memmove(cArray, l10, (long)(n3 * 2));
                    OS.g_free(l10);
                    this.filterPath = object2 = new String(cArray);
                }
            }
        }
        ((Display)object).removeIdleProc();
        OS.gtk_widget_destroy(l3);
        return object2;
    }

    String openClassicDialog() {
        long l;
        long l2;
        Object object;
        long l3;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l4 = OS.gtk_file_selection_new(byArray);
        if (this.parent != null) {
            long l5 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l4, l5);
            l3 = OS.gtk_window_get_icon_list(l5);
            if (l3 != 0L) {
                OS.gtk_window_set_icon_list(l4, l3);
                OS.g_list_free(l3);
            }
        }
        String string = null;
        if (this.filterPath != null) {
            object = this.filterPath;
            if (((String)object).length() > 0 && !((String)object).endsWith(SEPARATOR)) {
                object = String.valueOf(object) + SEPARATOR;
            }
            int n = ((String)object).length();
            char[] cArray = new char[n + 1];
            ((String)object).getChars(0, n, cArray, 0);
            long l6 = OS.g_utf16_to_utf8(cArray, -1L, null, null, null);
            long l7 = OS.g_filename_from_utf8(l6, -1L, null, null, null);
            OS.gtk_file_selection_set_filename(l4, l7);
            OS.g_free(l6);
            OS.g_free(l7);
        }
        object = new GtkFileSelection();
        OS.memmove((GtkFileSelection)object, l4);
        OS.gtk_file_selection_hide_fileop_buttons(l4);
        l3 = OS.gtk_widget_get_parent(((GtkFileSelection)object).file_list);
        OS.gtk_widget_hide(((GtkFileSelection)object).file_list);
        OS.gtk_widget_hide(l3);
        if (this.message.length() > 0) {
            byte[] byArray2 = Converter.wcsToMbcs(null, this.message, true);
            long l8 = OS.gtk_label_new(byArray2);
            OS.gtk_label_set_line_wrap(l8, true);
            OS.gtk_misc_set_alignment(l8, 0.0f, 0.0f);
            OS.gtk_container_add(((GtkFileSelection)object).main_vbox, l8);
            OS.gtk_box_set_child_packing(((GtkFileSelection)object).main_vbox, l8, false, false, 0, 0);
            OS.gtk_widget_show(l8);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l4)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l9 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l9 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l4, 0L);
        }
        int n2 = OS.gtk_dialog_run(l4);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l9);
        }
        if (OS.gtk_window_get_modal(l4)) {
            display.setModalDialog(dialog);
        }
        if (n2 == -5 && (l2 = OS.g_filename_to_utf8(l = OS.gtk_file_selection_get_filename(l4), -1L, null, null, null)) != 0L) {
            long[] lArray = new long[1];
            long l10 = OS.g_utf8_to_utf16(l2, -1L, null, lArray, null);
            if (l10 != 0L) {
                int n3 = (int)lArray[0];
                char[] cArray = new char[n3];
                OS.memmove(cArray, l10, (long)(n3 * 2));
                String string2 = new String(cArray);
                if (string2 != null) {
                    if (!string2.equals(SEPARATOR) && string2.endsWith(SEPARATOR)) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    string = this.filterPath = string2;
                }
                OS.g_free(l10);
            }
            OS.g_free(l2);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l4);
        return string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

