/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static long GTKCLIPBOARD = OS.gtk_clipboard_get(0L);
    static long GTKPRIMARYCLIPBOARD;
    private static long TARGET;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = Converter.wcsToMbcs(null, "PRIMARY", true);
        long l = OS.gdk_atom_intern(byArray, false);
        GTKPRIMARYCLIPBOARD = OS.gtk_clipboard_get(l);
        byArray = Converter.wcsToMbcs(null, "TARGETS", true);
        TARGET = OS.gdk_atom_intern(byArray, false);
    }

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n) {
        this.checkWidget();
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        clipboardProxy.clear(this, n);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int n) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        long l = 0L;
        int[] nArray = transfer.getTypeIds();
        int n2 = 0;
        while (n2 < nArray.length) {
            if ((n & 1) != 0) {
                l = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, nArray[n2]);
            }
            if (l != 0L) break;
            if ((n & 2) != 0) {
                l = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, nArray[n2]);
            }
            ++n2;
        }
        if (l == 0L) {
            return null;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, l, (long)GtkSelectionData.sizeof);
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.type;
        transferData.pValue = gtkSelectionData.data;
        transferData.length = gtkSelectionData.length;
        transferData.format = gtkSelectionData.format;
        Object object = transfer.nativeToJava(transferData);
        OS.gtk_selection_data_free(l);
        return object;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == null || transferArray[n2] == null || !transferArray[n2].validate(objectArray[n2])) {
                DND.error(5);
            }
            ++n2;
        }
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        if (!clipboardProxy.setData(this, objectArray, transferArray, n)) {
            DND.error(2002);
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n) {
        int n2;
        int[] nArray;
        this.checkWidget();
        TransferData[] transferDataArray = null;
        if ((n & 1) != 0) {
            nArray = this.getAvailableClipboardTypes();
            transferDataArray = new TransferData[nArray.length];
            n2 = 0;
            while (n2 < nArray.length) {
                transferDataArray[n2] = new TransferData();
                transferDataArray[n2].type = nArray[n2];
                ++n2;
            }
        }
        if ((n & 2) != 0) {
            nArray = this.getAvailablePrimaryTypes();
            n2 = 0;
            if (transferDataArray != null) {
                TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + nArray.length];
                System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                n2 = transferDataArray.length;
                transferDataArray = transferDataArray2;
            } else {
                transferDataArray = new TransferData[nArray.length];
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                transferDataArray[n2 + n3] = new TransferData();
                transferDataArray[n2 + n3].type = nArray[n3];
                ++n3;
            }
        }
        return transferDataArray == null ? new TransferData[]{} : transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        byte[] byArray;
        long l;
        this.checkWidget();
        int[] nArray = this.getAvailableClipboardTypes();
        int[] nArray2 = this.getAvailablePrimaryTypes();
        String[] stringArray = new String[nArray.length + nArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            l = OS.gdk_atom_name(nArray[n2]);
            if (l != 0L) {
                byArray = new byte[OS.strlen(l)];
                OS.memmove(byArray, l, (long)byArray.length);
                OS.g_free(l);
                stringArray[n++] = "GTKCLIPBOARD " + new String(Converter.mbcsToWcs(null, byArray));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray2.length) {
            l = OS.gdk_atom_name(nArray2[n2]);
            if (l != 0L) {
                byArray = new byte[OS.strlen(l)];
                OS.memmove(byArray, l, (long)byArray.length);
                OS.g_free(l);
                stringArray[n++] = "GTKPRIMARYCLIPBOARD " + new String(Converter.mbcsToWcs(null, byArray));
            }
            ++n2;
        }
        if (n < stringArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] getAvailablePrimaryTypes() {
        int[] nArray = new int[]{};
        long l = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, TARGET);
        if (l == 0L) return nArray;
        try {
            GtkSelectionData gtkSelectionData = new GtkSelectionData();
            OS.memmove(gtkSelectionData, l, (long)GtkSelectionData.sizeof);
            if (gtkSelectionData.length != 0) {
                nArray = new int[gtkSelectionData.length * 8 / gtkSelectionData.format];
                OS.memmove(nArray, gtkSelectionData.data, (long)gtkSelectionData.length);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            OS.gtk_selection_data_free(l);
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        OS.gtk_selection_data_free(l);
        return nArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] getAvailableClipboardTypes() {
        int[] nArray = new int[]{};
        long l = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, TARGET);
        if (l == 0L) return nArray;
        try {
            GtkSelectionData gtkSelectionData = new GtkSelectionData();
            OS.memmove(gtkSelectionData, l, (long)GtkSelectionData.sizeof);
            if (gtkSelectionData.length != 0) {
                nArray = new int[gtkSelectionData.length * 8 / gtkSelectionData.format];
                OS.memmove(nArray, gtkSelectionData.data, (long)gtkSelectionData.length);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            OS.gtk_selection_data_free(l);
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        OS.gtk_selection_data_free(l);
        return nArray;
    }

    long gtk_clipboard_wait_for_contents(long l, long l2) {
        String string = "org.eclipse.swt.internal.gtk.dispatchEvent";
        Display display = this.display;
        display.setData(string, new int[]{16, 17, 18, 19});
        long l3 = OS.gtk_clipboard_wait_for_contents(l, l2);
        display.setData(string, null);
        return l3;
    }
}

