/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlTabInfoRecV1;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    static final int EXTRA_WIDTH = 25;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, n2);
    }

    int calculateWidth(GC gC) {
        int n = 0;
        Image image = this.getImage();
        String string = this.getText();
        if (image != null) {
            n = image.getBounds().width + 2;
        }
        if (string != null && string.length() > 0) {
            n += gC.stringExtent((String)string).x;
        }
        return n + 25;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = OS.NewRgn();
        OS.GetControlRegion(this.parent.handle, (short)(n + 1), n2);
        Rect rect = new Rect();
        OS.GetRegionBounds(n2, rect);
        OS.DisposeRgn(n2);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n = this.parent.indexOf(this);
        if (n != this.parent.getSelectionIndex()) {
            if (control3 != null) {
                control3.setVisible(false);
            }
            return;
        }
        if (control3 != null) {
            control3.setBounds(this.parent.getClientArea());
            control3.setVisible(true);
        }
        if (control2 != null) {
            control2.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setImage(image);
        ControlButtonContentInfo controlButtonContentInfo = new ControlButtonContentInfo();
        if (image == null) {
            controlButtonContentInfo.contentType = 0;
        } else {
            controlButtonContentInfo.contentType = (short)134;
            controlButtonContentInfo.iconRef = image.handle;
        }
        OS.SetControlData(this.parent.handle, n + 1, 1668247156, 6, controlButtonContentInfo);
        this.parent.redraw();
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n2 = this.fixMnemonic(cArray);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, n2);
        if (n3 == 0) {
            this.error(13);
        }
        ControlTabInfoRecV1 controlTabInfoRecV1 = new ControlTabInfoRecV1();
        controlTabInfoRecV1.version = 1;
        controlTabInfoRecV1.iconSuiteID = 0;
        controlTabInfoRecV1.name = n3;
        OS.SetControlData(this.parent.handle, n + 1, 1952539241, 8, controlTabInfoRecV1);
        OS.CFRelease(n3);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void update() {
        this.setText(this.text);
        this.setImage(this.image);
        this.setToolTipText(this.toolTipText);
    }
}

