/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int handle;
    public int data;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int n, int n2) {
        super(device);
        this.init(n, n2);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        int n2;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = image.type;
        int n3 = OS.CGImageGetWidth(image.handle);
        int n4 = OS.CGImageGetHeight(image.handle);
        int n5 = OS.CGImageGetBytesPerRow(image.handle);
        int n6 = OS.CGImageGetBitsPerComponent(image.handle);
        int n7 = OS.CGImageGetBitsPerPixel(image.handle);
        int n8 = OS.CGImageGetColorSpace(image.handle);
        int n9 = 6;
        n9 = OS.CGImageGetAlphaInfo(image.handle);
        this.transparentPixel = image.transparentPixel;
        this.alpha = image.alpha;
        if (image.alphaData != null) {
            this.alphaData = new byte[image.alphaData.length];
            System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        int n10 = n4 * n5;
        this.data = OS.NewPtr(n10);
        if (this.data == 0) {
            SWT.error(2);
        }
        if ((n2 = OS.CGDataProviderCreateWithData(0, this.data, n10, device.releaseProc)) == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        this.handle = OS.CGImageCreate(n3, n4, n6, n7, n5, n8, n9, n2, null, true, 0);
        OS.CGDataProviderRelease(n2);
        if (this.handle == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        OS.memmove(this.data, image.data, n10);
        if (n != 0) {
            switch (n) {
                case 1: {
                    Color color = device.getSystemColor(18);
                    RGB rGB = color.getRGB();
                    byte by = (byte)rGB.red;
                    byte by2 = (byte)rGB.green;
                    byte by3 = (byte)rGB.blue;
                    Color color2 = device.getSystemColor(22);
                    RGB rGB2 = color2.getRGB();
                    byte by4 = (byte)rGB2.red;
                    byte by5 = (byte)rGB2.green;
                    byte by6 = (byte)rGB2.blue;
                    byte[] byArray = new byte[n5];
                    int n11 = 0;
                    while (n11 < n4) {
                        OS.memmove(byArray, this.data + n11 * n5, n5);
                        int n12 = 0;
                        int n13 = 0;
                        while (n13 < n3) {
                            int n14 = byArray[n12 + 1] & 0xFF;
                            int n15 = byArray[n12 + 2] & 0xFF;
                            int n16 = byArray[n12 + 3] & 0xFF;
                            int n17 = n14 * n14 + n15 * n15 + n16 * n16;
                            if (n17 < 98304) {
                                byArray[n12 + 1] = by;
                                byArray[n12 + 2] = by2;
                                byArray[n12 + 3] = by3;
                            } else {
                                byArray[n12 + 1] = by4;
                                byArray[n12 + 2] = by5;
                                byArray[n12 + 3] = by6;
                            }
                            n12 += 4;
                            ++n13;
                        }
                        OS.memmove(this.data + n11 * n5, byArray, n5);
                        ++n11;
                    }
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n5];
                    int n18 = 0;
                    while (n18 < n4) {
                        OS.memmove(byArray, this.data + n18 * n5, n5);
                        int n19 = 0;
                        int n20 = 0;
                        while (n20 < n3) {
                            byte by;
                            int n21 = byArray[n19 + 1] & 0xFF;
                            int n22 = byArray[n19 + 2] & 0xFF;
                            int n23 = byArray[n19 + 3] & 0xFF;
                            byte by7 = by = (byte)(n21 + n21 + n22 + n22 + n22 + n22 + n22 + n23 >> 3);
                            byArray[n19 + 3] = by7;
                            byArray[n19 + 2] = by7;
                            byArray[n19 + 1] = by7;
                            n19 += 4;
                            ++n20;
                        }
                        OS.memmove(this.data + n18 * n5, byArray, n5);
                        ++n18;
                    }
                    break;
                }
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(imageData3);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.init(new ImageData(inputStream));
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        this.init(new ImageData(string));
        this.init();
    }

    void createAlpha() {
        if (this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
            return;
        }
        int n = OS.CGImageGetHeight(this.handle);
        int n2 = OS.CGImageGetBytesPerRow(this.handle);
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, this.data, n3);
        if (this.transparentPixel != -1) {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                byArray[n4] = (byte)(n5 == this.transparentPixel ? 0 : 255);
                n4 += 4;
            }
        } else if (this.alpha != -1) {
            byte by = (byte)this.alpha;
            int n6 = 0;
            while (n6 < n3) {
                byArray[n6] = by;
                n6 += 4;
            }
        } else {
            int n7 = OS.CGImageGetWidth(this.handle);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n) {
                int n11 = 0;
                while (n11 < n7) {
                    byArray[n8] = this.alphaData[n9];
                    n8 += 4;
                    ++n9;
                    ++n11;
                }
                ++n10;
            }
        }
        OS.memmove(this.data, byArray, n3);
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        OS.CGImageRelease(this.handle);
        this.handle = 0;
        this.data = 0;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle && this.transparentPixel == image.transparentPixel;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n = this.transparentPixel >> 16 & 0xFF;
        int n2 = this.transparentPixel >> 8 & 0xFF;
        int n3 = this.transparentPixel >> 0 & 0xFF;
        return Color.carbon_new(this.device, new float[]{(float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f});
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        this.width = OS.CGImageGetWidth(this.handle);
        this.height = OS.CGImageGetHeight(this.handle);
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        int n;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int n2 = OS.CGImageGetWidth(this.handle);
        int n3 = OS.CGImageGetHeight(this.handle);
        int n4 = OS.CGImageGetBytesPerRow(this.handle);
        int n5 = OS.CGImageGetBitsPerPixel(this.handle);
        int n6 = n3 * n4;
        byte[] byArray = new byte[n6];
        OS.memmove(byArray, this.data, n6);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n2, n3, n5, paletteData);
        imageData.data = byArray;
        imageData.bytesPerLine = n4;
        imageData.transparentPixel = this.transparentPixel;
        if (this.transparentPixel == -1 && this.type == 1) {
            n = 2;
            int n7 = ((n2 + 7) / 8 + (n - 1)) / n * n;
            byte[] byArray2 = new byte[n3 * n7];
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = 0;
                while (n11 < n2) {
                    if (byArray[n8] != 0) {
                        int n12 = n9 + (n11 >> 3);
                        byArray2[n12] = (byte)(byArray2[n12] | 1 << 7 - (n11 & 7));
                    } else {
                        int n13 = n9 + (n11 >> 3);
                        byArray2[n13] = (byte)(byArray2[n13] & ~(1 << 7 - (n11 & 7)));
                    }
                    n8 += 4;
                    ++n11;
                }
                n9 += n7;
                ++n10;
            }
            imageData.maskData = byArray2;
            imageData.maskPad = n;
        }
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            n += 4;
        }
        imageData.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            imageData.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
        }
        return imageData;
    }

    public static Image carbon_new(Device device, int n, int n2, int n3) {
        Image image = new Image(device);
        image.type = n;
        image.handle = n2;
        image.data = n3;
        return image;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        int n6 = n * 4;
        int n7 = n2 * n6;
        this.data = OS.NewPtr(n7);
        if (this.data == 0) {
            SWT.error(2);
        }
        if ((n5 = OS.CGDataProviderCreateWithData(0, this.data, n7, this.device.releaseProc)) == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        int n8 = this.device.colorspace;
        this.handle = OS.CGImageCreate(n, n2, 8, 32, n6, n8, 6, n5, null, true, 0);
        OS.CGDataProviderRelease(n5);
        if (this.handle == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        if ((n4 = OS.CGBitmapContextCreate(this.data, n, n2, n3 = OS.CGImageGetBitsPerComponent(this.handle), n6, n8, 6)) == 0) {
            OS.CGImageRelease(this.handle);
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        CGRect cGRect = new CGRect();
        cGRect.width = n;
        cGRect.height = n2;
        OS.CGContextSetRGBFillColor(n4, 1.0f, 1.0f, 1.0f, 1.0f);
        OS.CGContextFillRect(n4, cGRect);
        OS.CGContextRelease(n4);
    }

    void init(ImageData imageData) {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        int n3;
        if (imageData == null) {
            SWT.error(4);
        }
        int n4 = imageData.width;
        int n5 = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        int n6 = n4 * n5 * 4;
        this.data = OS.NewPtr(n6);
        if (this.data == 0) {
            SWT.error(2);
        }
        if ((n3 = OS.CGDataProviderCreateWithData(0, this.data, n6, this.device.releaseProc)) == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        int n7 = this.device.colorspace;
        int n8 = imageData.getTransparencyType();
        int n9 = n8 == 0 && imageData.alpha == -1 ? 6 : 4;
        this.handle = OS.CGImageCreate(n4, n5, 8, 32, n4 * 4, n7, n9, n3, null, true, 0);
        OS.CGDataProviderRelease(n3);
        if (this.handle == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        int n10 = n4 * 4;
        byte[] byArray = new byte[n6];
        if (paletteData.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n4, n5, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 32, n10, 1, 0, 0, n4, n5, 0xFF0000, 65280, 255, false, false);
        } else {
            object3 = paletteData.getRGBs();
            n2 = ((RGB[])object3).length;
            byte[] byArray2 = new byte[n2];
            object2 = new byte[n2];
            object = new byte[n2];
            n = 0;
            while (n < ((RGB[])object3).length) {
                RGB rGB = object3[n];
                if (rGB != null) {
                    byArray2[n] = (byte)rGB.red;
                    object2[n] = (byte)rGB.green;
                    object[n] = (byte)rGB.blue;
                }
                ++n;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n4, n5, byArray2, object2, object, 255, null, 0, 0, 0, byArray, 32, n10, 1, 0, 0, n4, n5, 0xFF0000, 65280, 255, false, false);
        }
        if (n8 == 2 || imageData.transparentPixel != -1) {
            int n11 = this.type = imageData.transparentPixel != -1 ? 0 : 1;
            if (imageData.transparentPixel != -1) {
                int n12 = 0;
                n2 = 0;
                int n13 = 0;
                if (paletteData.isDirect) {
                    object2 = paletteData.getRGB(imageData.transparentPixel);
                    n12 = object2.red;
                    n2 = object2.green;
                    n13 = object2.blue;
                } else {
                    object2 = paletteData.getRGBs();
                    if (imageData.transparentPixel < ((byte[])object2).length) {
                        object = object2[imageData.transparentPixel];
                        n12 = object.red;
                        n2 = object.green;
                        n13 = object.blue;
                    }
                }
                this.transparentPixel = n12 << 16 | n2 << 8 | n13;
            }
            object3 = imageData.getTransparencyMask();
            byte[] byArray3 = object3.data;
            int n14 = object3.bytesPerLine;
            int n15 = 0;
            int n16 = 0;
            n = 0;
            while (n < n5) {
                int n17 = 0;
                while (n17 < n4) {
                    byArray[n15] = (byArray3[n16 + (n17 >> 3)] & 1 << 7 - (n17 & 7)) != 0 ? -1 : 0;
                    n15 += 4;
                    ++n17;
                }
                n16 += n14;
                ++n;
            }
        } else {
            this.type = 0;
            if (imageData.alpha != -1) {
                this.alpha = imageData.alpha;
                byte by = (byte)this.alpha;
                n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = by;
                    n2 += 4;
                }
            } else if (imageData.alphaData != null) {
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                int n18 = 0;
                n2 = 0;
                int n19 = 0;
                while (n19 < n5) {
                    int n20 = 0;
                    while (n20 < n4) {
                        byArray[n18] = this.alphaData[n2];
                        n18 += 4;
                        ++n2;
                        ++n20;
                    }
                    ++n19;
                }
            }
        }
        OS.memmove(this.data, byArray, n6);
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        if ((n6 = OS.CGBitmapContextCreate(this.data, n5 = OS.CGImageGetWidth(this.handle), n4 = OS.CGImageGetHeight(this.handle), n3 = OS.CGImageGetBitsPerComponent(this.handle), n2 = OS.CGImageGetBytesPerRow(this.handle), n = OS.CGImageGetColorSpace(this.handle), 6)) == 0) {
            SWT.error(2);
        }
        OS.CGContextScaleCTM(n6, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(n6, 0.0f, -n4);
        if (gCData != null) {
            int n7 = 0x6000000;
            if ((gCData.style & n7) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.background = this.device.COLOR_WHITE.handle;
            gCData.foreground = this.device.COLOR_BLACK.handle;
            gCData.font = this.device.systemFont;
            gCData.image = this;
        }
        return n6;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.CGContextRelease(n);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        byte by = (byte)(this.transparentPixel >> 16 & 0xFF);
        byte by2 = (byte)(this.transparentPixel >> 8 & 0xFF);
        byte by3 = (byte)(this.transparentPixel >> 0 & 0xFF);
        byte by4 = (byte)((int)(color.handle[0] * 255.0f) & 0xFF);
        byte by5 = (byte)((int)(color.handle[1] * 255.0f) & 0xFF);
        byte by6 = (byte)((int)(color.handle[2] * 255.0f) & 0xFF);
        int n = OS.CGImageGetHeight(this.handle);
        int n2 = OS.CGImageGetBytesPerRow(this.handle);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            OS.memmove(byArray, this.data + n4, n2);
            int n5 = 0;
            while (n5 < byArray.length) {
                if (byArray[n5 + 1] == by && byArray[n5 + 2] == by2 && byArray[n5 + 3] == by3) {
                    byArray[n5 + 1] = by4;
                    byArray[n5 + 2] = by5;
                    byArray[n5 + 3] = by6;
                }
                n5 += 4;
            }
            OS.memmove(this.data + n4, byArray, n2);
            ++n3;
            n4 += n2;
        }
        this.transparentPixel = (by4 & 0xFF) << 16 | (by5 & 0xFF) << 8 | by6 & 0xFF;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

