/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;

public final class Font
extends Resource {
    public int handle;
    public short style;
    public float size;
    public int atsuiStyle;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fontData) {
        super(device);
        if (fontData == null) {
            SWT.error(4);
        }
        this.init(fontData.getName(), fontData.getHeightF(), fontData.getStyle(), fontData.atsName);
        this.init();
    }

    public Font(Device device, FontData[] fontDataArray) {
        super(device);
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        int n = 0;
        while (n < fontDataArray.length) {
            if (fontDataArray[n] == null) {
                SWT.error(5);
            }
            ++n;
        }
        FontData fontData = fontDataArray[0];
        this.init(fontData.getName(), fontData.getHeightF(), fontData.getStyle(), fontData.atsName);
        this.init();
    }

    public Font(Device device, String string, int n, int n2) {
        super(device);
        this.init(string, n, n2, null);
        this.init();
    }

    Font(Device device, String string, float f, int n) {
        super(device);
        this.init(string, f, n, null);
        this.init();
    }

    int createStyle() {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4 = new int[1];
        OS.ATSUCreateStyle(nArray4);
        if (nArray4[0] == 0) {
            SWT.error(2);
        }
        int n = nArray4[0];
        boolean bl = this.style != 0;
        int n2 = OS.NewPtr(8 + (bl ? 8 : 0));
        OS.memmove(n2, new int[]{OS.FMGetFontFromATSFontRef(this.handle)}, 4);
        OS.memmove(n2 + 4, new int[]{OS.X2Fix(this.size)}, 4);
        if (bl) {
            OS.memmove(n2 + 8, new byte[]{(this.style & 1) != 0 ? (byte)1 : 0}, 1);
            OS.memmove(n2 + 9, new byte[]{(this.style & 2) != 0 ? (byte)1 : 0}, 1);
            nArray3 = new int[]{261, 262, 256, 257};
            nArray2 = new int[]{4, 4, 1, 1};
            nArray = new int[]{n2, n2 + 4, n2 + 8, n2 + 9};
        } else {
            nArray3 = new int[]{261, 262};
            nArray2 = new int[]{4, 4};
            nArray = new int[]{n2, n2 + 4};
        }
        OS.ATSUSetAttributes(n, nArray3.length, nArray3, nArray2, nArray);
        OS.DisposePtr(n2);
        short[] sArray = new short[]{1, 1, 1, 1, 1, 1, 1, 1};
        short[] sArray2 = new short[]{1, 3, 5, 7, 9, 11, 13, 15, 17};
        OS.ATSUSetFontFeatures(n, sArray.length, sArray, sArray2);
        return n;
    }

    void destroy() {
        if (this.handle == 0) {
            return;
        }
        this.handle = 0;
        if (this.atsuiStyle != 0) {
            OS.ATSUDisposeStyle(this.atsuiStyle);
        }
        this.atsuiStyle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.handle == font.handle && this.size == font.size;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] nArray = new int[1];
        OS.ATSFontGetName(this.handle, 0, nArray);
        CFRange cFRange = new CFRange();
        cFRange.length = OS.CFStringGetLength(nArray[0]);
        char[] cArray = new char[cFRange.length];
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        OS.CFRelease(nArray[0]);
        String string = new String(cArray);
        int n = 0;
        int n2 = 256;
        if (OS.ATSUFindFontName(this.handle, 1, n, -1, -1, 0, null, nArray, null) != 0) {
            n = -1;
            n2 = 0;
            OS.ATSUFindFontName(this.handle, 1, n, -1, -1, 0, null, nArray, null);
        }
        byte[] byArray = new byte[nArray[0]];
        OS.ATSUFindFontName(this.handle, 1, n, -1, -1, byArray.length, byArray, nArray, null);
        String string2 = "";
        int n3 = OS.CFStringCreateWithBytes(0, byArray, byArray.length, n2, false);
        if (n3 != 0) {
            cFRange.length = OS.CFStringGetLength(n3);
            if (cFRange.length != 0) {
                cArray = new char[cFRange.length];
                OS.CFStringGetCharacters(n3, cFRange, cArray);
                string2 = new String(cArray);
            }
            OS.CFRelease(n3);
        }
        int n4 = 0;
        if ((this.style & 2) != 0) {
            n4 |= 2;
        }
        if ((this.style & 1) != 0) {
            n4 |= 1;
        }
        if (string.indexOf("Italic") != -1) {
            n4 |= 2;
        }
        if (string.indexOf("Bold") != -1) {
            n4 |= 1;
        }
        int n5 = this.device.getDPI().y;
        int n6 = this.getScreenDPI().y;
        FontData fontData = new FontData(string2, this.size * (float)n6 / (float)n5, n4);
        fontData.atsName = string;
        return new FontData[]{fontData};
    }

    Point getScreenDPI() {
        int n = OS.GetMainDevice();
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        OS.memmove(nArray, gDevice.gdPMap, 4);
        PixMap pixMap = new PixMap();
        OS.memmove(pixMap, nArray[0], 50);
        return new Point(OS.Fix2Long(pixMap.hRes), OS.Fix2Long(pixMap.vRes));
    }

    public static Font carbon_new(Device device, int n, short s, float f) {
        Font font = new Font(device);
        font.handle = n;
        font.style = s;
        font.size = f;
        return font;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(String string, float f, int n, String string2) {
        int n2;
        if (string == null) {
            SWT.error(4);
        }
        if (f < 0.0f) {
            SWT.error(5);
        }
        int n3 = 0;
        if (string2 != null) {
            n2 = this.createCFString(string2);
            if (n2 != 0) {
                n3 = OS.ATSFontFindFromName(n2, 0);
                OS.CFRelease(n2);
            }
        } else {
            string2 = string;
            if ((n & 1) != 0) {
                string2 = String.valueOf(string2) + " Bold";
            }
            if ((n & 2) != 0) {
                string2 = String.valueOf(string2) + " Italic";
            }
            if ((n2 = this.createCFString(string2)) != 0) {
                n3 = OS.ATSFontFindFromName(n2, 0);
                OS.CFRelease(n2);
            }
            if (n3 == 0 && (n & 2) != 0) {
                this.style = (short)(this.style | 2);
                string2 = string;
                if ((n & 1) != 0) {
                    string2 = String.valueOf(string2) + " Bold";
                }
                if ((n2 = this.createCFString(string2)) != 0) {
                    n3 = OS.ATSFontFindFromName(n2, 0);
                    OS.CFRelease(n2);
                }
            }
            if (n3 == 0 && (n & 1) != 0) {
                this.style = (short)(this.style | 1);
                string2 = string;
                n2 = this.createCFString(string2);
                if (n2 != 0) {
                    n3 = OS.ATSFontFindFromName(n2, 0);
                    OS.CFRelease(n2);
                }
            }
        }
        n2 = this.device.getDPI().y;
        int n4 = this.getScreenDPI().y;
        this.size = f * (float)n2 / (float)n4;
        if (n3 == 0) {
            Font font = this.device.systemFont;
            this.handle = font.handle;
        } else {
            this.handle = n3;
        }
        this.atsuiStyle = this.createStyle();
    }

    int createCFString(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        return OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

