/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.netbeans.api.visual.border.Border;

public class DashedBorder
implements Border {
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    protected int thickness = 1;
    protected Color color;
    private BasicStroke stroke = BASIC_STROKE;

    public DashedBorder(Color color, float f, float f2) {
        this(color, new float[]{f, f2}, 1);
    }

    public DashedBorder(Color color, float[] fArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid thickness: " + n);
        }
        this.thickness = n;
        this.color = color != null ? color : Color.BLACK;
        this.stroke = new BasicStroke(n, 0, 1, 0.0f, fArray, 0.0f);
    }

    public Insets getInsets() {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.color);
        graphics2D.setStroke(this.stroke);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - this.thickness, rectangle.height - this.thickness);
        graphics2D.setStroke(stroke);
    }

    public boolean isOpaque() {
        return true;
    }
}

