/*
 * YAFFS: Yet another Flash File System . A NAND-flash specific file system.
 *
 * Copyright (C) 2002-2010 Aleph One Ltd.
 *   for Toby Churchill Ltd and Brightstar Engineering
 *
 * Created by Charles Manning <charles@aleph1.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1 as
 * published by the Free Software Foundation.
 *
 * Note: Only YAFFS headers are LGPL, YAFFS C code is covered by GPL.
 */

#ifndef __YAFFS_ALLOCATOR_H__
#define __YAFFS_ALLOCATOR_H__

#include "yaffs_guts.h"

void yaffs_InitialiseRawTnodesAndObjects(yaffs_Device *dev);
void yaffs_DeinitialiseRawTnodesAndObjects(yaffs_Device *dev);

yaffs_Tnode *yaffs_AllocateRawTnode(yaffs_Device *dev);
void yaffs_FreeRawTnode(yaffs_Device *dev, yaffs_Tnode *tn);

yaffs_Object *yaffs_AllocateRawObject(yaffs_Device *dev);
void yaffs_FreeRawObject(yaffs_Device *dev, yaffs_Object *obj);

#endif
