/******************************************************************************
 *
 * Copyright(c) 2007 - 2012 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 *
 ******************************************************************************/


#ifndef	__RT_CHANNELPLAN_H__
#define __RT_CHANNELPLAN_H__

typedef enum _RT_CHANNEL_DOMAIN_NEW
{

	//===== Add new channel plan above this line ===============//

	// For new architecture we define different 2G/5G CH area for all country.
	// 2.4 G only
	RT_CHANNEL_DOMAIN_2G_WORLD_5G_NULL				= 0x20,
	RT_CHANNEL_DOMAIN_2G_ETSI1_5G_NULL				= 0x21,
	RT_CHANNEL_DOMAIN_2G_FCC1_5G_NULL				= 0x22,
	RT_CHANNEL_DOMAIN_2G_MKK1_5G_NULL				= 0x23,
	RT_CHANNEL_DOMAIN_2G_ETSI2_5G_NULL				= 0x24,
	// 2.4 G + 5G type 1
	RT_CHANNEL_DOMAIN_2G_FCC1_5G_FCC1				= 0x25,
	RT_CHANNEL_DOMAIN_2G_WORLD_5G_ETSI1				= 0x26,
	//RT_CHANNEL_DOMAIN_2G_WORLD_5G_ETSI1				= 0x27,
	// .....

	RT_CHANNEL_DOMAIN_MAX_NEW,

}RT_CHANNEL_DOMAIN_NEW, *PRT_CHANNEL_DOMAIN_NEW;


#if 0
#define DOMAIN_CODE_2G_WORLD \
        {1,2,3,4,5,6,7,8,9,10,11,12,13}, 13
#define DOMAIN_CODE_2G_ETSI1 \
        {1,2,3,4,5,6,7,8,9,10,11,12,13}, 13
#define DOMAIN_CODE_2G_ETSI2 \
        {1,2,3,4,5,6,7,8,9,10,11}, 11
#define DOMAIN_CODE_2G_FCC1 \
        {1,2,3,4,5,6,7,8,9,10,11,12,13,14}, 14
#define DOMAIN_CODE_2G_MKK1 \
        {10,11,12,13}, 4

#define DOMAIN_CODE_5G_ETSI1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140}, 19
#define DOMAIN_CODE_5G_ETSI2 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165}, 24
#define DOMAIN_CODE_5G_ETSI3 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,149,153,157,161,165}, 22
#define DOMAIN_CODE_5G_FCC1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165}, 24
#define DOMAIN_CODE_5G_FCC2 \
        {36,40,44,48,149,153,157,161,165}, 9
#define DOMAIN_CODE_5G_FCC3 \
        {36,40,44,48,52,56,60,64,149,153,157,161,165}, 13
#define DOMAIN_CODE_5G_FCC4 \
        {36,40,44,48,52,56,60,64,149,153,157,161}, 12
#define DOMAIN_CODE_5G_FCC5 \
        {149,153,157,161,165}, 5
#define DOMAIN_CODE_5G_FCC6 \
        {36,40,44,48,52,56,60,64}, 8
#define DOMAIN_CODE_5G_FCC7 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 20
#define DOMAIN_CODE_5G_IC1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 20
#define DOMAIN_CODE_5G_KCC1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,149,153,157,161,165}, 20
#define DOMAIN_CODE_5G_MKK1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140}, 19
#define DOMAIN_CODE_5G_MKK2 \
        {36,40,44,48,52,56,60,64}, 8
#define DOMAIN_CODE_5G_MKK3 \
        {100,104,108,112,116,120,124,128,132,136,140}, 11
#define DOMAIN_CODE_5G_NCC1 \
        {56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 24
#define DOMAIN_CODE_5G_NCC2 \
        {56,60,64,149,153,157,161,165}, 8
#define UNDEFINED \
        {0}, 0
#endif

//
//
//
/*

Countries							"Country Abbreviation"	Domain Code					SKU's	Ch# of 20MHz
															2G			5G						Ch# of 40MHz
"Albaniaڥ"					AL													Local Test

"AlgeriaΧQ"					DZ									CE TCF

"Antigua & Barbudawʮq&ڥF"	AG						2G_WORLD					FCC TCF

"Argentinaڧ"					AR						2G_WORLD					Local Test

"ArmeniaȬ"					AM						2G_WORLD					ETSI

"Aruba|ڮq"						AW						2G_WORLD					FCC TCF

"AustraliaDw"						AU						2G_WORLD		5G_ETSI2

"AustriaaQ"						AT						2G_WORLD		5G_ETSI1	CE

"Azerbaijan"				AZ						2G_WORLD					CE TCF

"Bahamasګ"						BS						2G_WORLD

"Barbadosڤڦh"					BB						2G_WORLD					FCC TCF

"BelgiumQ"						BE						2G_WORLD		5G_ETSI1	CE

"Bermudaʼ}F"						BM						2G_WORLD					FCC TCF

"Brazilڦ"						BR						2G_WORLD					Local Test

"BulgariaO[Q"					BG						2G_WORLD		5G_ETSI1	CE

"Canada[j"						CA						2G_FCC1			5G_FCC7		IC / FCC	IC / FCC

"Cayman Islands}Ҹsq"			KY						2G_WORLD		5G_ETSI1	CE

"ChileQ"							CL						2G_WORLD					FCC TCF

"China"							CN						2G_WORLD		5G_FCC5		H?i2002j353?

"Columbiaۤ"					CO						2G_WORLD					Voluntary

"Costa RicaF["				CR						2G_WORLD					FCC TCF

"Cyprus"					CY						2G_WORLD		5G_ETSI1	CE

"Czech J"						CZ						2G_WORLD		5G_ETSI1	CE

"Denmark"						DK						2G_WORLD		5G_ETSI1	CE

"Dominican Republich[@M"	DO						2G_WORLD					FCC TCF

"EgyptJ"	EG	2G_WORLD			CE T												CF

"El Salvadorĺ˦h"				SV						2G_WORLD					Voluntary

"EstoniaRF"					EE						2G_WORLD		5G_ETSI1	CE

"Finland"						FI						2G_WORLD		5G_ETSI1	CE

"Francek"						FR										5G_E		TSI1	CE

"Germanyw"						DE						2G_WORLD		5G_ETSI1	CE

"Greece þ"						GR						2G_WORLD		5G_ETSI1	CE

"Guamq"							GU						2G_WORLD

"Guatemalaʦa"					GT						2G_WORLD

"Haitia"							HT						2G_WORLD					FCC TCF

"HondurasԴ"					HN						2G_WORLD					FCC TCF

"HungaryIQ"						HU						2G_WORLD		5G_ETSI1	CE

"IcelandBq"						IS						2G_WORLD		5G_ETSI1	CE

"IndiaL"							IN						2G_WORLD		5G_FCC3		FCC/CE TCF

"IrelandR"						IE						2G_WORLD		5G_ETSI1	CE

"IsraelHC"						IL										5G_F		CC6	CE TCF

"ItalyqjQ"						IT						2G_WORLD		5G_ETSI1	CE

"Japan饻"							JP						2G_MKK1			5G_MKK1		MKK	MKK

"Korea"							KR						2G_WORLD		5G_KCC1		KCC	KCC

"LatviaԲ"					LV						2G_WORLD		5G_ETSI1	CE

"Lithuania߳{"					LT						2G_WORLD		5G_ETSI1	CE

"Luxembourgc˳"					LU						2G_WORLD		5G_ETSI1	CE

"MalaysiaӦ"					MY						2G_WORLD					Local Test

"MaltaL"						MT						2G_WORLD		5G_ETSI1	CE

"Mexico"						MX						2G_WORLD		5G_FCC3		Local Test

"Morocco"						MA													CE TCF

"Netherlands"					NL						2G_WORLD		5G_ETSI1	CE

"New Zealandæ"					NZ						2G_WORLD		5G_ETSI2

"Norway"						NO						2G_WORLD		5G_ETSI1	CE

"Panamaڮ "						PA						2G_FCC1						Voluntary

"Philippines߻"					PH						2G_WORLD					FCC TCF

"Polandi"						PL						2G_WORLD		5G_ETSI1	CE

"Portugal"					PT						2G_WORLD		5G_ETSI1	CE

"Romaniaù"					RO						2G_WORLD		5G_ETSI1	CE

"RussiaXù"						RU						2G_WORLD		5G_ETSI3	CE TCF

"Saudi ArabiaFaԧB"			SA						2G_WORLD					CE TCF

"Singapores[Y"					SG						2G_WORLD

"SlovakiaJ"					SK						2G_WORLD		5G_ETSI1	CE

"Slovenia"				SI						2G_WORLD		5G_ETSI1	CE

"South AfricanD"					ZA						2G_WORLD					CE TCF

"SpainZ"						ES										5G_ETSI1	CE

"Sweden"						SE						2G_WORLD		5G_ETSI1	CE

"Switzerlandh"					CH						2G_WORLD		5G_ETSI1	CE

"TaiwanOW"						TW						2G_FCC1			5G_NCC1	NCC

"Thailand"						TH						2G_WORLD					FCC/CE TCF

"Turkeygը"						TR						2G_WORLD

"UkraineQJ"						UA						2G_WORLD					Local Test

"United Kingdom^"				GB						2G_WORLD		5G_ETSI1	CE	ETSI

"United States"					US						2G_FCC1			5G_FCC7		FCC	FCC

"Venezuelae"					VE						2G_WORLD		5G_FCC4		FCC TCF

"VietnamVn"						VN						2G_WORLD					FCC/CE TCF



*/

// Counter abbervation.
typedef enum _RT_COUNTRY_DEFINE_NUM
{
	RT_CTRY_AL,				//	"Albaniaڥ"
	RT_CTRY_DZ,             //  "AlgeriaΧQ"
	RT_CTRY_AG,             //  "Antigua & Barbudawʮq&ڥF"
	RT_CTRY_AR,             //  "Argentinaڧ"
	RT_CTRY_AM,             //  "ArmeniaȬ"
	RT_CTRY_AW,             //  "Aruba|ڮq"
	RT_CTRY_AU,             //  "AustraliaDw"
	RT_CTRY_AT,             //  "AustriaaQ"
	RT_CTRY_AZ,             //  "Azerbaijan"
	RT_CTRY_BS,             //  "Bahamasګ"
	RT_CTRY_BB,             //  "Barbadosڤڦh"
	RT_CTRY_BE,             //  "BelgiumQ"
	RT_CTRY_BM,             //  "Bermudaʼ}F"
	RT_CTRY_BR,             //  "Brazilڦ"
	RT_CTRY_BG,             //  "BulgariaO[Q"
	RT_CTRY_CA,             //  "Canada[j"
	RT_CTRY_KY,             //  "Cayman Islands}Ҹsq"
	RT_CTRY_CL,             //  "ChileQ"
	RT_CTRY_CN,             //  "China"
	RT_CTRY_CO,             //  "Columbiaۤ"
	RT_CTRY_CR,             //  "Costa RicaF["
	RT_CTRY_CY,             //  "Cyprus"
	RT_CTRY_CZ,             //  "Czech J"
	RT_CTRY_DK,             //  "Denmark"
	RT_CTRY_DO,             //  "Dominican Republich[@M"
	RT_CTRY_CE,             //  "EgyptJ"	EG	2G_WORLD
	RT_CTRY_SV,             //  "El Salvadorĺ˦h"
	RT_CTRY_EE,             //  "EstoniaRF"
	RT_CTRY_FI,             //  "Finland"
	RT_CTRY_FR,             //  "Francek"
	RT_CTRY_DE,             //  "Germanyw"
	RT_CTRY_GR,             //  "Greece þ"
	RT_CTRY_GU,             //  "Guamq"
	RT_CTRY_GT,             //  "Guatemalaʦa"
	RT_CTRY_HT,             //  "Haitia"
	RT_CTRY_HN,             //  "HondurasԴ"
	RT_CTRY_HU,             //  "HungaryIQ"
	RT_CTRY_IS,             //  "IcelandBq"
	RT_CTRY_IN,             //  "IndiaL"
	RT_CTRY_IE,             //  "IrelandR"
	RT_CTRY_IL,             //  "IsraelHC"
	RT_CTRY_IT,             //  "ItalyqjQ"
	RT_CTRY_JP,             //  "Japan饻"
	RT_CTRY_KR,             //  "Korea"
	RT_CTRY_LV,             //  "LatviaԲ"
	RT_CTRY_LT,             //  "Lithuania߳{"
	RT_CTRY_LU,             //  "Luxembourgc˳"
	RT_CTRY_MY,             //  "MalaysiaӦ"
	RT_CTRY_MT,             //  "MaltaL"
	RT_CTRY_MX,             //  "Mexico"
	RT_CTRY_MA,             //  "Morocco"
	RT_CTRY_NL,             //  "Netherlands"
	RT_CTRY_NZ,             //  "New Zealandæ"
	RT_CTRY_NO,             //  "Norway"
	RT_CTRY_PA,             //  "Panamaڮ "
	RT_CTRY_PH,             //  "Philippines߻"
	RT_CTRY_PL,             //  "Polandi"
	RT_CTRY_PT,             //  "Portugal"
	RT_CTRY_RO,             //  "Romaniaù"
	RT_CTRY_RU,             //  "RussiaXù"
	RT_CTRY_SA,             //  "Saudi ArabiaFaԧB"
	RT_CTRY_SG,             //  "Singapores[Y"
	RT_CTRY_SK,             //  "SlovakiaJ"
	RT_CTRY_SI,             //  "Slovenia"
	RT_CTRY_ZA,             //  "South AfricanD"
	RT_CTRY_ES,             //  "SpainZ"
	RT_CTRY_SE,             //  "Sweden"
	RT_CTRY_CH,             //  "Switzerlandh"
	RT_CTRY_TW,             //  "TaiwanOW"
	RT_CTRY_TH,             //  "Thailand"
	RT_CTRY_TR,             //  "Turkeygը"
	RT_CTRY_UA,             //  "UkraineQJ"
	RT_CTRY_GB,             //  "United Kingdom^"
	RT_CTRY_US,             //  "United States"
	RT_CTRY_VE,             //  "Venezuelae"
	RT_CTRY_VN,             //  "VietnamVn"
	RT_CTRY_MAX,            //

}RT_COUNTRY_NAME, *PRT_COUNTRY_NAME;

// Scan type including active and passive scan.
typedef enum _RT_SCAN_TYPE_NEW
{
	SCAN_NULL,
	SCAN_ACT,
	SCAN_PAS,
	SCAN_BOTH,
}RT_SCAN_TYPE_NEW, *PRT_SCAN_TYPE_NEW;


// Power table sample.

typedef struct _RT_CHNL_PLAN_LIMIT
{
	u2Byte	Chnl_Start;
	u2Byte	Chnl_end;

	u2Byte	Freq_Start;
	u2Byte	Freq_end;
}RT_CHNL_PLAN_LIMIT, *PRT_CHNL_PLAN_LIMIT;


//
// 2.4G Regulatory Domains
//
typedef enum _RT_REGULATION_DOMAIN_2G
{
	RT_2G_NULL,
	RT_2G_WORLD,
	RT_2G_ETSI1,
	RT_2G_FCC1,
	RT_2G_MKK1,
	RT_2G_ETSI2

}RT_REGULATION_2G, *PRT_REGULATION_2G;


//typedef struct _RT_CHANNEL_BEHAVIOR
//{
//	u1Byte	Chnl;
//	RT_SCAN_TYPE_NEW
//
//}RT_CHANNEL_BEHAVIOR, *PRT_CHANNEL_BEHAVIOR;

//typedef struct _RT_CHANNEL_PLAN_TYPE
//{
//	RT_CHANNEL_BEHAVIOR
//	u1Byte					Chnl_num;
//}RT_CHNL_PLAN_TYPE, *PRT_CHNL_PLAN_TYPE;

//
// 2.4G Channel Number
// Channel definition & number
//
#define CHNL_RT_2G_NULL \
        {0}, 0
#define CHNL_RT_2G_WORLD \
        {1,2,3,4,5,6,7,8,9,10,11,12,13}, 13
#define CHNL_RT_2G_WORLD_TEST \
        {1,2,3,4,5,6,7,8,9,10,11,12,13}, 13

#define CHNL_RT_2G_EFSI1 \
        {1,2,3,4,5,6,7,8,9,10,11,12,13}, 13
#define CHNL_RT_2G_FCC1 \
        {1,2,3,4,5,6,7,8,9,10,11}, 11
#define CHNL_RT_2G_MKK1 \
        {1,2,3,4,5,6,7,8,9,10,11,12,13,14}, 14
#define CHNL_RT_2G_ETSI2 \
        {10,11,12,13}, 4

//
// 2.4G Channel Active or passive scan.
//
#define CHNL_RT_2G_NULL_SCAN_TYPE \
        {SCAN_NULL}
#define CHNL_RT_2G_WORLD_SCAN_TYPE \
        {1,1,1,1,1,1,1,1,1,1,1,0,0}
#define CHNL_RT_2G_EFSI1_SCAN_TYPE \
        {1,1,1,1,1,1,1,1,1,1,1,1,1}
#define CHNL_RT_2G_FCC1_SCAN_TYPE \
        {1,1,1,1,1,1,1,1,1,1,1}
#define CHNL_RT_2G_MKK1_SCAN_TYPE \
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1}
#define CHNL_RT_2G_ETSI2_SCAN_TYPE \
        {1,1,1,1}


//
// 2.4G Band & Frequency Section
// Freqency start & end / band number
//
#define FREQ_RT_2G_NULL \
        {0}, 0
        // Passive scan CH 12, 13
#define FREQ_RT_2G_WORLD \
        {2412, 2472}, 1
#define FREQ_RT_2G_EFSI1 \
        {2412, 2472}, 1
#define FREQ_RT_2G_FCC1 \
        {2412, 2462}, 1
#define FREQ_RT_2G_MKK1 \
        {2412, 2484}, 1
#define FREQ_RT_2G_ETSI2 \
        {2457, 2472}, 1


//
// 5G Regulatory Domains
//
typedef enum _RT_REGULATION_DOMAIN_5G
{
	RT_5G_NULL,
	RT_5G_WORLD,
	RT_5G_ETSI1,
	RT_5G_ETSI2,
	RT_5G_ETSI3,
	RT_5G_FCC1,
	RT_5G_FCC2,
	RT_5G_FCC3,
	RT_5G_FCC4,
	RT_5G_FCC5,
	RT_5G_FCC6,
	RT_5G_FCC7,
	RT_5G_IC1,
	RT_5G_KCC1,
	RT_5G_MKK1,
	RT_5G_MKK2,
	RT_5G_MKK3,
	RT_5G_NCC1,

}RT_REGULATION_5G, *PRT_REGULATION_5G;

//
// 5G Channel Number
//
#define CHNL_RT_5G_NULL \
        {0}, 0
#define CHNL_RT_5G_WORLD \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140}, 19
#define CHNL_RT_5G_ETSI1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165}, 24
#define CHNL_RT_5G_ETSI2 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,149,153,157,161,165}, 22
#define CHNL_RT_5G_ETSI3 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165}, 24
#define CHNL_RT_5G_FCC1 \
        {36,40,44,48,149,153,157,161,165}, 9
#define CHNL_RT_5G_FCC2 \
        {36,40,44,48,52,56,60,64,149,153,157,161,165}, 13
#define CHNL_RT_5G_FCC3 \
        {36,40,44,48,52,56,60,64,149,153,157,161}, 12
#define CHNL_RT_5G_FCC4 \
        {149,153,157,161,165}, 5
#define CHNL_RT_5G_FCC5 \
        {36,40,44,48,52,56,60,64}, 8
#define CHNL_RT_5G_FCC6 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 20
#define CHNL_RT_5G_FCC7 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 20
#define CHNL_RT_5G_IC1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,149,153,157,161,165}, 20
#define CHNL_RT_5G_KCC1 \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140}, 19
#define CHNL_RT_5G_MKK1 \
        {36,40,44,48,52,56,60,64}, 8
#define CHNL_RT_5G_MKK2 \
        {100,104,108,112,116,120,124,128,132,136,140}, 11
#define CHNL_RT_5G_MKK3 \
        {56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 24
#define CHNL_RT_5G_NCC1 \
        {56,60,64,149,153,157,161,165}, 8

//
// 5G Channel Active or passive scan.
//
#define CHNL_RT_5G_NULL_SCAN_TYPE \
        {SCAN_NULL}
#define CHNL_RT_5G_WORLD_SCAN_TYPE \
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}
#define CHNL_RT_5G_ETSI1_SCAN_TYPE \
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}
#define CHNL_RT_5G_ETSI2_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,149,153,157,161,165}, 22
#define CHNL_RT_5G_ETSI3_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165}, 24
#define CHNL_RT_5G_FCC1_SCAN_TYPE \
        {36,40,44,48,149,153,157,161,165}, 9
#define CHNL_RT_5G_FCC2_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,149,153,157,161,165}, 13
#define CHNL_RT_5G_FCC3_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,149,153,157,161}, 12
#define CHNL_RT_5G_FCC4_SCAN_TYPE \
        {149,153,157,161,165}, 5
#define CHNL_RT_5G_FCC5_SCAN_TYPE \
        {36,40,44,48,52,56,60,64}, 8
#define CHNL_RT_5G_FCC6_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 20
#define CHNL_RT_5G_FCC7_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 20
#define CHNL_RT_5G_IC1_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,149,153,157,161,165}, 20
#define CHNL_RT_5G_KCC1_SCAN_TYPE \
        {36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140}, 19
#define CHNL_RT_5G_MKK1_SCAN_TYPE \
        {36,40,44,48,52,56,60,64}, 8
#define CHNL_RT_5G_MKK2_SCAN_TYPE \
        {100,104,108,112,116,120,124,128,132,136,140}, 11
#define CHNL_RT_5G_MKK3_SCAN_TYPE \
        {56,60,64,100,104,108,112,116,136,140,149,153,157,161,165}, 24
#define CHNL_RT_5G_NCC1_SCAN_TYPE \
        {56,60,64,149,153,157,161,165}, 8

//
// Global Regulation
//
typedef enum _RT_REGULATION_COMMON
{
	RT_WORLD,
	RT_FCC,
	RT_MKK,
	RT_ETSI,
	RT_IC,
	RT_CE,
	RT_NCC,

}RT_REGULATION_CMN, *PRT_REGULATION_CMN;



//
// Special requirement for different regulation domain.
// For internal test or customerize special request.
//
typedef enum _RT_CHNLPLAN_SREQ
{
	RT_SREQ_NA						= 0x0,
	RT_SREQ_2G_ADHOC_11N			= 0x00000001,
	RT_SREQ_2G_ADHOC_11B			= 0x00000002,
	RT_SREQ_2G_ALL_PASS				= 0x00000004,
	RT_SREQ_2G_ALL_ACT				= 0x00000008,
	RT_SREQ_5G_ADHOC_11N			= 0x00000010,
	RT_SREQ_5G_ADHOC_11AC			= 0x00000020,
	RT_SREQ_5G_ALL_PASS				= 0x00000040,
	RT_SREQ_5G_ALL_ACT				= 0x00000080,
	RT_SREQ_C1_PLAN					= 0x00000100,
	RT_SREQ_C2_PLAN					= 0x00000200,
	RT_SREQ_C3_PLAN					= 0x00000400,
	RT_SREQ_C4_PLAN					= 0x00000800,
	RT_SREQ_NFC_ON					= 0x00001000,
	RT_SREQ_MASK					= 0x0000FFFF,   /* Requirements bit mask */

}RT_CHNLPLAN_SREQ, *PRT_CHNLPLAN_SREQ;


//
// RT_COUNTRY_NAME & RT_REGULATION_2G & RT_REGULATION_5G transfer table
//
//
typedef struct _RT_CHANNEL_PLAN_COUNTRY_TRANSFER_TABLE
{
	//
	// Define countery domain and corresponding
	//
	RT_COUNTRY_NAME		Country_Enum;
	char				Country_Name[3];

	//char		Domain_Name[12];
	RT_REGULATION_2G	Domain_2G;

	RT_REGULATION_5G	Domain_5G;

	RT_CHANNEL_DOMAIN	RtChDomain;
	//u1Byte		Country_Area;

}RT_CHNL_CTRY_TBL, *PRT_CHNL_CTRY_TBL;


#define		RT_MAX_CHNL_NUM_2G		13
#define		RT_MAX_CHNL_NUM_5G		44

// Power table sample.

typedef struct _RT_CHNL_PLAN_PWR_LIMIT
{
	u2Byte	Chnl_Start;
	u2Byte	Chnl_end;
	u1Byte	dB_Max;
	u2Byte	mW_Max;
}RT_CHNL_PWR_LIMIT, *PRT_CHNL_PWR_LIMIT;


#define		RT_MAX_BAND_NUM			5

typedef struct _RT_CHANNEL_PLAN_MAXPWR
{
//	STRING_T
	RT_CHNL_PWR_LIMIT	Chnl[RT_MAX_BAND_NUM];
	u1Byte				Band_Useful_Num;


}RT_CHANNEL_PLAN_MAXPWR, *PRT_CHANNEL_PLAN_MAXPWR;


//
// Power By Rate Table.
//



typedef struct _RT_CHANNEL_PLAN_NEW
{
	//
	// Define countery domain and corresponding
	//
	//char		Country_Name[36];
	//u1Byte		Country_Enum;

	//char		Domain_Name[12];


	PRT_CHNL_CTRY_TBL		pCtryTransfer;

	RT_CHANNEL_DOMAIN		RtChDomain;

	RT_REGULATION_2G		Domain_2G;

	RT_REGULATION_5G		Domain_5G;

	RT_REGULATION_CMN		Regulator;

	RT_CHNLPLAN_SREQ		ChnlSreq;

	//RT_CHNL_PLAN_LIMIT		RtChnl;

	u1Byte	Chnl2G[MAX_CHANNEL_NUM];				// CHNL_RT_2G_WORLD
	u1Byte	Len2G;
	u1Byte	Chnl2GScanTp[MAX_CHANNEL_NUM];			// CHNL_RT_2G_WORLD_SCAN_TYPE
	//u1Byte	Freq2G[2];								// FREQ_RT_2G_WORLD

	u1Byte	Chnl5G[MAX_CHANNEL_NUM];
	u1Byte	Len5G;
	u1Byte	Chnl5GScanTp[MAX_CHANNEL_NUM];
	//u1Byte	Freq2G[2];								// FREQ_RT_2G_WORLD

	RT_CHANNEL_PLAN_MAXPWR	ChnlMaxPwr;


}RT_CHANNEL_PLAN_NEW, *PRT_CHANNEL_PLAN_NEW;


#endif	// __RT_CHANNELPLAN_H__
