/*
 * Copyright 2011, The Android Open Source Project
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef GaneshContext_h
#define GaneshContext_h

#if USE(ACCELERATED_COMPOSITING)

#include "BaseRenderer.h"
#include "GrContext.h"
#include "SkGpuDevice.h"
#include "TilesManager.h"

namespace WebCore {

class GaneshContext {
public:
    static GaneshContext* instance();

    SkDevice* getDeviceForBaseTile(const TileRenderInfo& renderInfo);

    void flush();

private:

    GaneshContext();

    GrContext* getGrContext();

    // Creates a device for rendering into a SurfaceTexture via an EGLSurface
    SkDevice* getDeviceForBaseTileSurface(const TileRenderInfo& renderInfo);
    // Creates a device for rendering into a EGLImage via an FBO
    SkDevice* getDeviceForBaseTileFBO(const TileRenderInfo& renderInfo);

    GrContext* m_grContext;

    // FBO specific variables
    SkGpuDevice* m_baseTileDeviceFBO;
    GLuint m_baseTileFBO;
    GLuint m_baseTileStencil;

    // Surface specific variables
    SkGpuDevice* m_baseTileDeviceSurface;
    EGLConfig  m_surfaceConfig;
    EGLContext m_surfaceContext;

    static GaneshContext* gInstance;
};

} // namespace WebCore

#endif // USE(ACCELERATED_COMPOSITING)
#endif // GaneshContext_h
