/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
#ifndef AV_TEST_H_INCLUDED
#define AV_TEST_H_INCLUDED

#include "test_base.h"


class av_test : public test_base
{
    public:
        av_test(bool aUseProxy = false,
                uint32 aTimeConnection = TEST_DURATION,
                uint32 aMaxTestDuration = MAX_TEST_DURATION)
                : test_base(aUseProxy, aTimeConnection, aMaxTestDuration, 1)
        {
            iUsingAudio = true;
            iUsingVideo = true;
            iTestName = _STRLIT_CHAR("av");
            iAudioSourceAdded = false;
            iAudioSinkAdded = false;
        }

        ~av_test()
        {
        }

        void DoCancel();
        void DisconnectSourceSinks();

        virtual void TimeoutOccurred(int32 timerID, int32 timeoutInfo);
        virtual void FinishTimerCallback();

    protected:
        virtual void AllNodesAdded();
        virtual void AllNodesRemoved();

    private:

};


#endif


