/* ------------------------------------------------------------------
 * Copyright (C) 1998-2010 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
#ifndef PVMF_SM_FSP_BASE_CMDS_H_INCLUDED
#define PVMF_SM_FSP_BASE_CMDS_H_INCLUDED

#define PVMF_SM_FSP_SOCKET_NODE_COMMAND_START              1000
#define PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_COMMAND_START  2000
#define PVMF_SM_FSP_JITTER_BUFFER_CONTROLLER_COMMAND_START 3000
#define PVMF_SM_FSP_MEDIA_LAYER_COMMAND_START              4000
#define PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_COMMAND_START  5000
#define PVMF_SM_FSP_RTPPACKETSOURCE_NODE_COMMAND_START     6000
#define PVMF_SM_FSP_PVR_NODE_COMMAND_START                 7000
#define PVMF_SM_FSP_NODE_COMMAND_ID_START                 10000

#define PVMF_SM_FSP_VECTOR_RESERVE                           10
#define PVMF_SMFSP_INTERNAL_CMDQ_SIZE                        40

///////////////////////////////////////////////
//IDs for all of the asynchronous node commands.
///////////////////////////////////////////////
enum TPVMFSMFSPBaseNodeCommand
{
    /* node interface commands*/
    PVMF_SMFSP_NODE_QUERYINTERFACE = PVMF_GENERIC_NODE_QUERYINTERFACE,
    PVMF_SMFSP_NODE_REQUESTPORT,
    PVMF_SMFSP_NODE_RELEASEPORT,
    PVMF_SMFSP_NODE_INIT,
    PVMF_SMFSP_NODE_PREPARE,
    PVMF_SMFSP_NODE_START,
    PVMF_SMFSP_NODE_STOP,
    PVMF_SMFSP_NODE_FLUSH,
    PVMF_SMFSP_NODE_PAUSE,
    PVMF_SMFSP_NODE_RESET,
    PVMF_SMFSP_NODE_CANCELALLCOMMANDS,
    PVMF_SMFSP_NODE_CANCELCOMMAND,

    /* add extention interface commands */
    PVMF_SMFSP_NODE_SET_DATASOURCE_POSITION = PVMF_GENERIC_NODE_COMMAND_LAST + 1,
    PVMF_SMFSP_NODE_QUERY_DATASOURCE_POSITION,
    PVMF_SMFSP_NODE_SET_DATASOURCE_RATE,
    PVMF_SMFSP_NODE_GETNODEMETADATAKEYS,
    PVMF_SMFSP_NODE_GETNODEMETADATAVALUES,
    PVMF_SMFSP_NODE_CAPCONFIG_SETPARAMS,
    PVMF_SMFSP_NODE_EXTENSION_INTERFACE_COMMAND_LAST,

    /* add commands which are internal to the implementation of Streaming Node and are common for are types of feature specific plugins*/
    PVMF_SMFSP_NODE_CONSTRUCT_SESSION = PVMF_SMFSP_NODE_EXTENSION_INTERFACE_COMMAND_LAST + 1,   //to construct the graph
    PVMF_SMFSP_NODE_CANCEL_DUE_TO_ERROR,
    PVMF_SMFSP_NODE_RESET_DUE_TO_ERROR,
    PVMF_SMFSP_NODE_COMMAND_LAST
};

enum TPVMFSMFSPChildNodeTag
{
    PVMF_SM_FSP_NODE_UNKNOWN = 0,
    PVMF_SM_FSP_SOCKET_NODE = 1,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_NODE = 2,
    PVMF_SM_FSP_JITTER_BUFFER_NODE = 3,
    PVMF_SM_FSP_MEDIA_LAYER_NODE = 4,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_NODE = 5,
    PVMF_SM_FSP_RTPPACKETSOURCE_NODE = 6,
    PVMF_SM_FSP_PVR_NODE = 7,
    PVMF_SM_FSP_RTSP_REAL_CLOAKING_SESSION_CONTROLLER_NODE = 8,
    PVMF_SM_FSP_LAST_CHILD_NODE
};

#define PVMF_SM_FSP_NODE_INTERNAL_QUERY_UUID_CMD_OFFSET       0
#define PVMF_SM_FSP_NODE_INTERNAL_QUERY_INTERFACE_CMD_OFFSET  1
#define PVMF_SM_FSP_NODE_INTERNAL_INIT_CMD_OFFSET             2
#define PVMF_SM_FSP_NODE_INTERNAL_PREPARE_CMD_OFFSET          3
#define PVMF_SM_FSP_NODE_INTERNAL_START_CMD_OFFSET            4
#define PVMF_SM_FSP_NODE_INTERNAL_STOP_CMD_OFFSET             5
#define PVMF_SM_FSP_NODE_INTERNAL_FLUSH_CMD_OFFSET            6
#define PVMF_SM_FSP_NODE_INTERNAL_PAUSE_CMD_OFFSET            7
#define PVMF_SM_FSP_NODE_INTERNAL_RESET_CMD_OFFSET            8
#define PVMF_SM_FSP_NODE_INTERNAL_REQUEST_PORT_OFFSET         9
#define PVMF_SM_FSP_NODE_INTERNAL_RELEASE_PORT_OFFSET         10
#define PVMF_SM_FSP_NODE_INTERNAL_CANCEL_ALL_OFFSET           11
#define PVMF_SM_FSP_NODE_INTERNAL_SEEK_OFFSET                 12
#define PVMF_SM_FSP_NODE_INTERNAL_STREAM_SWITCH_CMD_OFFSET    13
#define PVMF_SM_FSP_NODE_INTERNAL_PLAYLIST_PLAY_CMD_OFFSET    14

enum TPVMFStreamingManagerInternalCommands
{
    PVMF_SM_FSP_INTERNAL_COMMAND_NONE = 0,

    PVMF_SM_FSP_SOCKET_NODE_QUERY_UUID = 1000,
    PVMF_SM_FSP_SOCKET_NODE_QUERY_INTERFACE = 1001,
    PVMF_SM_FSP_SOCKET_NODE_INIT = 1002,
    PVMF_SM_FSP_SOCKET_NODE_PREPARE = 1003,
    PVMF_SM_FSP_SOCKET_NODE_START = 1004,
    PVMF_SM_FSP_SOCKET_NODE_STOP = 1005,
    PVMF_SM_FSP_SOCKET_NODE_FLUSH = 1006,
    PVMF_SM_FSP_SOCKET_NODE_PAUSE = 1007,
    PVMF_SM_FSP_SOCKET_NODE_RESET = 1008,
    PVMF_SM_FSP_SOCKET_NODE_REQUEST_PORT = 1009,
    PVMF_SM_FSP_SOCKET_NODE_RELEASE_PORT = 1010,
    PVMF_SM_FSP_SOCKET_NODE_CANCEL_ALL_COMMANDS = 1011,

    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_QUERY_UUID = 2000,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_QUERY_INTERFACE = 2001,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_INIT = 2002,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_PREPARE = 2003,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_START = 2004,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_STOP = 2005,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_FLUSH = 2006,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_PAUSE = 2007,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_RESET = 2008,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_REQUEST_PORT = 2009,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_RELEASE_PORT = 2010,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_CANCEL_ALL_COMMANDS = 2011,
    PVMF_SM_FSP_RTSP_SESSION_CONTROLLER_PLAYLIST_PLAY = 2014,

    PVMF_SM_FSP_JITTER_BUFFER_QUERY_UUID = 3000,
    PVMF_SM_FSP_JITTER_BUFFER_QUERY_INTERFACE = 3001,
    PVMF_SM_FSP_JITTER_BUFFER_INIT = 3002,
    PVMF_SM_FSP_JITTER_BUFFER_PREPARE = 3003,
    PVMF_SM_FSP_JITTER_BUFFER_START = 3004,
    PVMF_SM_FSP_JITTER_BUFFER_STOP = 3005,
    PVMF_SM_FSP_JITTER_BUFFER_FLUSH = 3006,
    PVMF_SM_FSP_JITTER_BUFFER_PAUSE = 3007,
    PVMF_SM_FSP_JITTER_BUFFER_RESET = 3008,
    PVMF_SM_FSP_JITTER_BUFFER_REQUEST_PORT = 3009,
    PVMF_SM_FSP_JITTER_BUFFER_RELEASE_PORT = 3010,
    PVMF_SM_FSP_JITTER_BUFFER_CANCEL_ALL_COMMANDS = 3011,

    PVMF_SM_FSP_MEDIA_LAYER_QUERY_UUID = 4000,
    PVMF_SM_FSP_MEDIA_LAYER_QUERY_INTERFACE = 4001,
    PVMF_SM_FSP_MEDIA_LAYER_INIT = 4002,
    PVMF_SM_FSP_MEDIA_LAYER_PREPARE = 4003,
    PVMF_SM_FSP_MEDIA_LAYER_START = 4004,
    PVMF_SM_FSP_MEDIA_LAYER_STOP = 4005,
    PVMF_SM_FSP_MEDIA_LAYER_FLUSH = 4006,
    PVMF_SM_FSP_MEDIA_LAYER_PAUSE = 4007,
    PVMF_SM_FSP_MEDIA_LAYER_RESET = 4008,
    PVMF_SM_FSP_MEDIA_LAYER_REQUEST_PORT = 4009,
    PVMF_SM_FSP_MEDIA_LAYER_RELEASE_PORT = 4010,
    PVMF_SM_FSP_MEDIA_LAYER_CANCEL_ALL_COMMANDS = 4011,

    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_QUERY_UUID = 5000,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_QUERY_INTERFACE = 5001,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_INIT = 5002,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_PREPARE = 5003,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_START = 5004,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_STOP = 5005,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_FLUSH = 5006,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_PAUSE = 5007,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_RESET = 5008,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_REQUEST_PORT = 5009,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_RELEASE_PORT = 5010,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_CANCEL_ALL_COMMANDS = 5011,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_SEEK = 5012,
    PVMF_SM_FSP_HTTP_SESSION_CONTROLLER_STREAM_SWITCH = 5013,

    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_QUERY_UUID = 6000,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_QUERY_INTERFACE = 6001,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_INIT = 6002,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_PREPARE = 6003,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_START = 6004,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_STOP = 6005,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_FLUSH = 6006,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_PAUSE = 6007,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_RESET = 6008,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_REQUEST_PORT = 6009,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_RELEASE_PORT = 6010,
    PVMF_SM_FSP_RTP_PACKET_SOURCE_NODE_CANCEL_ALL_COMMANDS = 6011,

    PVMF_SM_FSP_PVR_NODE_QUERY_UUID = 7000,
    PVMF_SM_FSP_PVR_NODE_QUERY_INTERFACE = 7001,
    PVMF_SM_FSP_PVR_NODE_INIT = 7002,
    PVMF_SM_FSP_PVR_NODE_PREPARE = 7003,
    PVMF_SM_FSP_PVR_NODE_START = 7004,
    PVMF_SM_FSP_PVR_NODE_STOP = 7005,
    PVMF_SM_FSP_PVR_NODE_FLUSH = 7006,
    PVMF_SM_FSP_PVR_NODE_PAUSE = 7007,
    PVMF_SM_FSP_PVR_NODE_RESET = 7008,
    PVMF_SM_FSP_PVR_NODE_REQUEST_PORT = 7009,
    PVMF_SM_FSP_PVR_NODE_RELEASE_PORT = 7010,
    PVMF_SM_FSP_PVR_NODE_CANCEL_ALL_COMMANDS = 7011,

    PVMF_SM_FSP_INTERNAL_COMMAND_LAST = 7999
};
#endif

