; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown                        | FileCheck %s --check-prefixes=ANY,STRICT
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -enable-unsafe-fp-math | FileCheck %s --check-prefixes=ANY,UNSAFE

define float @fadd_zero(float %x) {
; STRICT-LABEL: fadd_zero:
; STRICT:       # %bb.0:
; STRICT-NEXT:    xorps %xmm1, %xmm1
; STRICT-NEXT:    addss %xmm1, %xmm0
; STRICT-NEXT:    retq
;
; UNSAFE-LABEL: fadd_zero:
; UNSAFE:       # %bb.0:
; UNSAFE-NEXT:    retq
  %r = fadd float %x, 0.0
  ret float %r
}

define float @fadd_negzero(float %x) {
; STRICT-LABEL: fadd_negzero:
; STRICT:       # %bb.0:
; STRICT-NEXT:    addss {{.*}}(%rip), %xmm0
; STRICT-NEXT:    retq
;
; UNSAFE-LABEL: fadd_negzero:
; UNSAFE:       # %bb.0:
; UNSAFE-NEXT:    retq
  %r = fadd float %x, -0.0
  ret float %r
}

define float @fadd_negzero_nsz(float %x) {
; ANY-LABEL: fadd_negzero_nsz:
; ANY:       # %bb.0:
; ANY-NEXT:    retq
  %r = fadd nsz float %x, -0.0
  ret float %r
}

define float @fadd_zero_nsz(float %x) {
; ANY-LABEL: fadd_zero_nsz:
; ANY:       # %bb.0:
; ANY-NEXT:    retq
  %r = fadd nsz float %x, 0.0
  ret float %r
}

define float @fsub_zero(float %x) {
; ANY-LABEL: fsub_zero:
; ANY:       # %bb.0:
; ANY-NEXT:    retq
  %r = fsub float %x, 0.0
  ret float %r
}

define float @fsub_self(float %x) {
; ANY-LABEL: fsub_self:
; ANY:       # %bb.0:
; ANY-NEXT:    xorps %xmm0, %xmm0
; ANY-NEXT:    retq
  %r = fsub nnan float %x, %x 
  ret float %r
}

define float @fsub_negzero(float %x) {
; STRICT-LABEL: fsub_negzero:
; STRICT:       # %bb.0:
; STRICT-NEXT:    xorps %xmm1, %xmm1
; STRICT-NEXT:    addss %xmm1, %xmm0
; STRICT-NEXT:    retq
;
; UNSAFE-LABEL: fsub_negzero:
; UNSAFE:       # %bb.0:
; UNSAFE-NEXT:    retq
  %r = fsub float %x, -0.0
  ret float %r
}

define float @fsub_zero_nsz_1(float %x) {
; ANY-LABEL: fsub_zero_nsz_1:
; ANY:       # %bb.0:
; ANY-NEXT:    retq
  %r = fsub nsz float %x, 0.0
  ret float %r
}

define float @fsub_zero_nsz_2(float %x) {
; ANY-LABEL: fsub_zero_nsz_2:
; ANY:       # %bb.0:
; ANY-NEXT:    xorps {{.*}}(%rip), %xmm0
; ANY-NEXT:    retq
  %r = fsub nsz float 0.0, %x
  ret float %r
}

define float @fsub_negzero_nsz(float %x) {
; ANY-LABEL: fsub_negzero_nsz:
; ANY:       # %bb.0:
; ANY-NEXT:    retq
  %r = fsub nsz float %x, -0.0
  ret float %r
}

; TODO: handle x*0 for fast flags the same as unsafe
define float @fmul_zero(float %x) {
; STRICT-LABEL: fmul_zero:
; STRICT:       # %bb.0:
; STRICT-NEXT:    xorps %xmm1, %xmm1
; STRICT-NEXT:    mulss %xmm1, %xmm0
; STRICT-NEXT:    retq
;
; UNSAFE-LABEL: fmul_zero:
; UNSAFE:       # %bb.0:
; UNSAFE-NEXT:    xorps %xmm0, %xmm0
; UNSAFE-NEXT:    retq
  %r = fmul nnan nsz float %x, 0.0
  ret float %r
}

define float @fmul_one(float %x) {
; ANY-LABEL: fmul_one:
; ANY:       # %bb.0:
; ANY-NEXT:    retq
  %r = fmul float %x, 1.0
  ret float %r
}
