/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import com.google.analytics.tracking.android.GoogleAnalytics;
import com.google.analytics.tracking.android.Logger;
import com.google.analytics.tracking.android.Tracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Log;
import com.google.tagmanager.Logger;

class TrackerProvider {
    private GoogleAnalytics mGoogleAnalytics;
    private Context mContext;

    TrackerProvider(Context context) {
        this.mContext = context;
    }

    @VisibleForTesting
    TrackerProvider(GoogleAnalytics ga) {
        this.mGoogleAnalytics = ga;
        this.mGoogleAnalytics.setLogger(new LoggerImpl());
    }

    public Tracker getTracker(String trackingId) {
        this.initTrackProviderIfNecessary();
        return this.mGoogleAnalytics.getTracker(trackingId);
    }

    public void close(Tracker tracker) {
        this.mGoogleAnalytics.closeTracker(tracker.getName());
    }

    private synchronized void initTrackProviderIfNecessary() {
        if (this.mGoogleAnalytics == null) {
            this.mGoogleAnalytics = GoogleAnalytics.getInstance(this.mContext);
            this.mGoogleAnalytics.setLogger(new LoggerImpl());
        }
    }

    static class LoggerImpl
    implements Logger {
        LoggerImpl() {
        }

        @Override
        public void error(String message) {
            Log.e(message);
        }

        @Override
        public void error(Exception exception) {
            Log.e("", exception);
        }

        @Override
        public void info(String message) {
            Log.i(message);
        }

        @Override
        public void verbose(String message) {
            Log.v(message);
        }

        @Override
        public void warn(String message) {
            Log.w(message);
        }

        @Override
        public Logger.LogLevel getLogLevel() {
            Logger.LogLevel logLevel = Log.getLogLevel();
            return logLevel == null ? Logger.LogLevel.ERROR : LoggerImpl.toAnalyticsLogLevel(logLevel);
        }

        @Override
        public void setLogLevel(Logger.LogLevel logLevel) {
            Log.w("GA uses GTM logger. Please use TagManager.getLogger().setLogLevel(LogLevel) instead.");
        }

        private static Logger.LogLevel toAnalyticsLogLevel(Logger.LogLevel logLevel) {
            switch (logLevel) {
                case NONE: 
                case ERROR: {
                    return Logger.LogLevel.ERROR;
                }
                case WARNING: {
                    return Logger.LogLevel.WARNING;
                }
                case INFO: 
                case DEBUG: {
                    return Logger.LogLevel.INFO;
                }
                case VERBOSE: {
                    return Logger.LogLevel.VERBOSE;
                }
            }
            return Logger.LogLevel.ERROR;
        }
    }
}

