/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.proto.Debug;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.ArrayUtils;
import com.google.tagmanager.CtfeHost;
import com.google.tagmanager.DebugInformationHandler;
import com.google.tagmanager.Log;
import com.google.tagmanager.NetworkClient;
import com.google.tagmanager.NetworkClientFactory;
import com.google.tagmanager.protobuf.nano.MessageNano;
import java.io.IOException;

class CtfeDebugInformationHandler
implements DebugInformationHandler {
    private int currentDebugEventNumber;
    private CtfeHost mCtfeHost;
    @VisibleForTesting
    static final String CTFE_URL_PATH_PREFIX = "/d?";
    @VisibleForTesting
    static final int NUM_EVENTS_PER_SEND = 1;
    private Debug.DebugEvents mDebugEvents;
    private NetworkClient mClient;

    @VisibleForTesting
    CtfeDebugInformationHandler(NetworkClient client, CtfeHost host) {
        this.mCtfeHost = host;
        this.mClient = client;
        this.mDebugEvents = new Debug.DebugEvents();
    }

    public CtfeDebugInformationHandler(CtfeHost host) {
        this(new NetworkClientFactory().createNetworkClient(), host);
    }

    @Override
    public synchronized void receiveEventInfo(Debug.EventInfo event) {
        this.mDebugEvents.event = ArrayUtils.appendToArray(this.mDebugEvents.event, event);
        if (this.mDebugEvents.event.length >= 1 && this.sendDebugInformationtoCtfe()) {
            this.mDebugEvents.clear();
        }
    }

    private byte[] getDebugEventsAsBytes() throws IOException {
        return MessageNano.toByteArray(this.mDebugEvents);
    }

    private boolean sendDebugInformationtoCtfe() {
        try {
            this.mClient.sendPostRequest(this.mCtfeHost.constructCtfeDebugUrl(this.currentDebugEventNumber++), this.getDebugEventsAsBytes());
            return true;
        }
        catch (IOException ex) {
            Log.e("CtfeDebugInformationHandler: Error sending information to server that handles debug information: " + ex.getMessage());
            return false;
        }
    }
}

