/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<double, double> g_atan_intel_data[] = {
  { // Entry 0
    0x1.0fb06ede9973a00000000000007cc060p-5,
    0x1.0fc9f1fabe658p-5
  },
  { // Entry 1
    -0x1.0fb06ede9973a00000000000007cc060p-5,
    -0x1.0fc9f1fabe658p-5
  },
  { // Entry 2
    0x1.1ba1951db1d6dfffffffffffffb8f174p-5,
    0x1.1bbe9c255698dp-5
  },
  { // Entry 3
    -0x1.1ba1951db1d6dfffffffffffffb8f174p-5,
    -0x1.1bbe9c255698dp-5
  },
  { // Entry 4
    0x1.8d8d2d4bd6fa2fffffffffffffb52a01p-5,
    0x1.8ddd25ab90ca1p-5
  },
  { // Entry 5
    -0x1.8d8d2d4bd6fa2fffffffffffffb52a01p-5,
    -0x1.8ddd25ab90ca1p-5
  },
  { // Entry 6
    0x1.52c39ef070cad0000000000000397b8dp-4,
    0x1.5389e6df41979p-4
  },
  { // Entry 7
    -0x1.52c39ef070cad0000000000000397b8dp-4,
    -0x1.5389e6df41979p-4
  },
  { // Entry 8
    0x1.a33f32ac5ceb4ffffffffffffff62c0ep-3,
    0x1.a933fe176b375p-3
  },
  { // Entry 9
    -0x1.a33f32ac5ceb4ffffffffffffff62c0ep-3,
    -0x1.a933fe176b375p-3
  },
  { // Entry 10
    0x1.09544b71ad4a6800000000000013a8d4p-2,
    0x1.0f6e5d9960397p-2
  },
  { // Entry 11
    -0x1.09544b71ad4a6800000000000013a8d4p-2,
    -0x1.0f6e5d9960397p-2
  },
  { // Entry 12
    0x1.46ac37224353600000000000000f8ab8p-1,
    0x1.7ba49f739829fp-1
  },
  { // Entry 13
    -0x1.46ac37224353600000000000000f8ab8p-1,
    -0x1.7ba49f739829fp-1
  },
  { // Entry 14
    -0x1.93d0d4b4b1dee82cea5b0c37054b40e2p-1,
    -0x1.01b28f7519ab5p0
  },
  { // Entry 15
    0x1.93d0d4b4b1dee82cea5b0c37054b40e2p-1,
    0x1.01b28f7519ab5p0
  },
  { // Entry 16
    -0x1.8e373c766a9cb7fff0093d26a3e96fdcp0,
    -0x1.05ffffffff0p6
  },
  { // Entry 17
    0x1.8e373c766a9cb7fff0093d26a3e96fdcp0,
    0x1.05ffffffff0p6
  },
  { // Entry 18
    -0x1.9a66b77f370938283db745fa4d8f6929p-1,
    -0x1.086a05172c159p0
  },
  { // Entry 19
    0x1.9a66b77f370938283db745fa4d8f6929p-1,
    0x1.086a05172c159p0
  },
  { // Entry 20
    -0x1.a1f29496a63eb7fed7941742ac25c0bcp-1,
    -0x1.10556f1497661p0
  },
  { // Entry 21
    0x1.a1f29496a63eb7fed7941742ac25c0bcp-1,
    0x1.10556f1497661p0
  },
  { // Entry 22
    -0x1.a46a24d34e9b282810adb188827a9af1p-1,
    -0x1.12fa0d6901526p0
  },
  { // Entry 23
    0x1.a46a24d34e9b282810adb188827a9af1p-1,
    0x1.12fa0d6901526p0
  },
  { // Entry 24
    -0x1.fd7343117fa575c550dcdff0fd642410p-2,
    -0x1.160dc317bf87cp-1
  },
  { // Entry 25
    0x1.fd7343117fa575c550dcdff0fd642410p-2,
    0x1.160dc317bf87cp-1
  },
  { // Entry 26
    -0x1.abdcc74821485ffb3dce2c471f1d9ccdp-1,
    -0x1.1b2p0
  },
  { // Entry 27
    0x1.abdcc74821485ffb3dce2c471f1d9ccdp-1,
    0x1.1b2p0
  },
  { // Entry 28
    -0x1.1b6b00f64692b8157a322d05add170c4p-2,
    -0x1.22e245c48b894p-2
  },
  { // Entry 29
    0x1.1b6b00f64692b8157a322d05add170c4p-2,
    0x1.22e245c48b894p-2
  },
  { // Entry 30
    -0x1.76f5ddc3a8b508ed9f137dea6b81e90fp0,
    -0x1.2c72f995b1d2ep3
  },
  { // Entry 31
    0x1.76f5ddc3a8b508ed9f137dea6b81e90fp0,
    0x1.2c72f995b1d2ep3
  },
  { // Entry 32
    -0x1.1e00babdefd447d7cd293fd8818ded16p-1,
    -0x1.3fffffffffe01p-1
  },
  { // Entry 33
    0x1.1e00babdefd447d7cd293fd8818ded16p-1,
    0x1.3fffffffffe01p-1
  },
  { // Entry 34
    -0x1.257cf8f86aae37fd89007cddd9fbedadp-1,
    -0x1.4a818adf4d00cp-1
  },
  { // Entry 35
    0x1.257cf8f86aae37fd89007cddd9fbedadp-1,
    0x1.4a818adf4d00cp-1
  },
  { // Entry 36
    -0x1.30ac945137336cee6dcf73db648cfcb8p-1,
    -0x1.5a95192041f9ep-1
  },
  { // Entry 37
    0x1.30ac945137336cee6dcf73db648cfcb8p-1,
    0x1.5a95192041f9ep-1
  },
  { // Entry 38
    -0x1.dfc9b7f9ab42d803453edb4156b22fe0p-1,
    -0x1.5c634cb1dfe6bp0
  },
  { // Entry 39
    0x1.dfc9b7f9ab42d803453edb4156b22fe0p-1,
    0x1.5c634cb1dfe6bp0
  },
  { // Entry 40
    -0x1.6bf3302a984a8a006c4478c0e763fab9p-2,
    -0x1.7c1756ec12b23p-2
  },
  { // Entry 41
    0x1.6bf3302a984a8a006c4478c0e763fab9p-2,
    0x1.7c1756ec12b23p-2
  },
  { // Entry 42
    -0x1.7f747c370c0727fccfb9495ede110579p-5,
    -0x1.7fbc3df2ed276p-5
  },
  { // Entry 43
    0x1.7f747c370c0727fccfb9495ede110579p-5,
    0x1.7fbc3df2ed276p-5
  },
  { // Entry 44
    -0x1.fdda4aef81e8e7fffd547e56ce08f36dp-1,
    -0x1.8b0adc528bce4p0
  },
  { // Entry 45
    0x1.fdda4aef81e8e7fffd547e56ce08f36dp-1,
    0x1.8b0adc528bce4p0
  },
  { // Entry 46
    -0x1.91cf060a572547ff8e8e829b167593fcp0,
    -0x1.962000000000bp9
  },
  { // Entry 47
    0x1.91cf060a572547ff8e8e829b167593fcp0,
    0x1.962000000000bp9
  },
  { // Entry 48
    -0x1.47c28e8c40ec280000020808fdc90264p0,
    -0x1.ac2e0862e543ep1
  },
  { // Entry 49
    0x1.47c28e8c40ec280000020808fdc90264p0,
    0x1.ac2e0862e543ep1
  },
  { // Entry 50
    -0x1.921fb54442d18469898cc516ef921439p0,
    -0x1.c35fe0cc9d0e4p99
  },
  { // Entry 51
    0x1.921fb54442d18469898cc516ef921439p0,
    0x1.c35fe0cc9d0e4p99
  },
  { // Entry 52
    -0x1.fee2431215606f9db22d52fc7e731b98p-6,
    -0x1.ff0caaae31790p-6
  },
  { // Entry 53
    0x1.fee2431215606f9db22d52fc7e731b98p-6,
    0x1.ff0caaae31790p-6
  },
  { // Entry 54
    -0x1.1b6ae5e70d57a0024825b0cee86fd415p0,
    -0x1.ffeffffffffffp0
  },
  { // Entry 55
    0x1.1b6ae5e70d57a0024825b0cee86fd415p0,
    0x1.ffeffffffffffp0
  },
  { // Entry 56
    -0x1.f5aa32d8a6d177fffad61b5dca0be8bfp-3,
    -0x1.fff2007ffffffp-3
  },
  { // Entry 57
    0x1.f5aa32d8a6d177fffad61b5dca0be8bfp-3,
    0x1.fff2007ffffffp-3
  },
  { // Entry 58
    -0x1.f5b39f92578e003ce025445d5448c723p-3,
    -0x1.fffc03fffffffp-3
  },
  { // Entry 59
    0x1.f5b39f92578e003ce025445d5448c723p-3,
    0x1.fffc03fffffffp-3
  },
  { // Entry 60
    0x1.fd5ba9aac2f7f7f74a4ac2f7962ea006p-4,
    0x1.0000000000009p-3
  },
  { // Entry 61
    -0x1.fd5ba9aac2f7f7f74a4ac2f7962ea006p-4,
    -0x1.0000000000009p-3
  },
  { // Entry 62
    0x1.1b6e192ebbe4b3939e676eed13ecdea5p0,
    0x1.0000000000011p1
  },
  { // Entry 63
    -0x1.1b6e192ebbe4b3939e676eed13ecdea5p0,
    -0x1.0000000000011p1
  },
  { // Entry 64
    0x1.fd5ba9aac3301779426a44d6216c0127p-4,
    0x1.00000000001d1p-3
  },
  { // Entry 65
    -0x1.fd5ba9aac3301779426a44d6216c0127p-4,
    -0x1.00000000001d1p-3
  },
  { // Entry 66
    0x1.f5b75f92c8e0a8fdae620b51cd9aff12p-3,
    0x1.00000000007p-2
  },
  { // Entry 67
    -0x1.f5b75f92c8e0a8fdae620b51cd9aff12p-3,
    -0x1.00000000007p-2
  },
  { // Entry 68
    0x1.ffd55bba9d69a8ad651d71aec988dad0p-6,
    0x1.0000000003047p-5
  },
  { // Entry 69
    -0x1.ffd55bba9d69a8ad651d71aec988dad0p-6,
    -0x1.0000000003047p-5
  },
  { // Entry 70
    0x1.911fb5999813a8003c879b1793966ea1p0,
    0x1.0000000020017p8
  },
  { // Entry 71
    -0x1.911fb5999813a8003c879b1793966ea1p0,
    -0x1.0000000020017p8
  },
  { // Entry 72
    0x1.921fb54472d18469850cc517020039a2p-1,
    0x1.000000003p0
  },
  { // Entry 73
    -0x1.921fb54472d18469850cc517020039a2p-1,
    -0x1.000000003p0
  },
  { // Entry 74
    0x1.f5b75f959ae0a8fd6e9ac1e84bceca57p-3,
    0x1.000000018p-2
  },
  { // Entry 75
    -0x1.f5b75f959ae0a8fd6e9ac1e84bceca57p-3,
    -0x1.000000018p-2
  },
  { // Entry 76
    0x1.f5b7671a4f939829143782fc6e124ccap-3,
    0x1.0000040p-2
  },
  { // Entry 77
    -0x1.f5b7671a4f939829143782fc6e124ccap-3,
    -0x1.0000040p-2
  },
  { // Entry 78
    0x1.fd5bb18b417c48ac848521bb0772d9a1p-4,
    0x1.00000400004p-3
  },
  { // Entry 79
    -0x1.fd5bb18b417c48ac848521bb0772d9a1p-4,
    -0x1.00000400004p-3
  },
  { // Entry 80
    0x1.921fc4440248282d290a616b8bd2a40fp-1,
    0x1.00000effbfe72p0
  },
  { // Entry 81
    -0x1.921fc4440248282d290a616b8bd2a40fp-1,
    -0x1.00000effbfe72p0
  },
  { // Entry 82
    0x1.921fcb4efe8b9800001979c3c14ae647p-1,
    0x1.0000160abcad0p0
  },
  { // Entry 83
    -0x1.921fcb4efe8b9800001979c3c14ae647p-1,
    -0x1.0000160abcad0p0
  },
  { // Entry 84
    0x1.fd5d9dd9fe4877fd578f460dcb83a068p-4,
    0x1.0000fe0p-3
  },
  { // Entry 85
    -0x1.fd5d9dd9fe4877fd578f460dcb83a068p-4,
    -0x1.0000fe0p-3
  },
  { // Entry 86
    0x1.1b6fb2c336d49314eac9f9c98fd7e33cp0,
    0x1.00040p1
  },
  { // Entry 87
    -0x1.1b6fb2c336d49314eac9f9c98fd7e33cp0,
    -0x1.00040p1
  },
  { // Entry 88
    0x1.8e200a90cc63080337bb5f472303d0cbp0,
    0x1.000ffffffffe1p6
  },
  { // Entry 89
    -0x1.8e200a90cc63080337bb5f472303d0cbp0,
    -0x1.000ffffffffe1p6
  },
  { // Entry 90
    0x1.924fb0c48ad183a74183edd5362486dfp-1,
    0x1.003p0
  },
  { // Entry 91
    -0x1.924fb0c48ad183a74183edd5362486dfp-1,
    -0x1.003p0
  },
  { // Entry 92
    0x1.fedc5f6aeb98186a3b0d3b954d70911cp-4,
    0x1.00c35e9758e2cp-3
  },
  { // Entry 93
    -0x1.fedc5f6aeb98186a3b0d3b954d70911cp-4,
    -0x1.00c35e9758e2cp-3
  },
  { // Entry 94
    0x1.921fb3466091e7ffbc9b8e5c6d88ce22p0,
    0x1.011p23
  },
  { // Entry 95
    -0x1.921fb3466091e7ffbc9b8e5c6d88ce22p0,
    -0x1.011p23
  },
  { // Entry 96
    0x1.1c2100958558dfff915395a5bfb4e4f7p0,
    0x1.01c1b75a29198p1
  },
  { // Entry 97
    -0x1.1c2100958558dfff915395a5bfb4e4f7p0,
    -0x1.01c1b75a29198p1
  },
  { // Entry 98
    0x1.941da6b976112800ae50a79244b2f00fp-1,
    0x1.01fffp0
  },
  { // Entry 99
    -0x1.941da6b976112800ae50a79244b2f00fp-1,
    -0x1.01fffp0
  },
  { // Entry 100
    0x1.95412c14caec68368d2352262e205e29p-1,
    0x1.032667b38fd63p0
  },
  { // Entry 101
    -0x1.95412c14caec68368d2352262e205e29p-1,
    -0x1.032667b38fd63p0
  },
  { // Entry 102
    0x1.954797156907ffe8d43c56fed8806cbap-1,
    0x1.032ce7209e936p0
  },
  { // Entry 103
    -0x1.954797156907ffe8d43c56fed8806cbap-1,
    -0x1.032ce7209e936p0
  },
  { // Entry 104
    0x1.03fe926deb87dea036ae0e5000a78179p-7,
    0x1.03fff80p-7
  },
  { // Entry 105
    -0x1.03fe926deb87dea036ae0e5000a78179p-7,
    -0x1.03fff80p-7
  },
  { // Entry 106
    0x1.fd61e4326c1e17f9be5c0e96b9e245b5p-3,
    0x1.041391b4f6773p-2
  },
  { // Entry 107
    -0x1.fd61e4326c1e17f9be5c0e96b9e245b5p-3,
    -0x1.041391b4f6773p-2
  },
  { // Entry 108
    0x1.9690e7465847a7ddc153bc6798d1b82bp-1,
    0x1.047b2d5ac8ccbp0
  },
  { // Entry 109
    -0x1.9690e7465847a7ddc153bc6798d1b82bp-1,
    -0x1.047b2d5ac8ccbp0
  },
  { // Entry 110
    0x1.96c8ea639f68cc09d44584196295df93p-1,
    0x1.04b43403953b0p0
  },
  { // Entry 111
    -0x1.96c8ea639f68cc09d44584196295df93p-1,
    -0x1.04b43403953b0p0
  },
  { // Entry 112
    0x1.96c95ba7df84f7fecf841f04a5386a95p-1,
    0x1.04b4a761a073bp0
  },
  { // Entry 113
    -0x1.96c95ba7df84f7fecf841f04a5386a95p-1,
    -0x1.04b4a761a073bp0
  },
  { // Entry 114
    0x1.ff956a68e5f5d7fa26829ba0a3287227p-3,
    0x1.053f96b868b40p-2
  },
  { // Entry 115
    -0x1.ff956a68e5f5d7fa26829ba0a3287227p-3,
    -0x1.053f96b868b40p-2
  },
  { // Entry 116
    0x1.98b0c3c0dd8917febe21b582e45bf32ap-1,
    0x1.06a6fdd8c9be8p0
  },
  { // Entry 117
    -0x1.98b0c3c0dd8917febe21b582e45bf32ap-1,
    -0x1.06a6fdd8c9be8p0
  },
  { // Entry 118
    0x1.e7e3d0910807efff992c7a274fdbed8cp-2,
    0x1.084p-1
  },
  { // Entry 119
    -0x1.e7e3d0910807efff992c7a274fdbed8cp-2,
    -0x1.084p-1
  },
  { // Entry 120
    0x1.09882f0fd878b7fc750c23c0417aa352p-5,
    0x1.09ap-5
  },
  { // Entry 121
    -0x1.09882f0fd878b7fc750c23c0417aa352p-5,
    -0x1.09ap-5
  },
  { // Entry 122
    0x1.a057e3cb74245802b71c5786bd3bf5a9p-1,
    0x1.0ea1281786681p0
  },
  { // Entry 123
    -0x1.a057e3cb74245802b71c5786bd3bf5a9p-1,
    -0x1.0ea1281786681p0
  },
  { // Entry 124
    0x1.a057e3cb7428100cde6242b3bf2d75e7p-1,
    0x1.0ea12817866c0p0
  },
  { // Entry 125
    -0x1.a057e3cb7428100cde6242b3bf2d75e7p-1,
    -0x1.0ea12817866c0p0
  },
  { // Entry 126
    0x1.09544b71ad4a6800000000000013a8d4p-2,
    0x1.0f6e5d9960397p-2
  },
  { // Entry 127
    -0x1.09544b71ad4a6800000000000013a8d4p-2,
    -0x1.0f6e5d9960397p-2
  },
  { // Entry 128
    0x1.921fb4cd9c6767fffffe6051bf1c3fecp0,
    0x1.142c69b7200b4p25
  },
  { // Entry 129
    -0x1.921fb4cd9c6767fffffe6051bf1c3fecp0,
    -0x1.142c69b7200b4p25
  },
  { // Entry 130
    0x1.a908afa5b1d49d450834540fee9c3c24p-1,
    0x1.180p0
  },
  { // Entry 131
    -0x1.a908afa5b1d49d450834540fee9c3c24p-1,
    -0x1.180p0
  },
  { // Entry 132
    0x1.abdcc74821485ffb3dce2c471f1d9ccdp-1,
    0x1.1b2p0
  },
  { // Entry 133
    -0x1.abdcc74821485ffb3dce2c471f1d9ccdp-1,
    -0x1.1b2p0
  },
  { // Entry 134
    0x1.1ffffffffff868000000005c43999999p-22,
    0x1.2p-22
  },
  { // Entry 135
    -0x1.1ffffffffff868000000005c43999999p-22,
    -0x1.2p-22
  },
  { // Entry 136
    0x1.1231f3cf3b64080110ff41eaf08e7f52p-1,
    0x1.2fcf7444bde76p-1
  },
  { // Entry 137
    -0x1.1231f3cf3b64080110ff41eaf08e7f52p-1,
    -0x1.2fcf7444bde76p-1
  },
  { // Entry 138
    0x1.14e89198860627ffffe8602275519490p-1,
    0x1.337d9db6d7c12p-1
  },
  { // Entry 139
    -0x1.14e89198860627ffffe8602275519490p-1,
    -0x1.337d9db6d7c12p-1
  },
  { // Entry 140
    0x1.91eae7e474234800ffed4579e939b69ep0,
    0x1.364a2f134fcc8p10
  },
  { // Entry 141
    -0x1.91eae7e474234800ffed4579e939b69ep0,
    -0x1.364a2f134fcc8p10
  },
  { // Entry 142
    0x1.921fb53da9afc7ff8a7b36e49887a88cp0,
    0x1.3663986f82220p29
  },
  { // Entry 143
    -0x1.921fb53da9afc7ff8a7b36e49887a88cp0,
    -0x1.3663986f82220p29
  },
  { // Entry 144
    0x1.78c56b92f190e84a323bd5804a1c5ba6p0,
    0x1.4210842108420p3
  },
  { // Entry 145
    -0x1.78c56b92f190e84a323bd5804a1c5ba6p0,
    -0x1.4210842108420p3
  },
  { // Entry 146
    0x1.78d751494898372d0fe3af3a7837ff8fp0,
    0x1.42f5ff15ddc08p3
  },
  { // Entry 147
    -0x1.78d751494898372d0fe3af3a7837ff8fp0,
    -0x1.42f5ff15ddc08p3
  },
  { // Entry 148
    0x1.31ce4da037f1542340ee4c61421bba5ap0,
    0x1.43fff80p1
  },
  { // Entry 149
    -0x1.31ce4da037f1542340ee4c61421bba5ap0,
    -0x1.43fff80p1
  },
  { // Entry 150
    0x1.31ce4fc9313474e69b41306d82deceb0p0,
    0x1.440p1
  },
  { // Entry 151
    -0x1.31ce4fc9313474e69b41306d82deceb0p0,
    -0x1.440p1
  },
  { // Entry 152
    0x1.26b3d211bc3faaf8f037dd3421d9f962p-1,
    0x1.4c3a987530ea6p-1
  },
  { // Entry 153
    -0x1.26b3d211bc3faaf8f037dd3421d9f962p-1,
    -0x1.4c3a987530ea6p-1
  },
  { // Entry 154
    0x1.351779f072846800a9bb18d72a79814ep0,
    0x1.5094250942508p1
  },
  { // Entry 155
    -0x1.351779f072846800a9bb18d72a79814ep0,
    -0x1.5094250942508p1
  },
  { // Entry 156
    0x1.58fcecb696d827ec66c4a7bfd8ed327bp-8,
    0x1.58fdbd8ddbbf8p-8
  },
  { // Entry 157
    -0x1.58fcecb696d827ec66c4a7bfd8ed327bp-8,
    -0x1.58fdbd8ddbbf8p-8
  },
  { // Entry 158
    0x1.63398f6da2f1a7fffff2d311886948c5p0,
    0x1.596de8ca11ae6p2
  },
  { // Entry 159
    -0x1.63398f6da2f1a7fffff2d311886948c5p0,
    -0x1.596de8ca11ae6p2
  },
  { // Entry 160
    0x1.3424a0066e6a8d6e3d6901f99034cde1p-1,
    0x1.5faa0cbf48e56p-1
  },
  { // Entry 161
    -0x1.3424a0066e6a8d6e3d6901f99034cde1p-1,
    -0x1.5faa0cbf48e56p-1
  },
  { // Entry 162
    0x1.5ff223a639d5bfce7ae1cfb7516d26adp-6,
    0x1.6p-6
  },
  { // Entry 163
    -0x1.5ff223a639d5bfce7ae1cfb7516d26adp-6,
    -0x1.6p-6
  },
  { // Entry 164
    0x1.345f01cce38c8d8be40cc12c58240e15p-1,
    0x1.600000000018dp-1
  },
  { // Entry 165
    -0x1.345f01cce38c8d8be40cc12c58240e15p-1,
    -0x1.600000000018dp-1
  },
  { // Entry 166
    0x1.367cb24fdff2146a3c6863d233ff09fep-1,
    0x1.632p-1
  },
  { // Entry 167
    -0x1.367cb24fdff2146a3c6863d233ff09fep-1,
    -0x1.632p-1
  },
  { // Entry 168
    0x1.57baeb9c51db490f8249f6679768741fp-2,
    0x1.654p-2
  },
  { // Entry 169
    -0x1.57baeb9c51db490f8249f6679768741fp-2,
    -0x1.654p-2
  },
  { // Entry 170
    0x1.395006b0fd682d86f4a40f69e4dad1f3p-1,
    0x1.675370cc217f1p-1
  },
  { // Entry 171
    -0x1.395006b0fd682d86f4a40f69e4dad1f3p-1,
    -0x1.675370cc217f1p-1
  },
  { // Entry 172
    0x1.695a2c268e1e57ffee0cb8c88986dfefp-12,
    0x1.695a2d168b440p-12
  },
  { // Entry 173
    -0x1.695a2c268e1e57ffee0cb8c88986dfefp-12,
    -0x1.695a2d168b440p-12
  },
  { // Entry 174
    0x1.90b6fc0474fec7fe12f524f1b420b184p0,
    0x1.6b5ad6b5aceb4p7
  },
  { // Entry 175
    -0x1.90b6fc0474fec7fe12f524f1b420b184p0,
    -0x1.6b5ad6b5aceb4p7
  },
  { // Entry 176
    0x1.3b8f3306167a8baa368daae0bf08e86cp0,
    0x1.6c0p1
  },
  { // Entry 177
    -0x1.3b8f3306167a8baa368daae0bf08e86cp0,
    -0x1.6c0p1
  },
  { // Entry 178
    0x1.5f6bae189b51098a86d90c98da4cc877p-2,
    0x1.6de63b148cf0bp-2
  },
  { // Entry 179
    -0x1.5f6bae189b51098a86d90c98da4cc877p-2,
    -0x1.6de63b148cf0bp-2
  },
  { // Entry 180
    0x1.3de18703d42d69f55b3e6c4d1fe5629dp-1,
    0x1.6e30022cb4501p-1
  },
  { // Entry 181
    -0x1.3de18703d42d69f55b3e6c4d1fe5629dp-1,
    -0x1.6e30022cb4501p-1
  },
  { // Entry 182
    0x1.ebe5401364d0c802b6d52ee2cdf2086ep-1,
    0x1.6e3b1e21b27ddp0
  },
  { // Entry 183
    -0x1.ebe5401364d0c802b6d52ee2cdf2086ep-1,
    -0x1.6e3b1e21b27ddp0
  },
  { // Entry 184
    0x1.6310721e8d7bc04e2ae4e8cce87a1ec0p-2,
    0x1.72036f889e86fp-2
  },
  { // Entry 185
    -0x1.6310721e8d7bc04e2ae4e8cce87a1ec0p-2,
    -0x1.72036f889e86fp-2
  },
  { // Entry 186
    0x1.685c82be1d6fa902b238e87716c3bbfbp-2,
    0x1.7803718434620p-2
  },
  { // Entry 187
    -0x1.685c82be1d6fa902b238e87716c3bbfbp-2,
    -0x1.7803718434620p-2
  },
  { // Entry 188
    0x1.68c3b08c20af09be807f598cbca32cb9p-2,
    0x1.78788d320d639p-2
  },
  { // Entry 189
    -0x1.68c3b08c20af09be807f598cbca32cb9p-2,
    -0x1.78788d320d639p-2
  },
  { // Entry 190
    0x1.6b35cbad026009f12d00003f84c29caep-2,
    0x1.7b3fe92e2fd63p-2
  },
  { // Entry 191
    -0x1.6b35cbad026009f12d00003f84c29caep-2,
    -0x1.7b3fe92e2fd63p-2
  },
  { // Entry 192
    0x1.6c4b3610c42b29eabeaa35cc1b8067ecp-2,
    0x1.7c7b80a9d788bp-2
  },
  { // Entry 193
    -0x1.6c4b3610c42b29eabeaa35cc1b8067ecp-2,
    -0x1.7c7b80a9d788bp-2
  },
  { // Entry 194
    0x1.6eed6ff6cd99ca02c4d88c9aa595d5cfp-2,
    0x1.7f7b8c648a650p-2
  },
  { // Entry 195
    -0x1.6eed6ff6cd99ca02c4d88c9aa595d5cfp-2,
    -0x1.7f7b8c648a650p-2
  },
  { // Entry 196
    0x1.7fffffffffffb80000000000184cccccp-25,
    0x1.8p-25
  },
  { // Entry 197
    -0x1.7fffffffffffb80000000000184cccccp-25,
    -0x1.8p-25
  },
  { // Entry 198
    0x1.7fffffffffffc800000000000f4cccccp-25,
    0x1.8000000000001p-25
  },
  { // Entry 199
    -0x1.7fffffffffffc800000000000f4cccccp-25,
    -0x1.8000000000001p-25
  },
  { // Entry 200
    0x1.7fffffffffffd80000000000064cccccp-25,
    0x1.8000000000002p-25
  },
  { // Entry 201
    -0x1.7fffffffffffd80000000000064cccccp-25,
    -0x1.8000000000002p-25
  },
  { // Entry 202
    0x1.f7b9ef3dc65408000005e3f91e816063p-1,
    0x1.80df4b28b5a84p0
  },
  { // Entry 203
    -0x1.f7b9ef3dc65408000005e3f91e816063p-1,
    -0x1.80df4b28b5a84p0
  },
  { // Entry 204
    0x1.90ce0249811008006638702db8ae59e2p0,
    0x1.8421084210846p7
  },
  { // Entry 205
    -0x1.90ce0249811008006638702db8ae59e2p0,
    -0x1.8421084210846p7
  },
  { // Entry 206
    0x1.fb3c57dab5afa80a506e91f92e6a8df9p-1,
    0x1.86a71395bc9b5p0
  },
  { // Entry 207
    -0x1.fb3c57dab5afa80a506e91f92e6a8df9p-1,
    -0x1.86a71395bc9b5p0
  },
  { // Entry 208
    0x1.68d94312ca7f17ffeed1dd16ec2d35e6p0,
    0x1.898p2
  },
  { // Entry 209
    -0x1.68d94312ca7f17ffeed1dd16ec2d35e6p0,
    -0x1.898p2
  },
  { // Entry 210
    0x1.ff69d0cefa8a27ebf8cbf5ec1cc78342p-1,
    0x1.8db18047c8944p0
  },
  { // Entry 211
    -0x1.ff69d0cefa8a27ebf8cbf5ec1cc78342p-1,
    -0x1.8db18047c8944p0
  },
  { // Entry 212
    0x1.983e285453b3f000002efc9d654c6a32p-4,
    0x1.999999c022342p-4
  },
  { // Entry 213
    -0x1.983e285453b3f000002efc9d654c6a32p-4,
    -0x1.999999c022342p-4
  },
  { // Entry 214
    0x1.94441feb7be7180000005c46362b16d8p-3,
    0x1.999999f951960p-3
  },
  { // Entry 215
    -0x1.94441feb7be7180000005c46362b16d8p-3,
    -0x1.999999f951960p-3
  },
  { // Entry 216
    0x1.9a6a8e96c86047fffe94ba49799c011fp-3,
    0x1.9ffffffffffddp-3
  },
  { // Entry 217
    -0x1.9a6a8e96c86047fffe94ba49799c011fp-3,
    -0x1.9ffffffffffddp-3
  },
  { // Entry 218
    0x1.9e94153cfe4dc80036c037e172b7cee9p-4,
    0x1.a0000000008p-4
  },
  { // Entry 219
    -0x1.9e94153cfe4dc80036c037e172b7cee9p-4,
    -0x1.a0000000008p-4
  },
  { // Entry 220
    0x1.9fd8a4d9973e57fc465de41ddc4cbae2p-4,
    0x1.a147eb4c17006p-4
  },
  { // Entry 221
    -0x1.9fd8a4d9973e57fc465de41ddc4cbae2p-4,
    -0x1.a147eb4c17006p-4
  },
  { // Entry 222
    0x1.62e23d7da5f6d8010d5496a08573e188p-1,
    0x1.a94678821f0e9p-1
  },
  { // Entry 223
    -0x1.62e23d7da5f6d8010d5496a08573e188p-1,
    -0x1.a94678821f0e9p-1
  },
  { // Entry 224
    0x1.096fe22081e2b800007e36c682109058p0,
    0x1.b102342163952p0
  },
  { // Entry 225
    -0x1.096fe22081e2b800007e36c682109058p0,
    -0x1.b102342163952p0
  },
  { // Entry 226
    0x1.0a471736b923b1f18885a17308e12beep0,
    0x1.b445c1ad3cad1p0
  },
  { // Entry 227
    -0x1.0a471736b923b1f18885a17308e12beep0,
    -0x1.b445c1ad3cad1p0
  },
  { // Entry 228
    0x1.0a66d6f646e8d37662253bd9155a84dep0,
    0x1.b4c1d0c10cca9p0
  },
  { // Entry 229
    -0x1.0a66d6f646e8d37662253bd9155a84dep0,
    -0x1.b4c1d0c10cca9p0
  },
  { // Entry 230
    0x1.a3ad60e89da8b6f1dd20c69213b7612ap-2,
    0x1.bcde6f379bcdep-2
  },
  { // Entry 231
    -0x1.a3ad60e89da8b6f1dd20c69213b7612ap-2,
    -0x1.bcde6f379bcdep-2
  },
  { // Entry 232
    0x1.0e04a23e7337930371d81f0cf4d7e9dcp0,
    0x1.c34p0
  },
  { // Entry 233
    -0x1.0e04a23e7337930371d81f0cf4d7e9dcp0,
    -0x1.c34p0
  },
  { // Entry 234
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.c77250c52a4c4p994
  },
  { // Entry 235
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.c77250c52a4c4p994
  },
  { // Entry 236
    0x1.ad00f5422058b7f130ce2474b9fbbdf8p-2,
    0x1.c80p-2
  },
  { // Entry 237
    -0x1.ad00f5422058b7f130ce2474b9fbbdf8p-2,
    -0x1.c80p-2
  },
  { // Entry 238
    0x1.4c50697afe3227fd6af96ad804191fc4p0,
    0x1.c9b26c9b26cb2p1
  },
  { // Entry 239
    -0x1.4c50697afe3227fd6af96ad804191fc4p0,
    -0x1.c9b26c9b26cb2p1
  },
  { // Entry 240
    0x1.c287b5672b66d828ebaf4756e4f60ad1p-3,
    0x1.c9f0f1fe648bfp-3
  },
  { // Entry 241
    -0x1.c287b5672b66d828ebaf4756e4f60ad1p-3,
    -0x1.c9f0f1fe648bfp-3
  },
  { // Entry 242
    0x1.ce35e40b0af2980007f47f44f1179e69p-5,
    0x1.ceb39ce739ce2p-5
  },
  { // Entry 243
    -0x1.ce35e40b0af2980007f47f44f1179e69p-5,
    -0x1.ceb39ce739ce2p-5
  },
  { // Entry 244
    0x1.ca5072830899e807a46fd46deed06c13p-3,
    0x1.d21f1bc07ff10p-3
  },
  { // Entry 245
    -0x1.ca5072830899e807a46fd46deed06c13p-3,
    -0x1.d21f1bc07ff10p-3
  },
  { // Entry 246
    0x1.d757ad6321e1b7ff10e2bc2deea40152p-7,
    0x1.d76p-7
  },
  { // Entry 247
    -0x1.d757ad6321e1b7ff10e2bc2deea40152p-7,
    -0x1.d76p-7
  },
  { // Entry 248
    0x1.bc568fd6eb58f751409b945717d9554ap-2,
    0x1.da8p-2
  },
  { // Entry 249
    -0x1.bc568fd6eb58f751409b945717d9554ap-2,
    -0x1.da8p-2
  },
  { // Entry 250
    0x1.dcb58cdb206477fea2ac612eafe90af0p-6,
    0x1.dcd80p-6
  },
  { // Entry 251
    -0x1.dcb58cdb206477fea2ac612eafe90af0p-6,
    -0x1.dcd80p-6
  },
  { // Entry 252
    0x1.4fefc9638a79f51094053a972023f6c2p0,
    0x1.e3fffffffffffp1
  },
  { // Entry 253
    -0x1.4fefc9638a79f51094053a972023f6c2p0,
    -0x1.e3fffffffffffp1
  },
  { // Entry 254
    0x1.e559f77b3d1bc7fe0f0af62001c4d64ap-4,
    0x1.e7a2c68ca3bbep-4
  },
  { // Entry 255
    -0x1.e559f77b3d1bc7fe0f0af62001c4d64ap-4,
    -0x1.e7a2c68ca3bbep-4
  },
  { // Entry 256
    0x1.507316595911cbbe475d6a0d0c879007p0,
    0x1.e7f3f9fcfe780p1
  },
  { // Entry 257
    -0x1.507316595911cbbe475d6a0d0c879007p0,
    -0x1.e7f3f9fcfe780p1
  },
  { // Entry 258
    0x1.df110864c9d9d03004ee274a70c0ae22p-3,
    0x1.e7fffffffffffp-3
  },
  { // Entry 259
    -0x1.df110864c9d9d03004ee274a70c0ae22p-3,
    -0x1.e7fffffffffffp-3
  },
  { // Entry 260
    0x1.7145eac2088a38096a1a13357d2f5f02p0,
    0x1.fp2
  },
  { // Entry 261
    -0x1.7145eac2088a38096a1a13357d2f5f02p0,
    -0x1.fp2
  },
  { // Entry 262
    0x1.f2d88602d915b7a920d38c9f9cff16e8p-6,
    0x1.f30p-6
  },
  { // Entry 263
    -0x1.f2d88602d915b7a920d38c9f9cff16e8p-6,
    -0x1.f30p-6
  },
  { // Entry 264
    0x1.f8cda64a08edafa2039d9d8a93546545p-6,
    0x1.f8f68ec9e17eep-6
  },
  { // Entry 265
    -0x1.f8cda64a08edafa2039d9d8a93546545p-6,
    -0x1.f8f68ec9e17eep-6
  },
  { // Entry 266
    0x1.8e1199d0ffd197fffe93ecafbc7df2e1p0,
    0x1.f8ffffeffffaep5
  },
  { // Entry 267
    -0x1.8e1199d0ffd197fffe93ecafbc7df2e1p0,
    -0x1.f8ffffeffffaep5
  },
  { // Entry 268
    0x1.efc20ff0ea4347fb09f751f06225cf3ep-3,
    0x1.f9ac87c22c381p-3
  },
  { // Entry 269
    -0x1.efc20ff0ea4347fb09f751f06225cf3ep-3,
    -0x1.f9ac87c22c381p-3
  },
  { // Entry 270
    0x1.fa55579e0ba577fe929dc83eb7995abcp-6,
    0x1.fa7e9fa7e9f89p-6
  },
  { // Entry 271
    -0x1.fa55579e0ba577fe929dc83eb7995abcp-6,
    -0x1.fa7e9fa7e9f89p-6
  },
  { // Entry 272
    0x1.fa55579e0ba6f7a0b740d8dad80c76dep-6,
    0x1.fa7e9fa7e9fa1p-6
  },
  { // Entry 273
    -0x1.fa55579e0ba6f7a0b740d8dad80c76dep-6,
    -0x1.fa7e9fa7e9fa1p-6
  },
  { // Entry 274
    0x1.fdb067638eb577993194616b1f02253ep-6,
    0x1.fdda82fef66eep-6
  },
  { // Entry 275
    -0x1.fdb067638eb577993194616b1f02253ep-6,
    -0x1.fdda82fef66eep-6
  },
  { // Entry 276
    0x1.f58a3225d517f7b85d014640f929635dp-3,
    0x1.ffcffffffffffp-3
  },
  { // Entry 277
    -0x1.f58a3225d517f7b85d014640f929635dp-3,
    -0x1.ffcffffffffffp-3
  },
  { // Entry 278
    0x1.f5a8507ca2e7f74fe8389718208bcb16p-3,
    0x1.ffeffffffffffp-3
  },
  { // Entry 279
    -0x1.f5a8507ca2e7f74fe8389718208bcb16p-3,
    -0x1.ffeffffffffffp-3
  },
  { // Entry 280
    0x1.1b6ae5e70d57a0024825b0cee86fd415p0,
    0x1.ffeffffffffffp0
  },
  { // Entry 281
    -0x1.1b6ae5e70d57a0024825b0cee86fd415p0,
    -0x1.ffeffffffffffp0
  },
  { // Entry 282
    0x1.822487e434a688433f85f4d9d59f5c91p0,
    0x1.ffeffffffffffp3
  },
  { // Entry 283
    -0x1.822487e434a688433f85f4d9d59f5c91p0,
    -0x1.ffeffffffffffp3
  },
  { // Entry 284
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.fff8e61eadcf7p1021
  },
  { // Entry 285
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.fff8e61eadcf7p1021
  },
  { // Entry 286
    0x1.f5b39f92578e003ce025445d5448c723p-3,
    0x1.fffc03fffffffp-3
  },
  { // Entry 287
    -0x1.f5b39f92578e003ce025445d5448c723p-3,
    -0x1.fffc03fffffffp-3
  },
  { // Entry 288
    0x1.1b6e0f9521925801d32b4375d240e5b1p0,
    0x1.ffffcffffffffp0
  },
  { // Entry 289
    -0x1.1b6e0f9521925801d32b4375d240e5b1p0,
    -0x1.ffffcffffffffp0
  },
  { // Entry 290
    0x1.f5b75ded226447fe90c6cb904987f275p-3,
    0x1.fffffe3ffffbfp-3
  },
  { // Entry 291
    -0x1.f5b75ded226447fe90c6cb904987f275p-3,
    -0x1.fffffe3ffffbfp-3
  },
  { // Entry 292
    0x1.8a205fd5287ff7ff262bad6513207543p0,
    0x1.fffffff3fffffp4
  },
  { // Entry 293
    -0x1.8a205fd5287ff7ff262bad6513207543p0,
    -0x1.fffffff3fffffp4
  },
  { // Entry 294
    0x1.ffd55bba962df799aa0c3a5a5edf7631p-6,
    0x1.fffffffffecb6p-6
  },
  { // Entry 295
    -0x1.ffd55bba962df799aa0c3a5a5edf7631p-6,
    -0x1.fffffffffecb6p-6
  },
  { // Entry 296
    0x1.ffd55bba972df799aa0c3a87739a477dp-6,
    0x1.ffffffffffcbap-6
  },
  { // Entry 297
    -0x1.ffd55bba972df799aa0c3a87739a477dp-6,
    -0x1.ffffffffffcbap-6
  },
  { // Entry 298
    0x1.dac670561bb3768adfc88bd930751a06p-2,
    0x1.fffffffffffe2p-2
  },
  { // Entry 299
    -0x1.dac670561bb3768adfc88bd930751a06p-2,
    -0x1.fffffffffffe2p-2
  },
  { // Entry 300
    0x1.8a205fd55873f800459be65852624b5fp0,
    0x1.ffffffffffff3p4
  },
  { // Entry 301
    -0x1.8a205fd55873f800459be65852624b5fp0,
    -0x1.ffffffffffff3p4
  },
  { // Entry 302
    0x1.fffff55555bb3bb73172cf8cfdef50f9p-11,
    0x1.ffffffffffff8p-11
  },
  { // Entry 303
    -0x1.fffff55555bb3bb73172cf8cfdef50f9p-11,
    -0x1.ffffffffffff8p-11
  },
  { // Entry 304
    0x1.f5b75f92c80db80cbd711fcdd109b918p-3,
    0x1.ffffffffffffep-3
  },
  { // Entry 305
    -0x1.f5b75f92c80db80cbd711fcdd109b918p-3,
    -0x1.ffffffffffffep-3
  },
  { // Entry 306
    0x1.ffffffffffffb5555555555563bbbbbbp-26,
    0x1.ffffffffffffep-26
  },
  { // Entry 307
    -0x1.ffffffffffffb5555555555563bbbbbbp-26,
    -0x1.ffffffffffffep-26
  },
  { // Entry 308
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 309
    0.0,
    0x1.0p-1074
  },
  { // Entry 310
    -0.0,
    -0.0
  },
  { // Entry 311
    0.0,
    0x1.0p-1074
  },
  { // Entry 312
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 313
    -0x1.0000000000000fffffffffffffffffffp-1022,
    -0x1.0000000000001p-1022
  },
  { // Entry 314
    0x1.0000000000000fffffffffffffffffffp-1022,
    0x1.0000000000001p-1022
  },
  { // Entry 315
    -0x1.ffffffffffffffffffffffffffffffffp-1023,
    -0x1.0p-1022
  },
  { // Entry 316
    0x1.ffffffffffffffffffffffffffffffffp-1023,
    0x1.0p-1022
  },
  { // Entry 317
    -0x1.ffffffffffffdfffffffffffffffffffp-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 318
    0x1.ffffffffffffdfffffffffffffffffffp-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 319
    0x1.ffffffffffffdfffffffffffffffffffp-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 320
    -0x1.ffffffffffffdfffffffffffffffffffp-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 321
    0x1.ffffffffffffffffffffffffffffffffp-1023,
    0x1.0p-1022
  },
  { // Entry 322
    -0x1.ffffffffffffffffffffffffffffffffp-1023,
    -0x1.0p-1022
  },
  { // Entry 323
    0x1.0000000000000fffffffffffffffffffp-1022,
    0x1.0000000000001p-1022
  },
  { // Entry 324
    -0x1.0000000000000fffffffffffffffffffp-1022,
    -0x1.0000000000001p-1022
  },
  { // Entry 325
    0x1.9999994237fab1da64992a310312505ep-13,
    0x1.999999999999ap-13
  },
  { // Entry 326
    -0x1.9999994237fab1da64992a310312505ep-13,
    -0x1.999999999999ap-13
  },
  { // Entry 327
    0x1.9999983c131f7a10c5dd5d6e7ce3cb81p-12,
    0x1.999999999999ap-12
  },
  { // Entry 328
    -0x1.9999983c131f7a10c5dd5d6e7ce3cb81p-12,
    -0x1.999999999999ap-12
  },
  { // Entry 329
    0x1.333330e560498c727e4d6265bd2ffec8p-11,
    0x1.3333333333334p-11
  },
  { // Entry 330
    -0x1.333330e560498c727e4d6265bd2ffec8p-11,
    -0x1.3333333333334p-11
  },
  { // Entry 331
    0x1.999994237fca32b5a26ff8f7d9bd8d35p-11,
    0x1.999999999999ap-11
  },
  { // Entry 332
    -0x1.999994237fca32b5a26ff8f7d9bd8d35p-11,
    -0x1.999999999999ap-11
  },
  { // Entry 333
    0x1.fffff55555bbbbb72972d00cfde752f9p-11,
    0x1.0p-10
  },
  { // Entry 334
    -0x1.fffff55555bbbbb72972d00cfde752f9p-11,
    -0x1.0p-10
  },
  { // Entry 335
    0x1.333329fbe7ebeef09e51711b44f86539p-10,
    0x1.3333333333333p-10
  },
  { // Entry 336
    -0x1.333329fbe7ebeef09e51711b44f86539p-10,
    -0x1.3333333333333p-10
  },
  { // Entry 337
    0x1.666657c3edf5fc60e8ee22a4cfe0569cp-10,
    0x1.6666666666666p-10
  },
  { // Entry 338
    -0x1.666657c3edf5fc60e8ee22a4cfe0569cp-10,
    -0x1.6666666666666p-10
  },
  { // Entry 339
    0x1.999983c133ee81d417cae21e440492ffp-10,
    0x1.9999999999999p-10
  },
  { // Entry 340
    -0x1.999983c133ee81d417cae21e440492ffp-10,
    -0x1.9999999999999p-10
  },
  { // Entry 341
    0x1.ccccadb230d5be2055f8f3b668d57c61p-10,
    0x1.cccccccccccccp-10
  },
  { // Entry 342
    -0x1.ccccadb230d5be2055f8f3b668d57c61p-10,
    -0x1.cccccccccccccp-10
  },
  { // Entry 343
    0x1.0664f6d5e1b55939fa39d3978354fb08p-7,
    0x1.0666666666666p-7
  },
  { // Entry 344
    -0x1.0664f6d5e1b55939fa39d3978354fb08p-7,
    -0x1.0666666666666p-7
  },
  { // Entry 345
    0x1.ccc506615256b4d660acbe5536614bc0p-7,
    0x1.cccccccccccccp-7
  },
  { // Entry 346
    -0x1.ccc506615256b4d660acbe5536614bc0p-7,
    -0x1.cccccccccccccp-7
  },
  { // Entry 347
    0x1.498e385e62b42d40708322b65b9a92a2p-6,
    0x1.4999999999999p-6
  },
  { // Entry 348
    -0x1.498e385e62b42d40708322b65b9a92a2p-6,
    -0x1.4999999999999p-6
  },
  { // Entry 349
    0x1.acb3bf2888fd253cde72a65ff6b5a5edp-6,
    0x1.accccccccccccp-6
  },
  { // Entry 350
    -0x1.acb3bf2888fd253cde72a65ff6b5a5edp-6,
    -0x1.accccccccccccp-6
  },
  { // Entry 351
    0x1.07e89e3abee7df5bc22b883856e5d802p-5,
    0x1.080p-5
  },
  { // Entry 352
    -0x1.07e89e3abee7df5bc22b883856e5d802p-5,
    -0x1.080p-5
  },
  { // Entry 353
    0x1.39726b096afb5657f037d44ceabacfdep-5,
    0x1.399999999999ap-5
  },
  { // Entry 354
    -0x1.39726b096afb5657f037d44ceabacfdep-5,
    -0x1.399999999999ap-5
  },
  { // Entry 355
    0x1.6af659752a8e90e79823616d18922d06p-5,
    0x1.6b33333333334p-5
  },
  { // Entry 356
    -0x1.6af659752a8e90e79823616d18922d06p-5,
    -0x1.6b33333333334p-5
  },
  { // Entry 357
    0x1.9c737d9b4d07092c295584951a1f5a71p-5,
    0x1.9cccccccccccep-5
  },
  { // Entry 358
    -0x1.9c737d9b4d07092c295584951a1f5a71p-5,
    -0x1.9cccccccccccep-5
  },
  { // Entry 359
    0x1.cde8ec5bb65f0e742405e56b5ae426e2p-5,
    0x1.ce66666666666p-5
  },
  { // Entry 360
    -0x1.cde8ec5bb65f0e742405e56b5ae426e2p-5,
    -0x1.ce66666666666p-5
  },
  { // Entry 361
    0x1.3359bce85d4c0edf062a316ac9a3b035p-1,
    0x1.5e7fc4369bdadp-1
  },
  { // Entry 362
    -0x1.3359bce85d4c0edf062a316ac9a3b035p-1,
    -0x1.5e7fc4369bdadp-1
  },
  { // Entry 363
    0x1.d5ca708561450bec8cd54cd06ef71588p-1,
    0x1.4e7fc4369bdadp0
  },
  { // Entry 364
    -0x1.d5ca708561450bec8cd54cd06ef71588p-1,
    -0x1.4e7fc4369bdadp0
  },
  { // Entry 365
    0x1.17ac441eeac2e0e131633d5dbda1192dp0,
    0x1.edbfa651e9c84p0
  },
  { // Entry 366
    -0x1.17ac441eeac2e0e131633d5dbda1192dp0,
    -0x1.edbfa651e9c84p0
  },
  { // Entry 367
    0x1.3279e85590bed5c0a7d465c70e9312dbp0,
    0x1.467fc4369bdadp1
  },
  { // Entry 368
    -0x1.3279e85590bed5c0a7d465c70e9312dbp0,
    -0x1.467fc4369bdadp1
  },
  { // Entry 369
    0x1.43f644a23f11312b0baeda6469939df1p0,
    0x1.961fb54442d18p1
  },
  { // Entry 370
    -0x1.43f644a23f11312b0baeda6469939df1p0,
    -0x1.961fb54442d18p1
  },
  { // Entry 371
    0x1.502a1d3da2b62cdafdfc8df896fb781ep0,
    0x1.e5bfa651e9c83p1
  },
  { // Entry 372
    -0x1.502a1d3da2b62cdafdfc8df896fb781ep0,
    -0x1.e5bfa651e9c83p1
  },
  { // Entry 373
    0x1.592066aa733e56535ef23487f1ba45abp0,
    0x1.1aafcbafc85f7p2
  },
  { // Entry 374
    -0x1.592066aa733e56535ef23487f1ba45abp0,
    -0x1.1aafcbafc85f7p2
  },
  { // Entry 375
    0x1.5ff8e2755165d95ef4dfa238b69035c3p0,
    0x1.427fc4369bdadp2
  },
  { // Entry 376
    -0x1.5ff8e2755165d95ef4dfa238b69035c3p0,
    -0x1.427fc4369bdadp2
  },
  { // Entry 377
    0x1.655d65485dc172ad1da5d376106987dep0,
    0x1.6a4fbcbd6f562p2
  },
  { // Entry 378
    -0x1.655d65485dc172ad1da5d376106987dep0,
    -0x1.6a4fbcbd6f562p2
  },
  { // Entry 379
    0x1.65711d6bfd5303b266e1f766916353c0p0,
    0x1.6af2eff0a2896p2
  },
  { // Entry 380
    -0x1.65711d6bfd5303b266e1f766916353c0p0,
    -0x1.6af2eff0a2896p2
  },
  { // Entry 381
    0x1.602a2aaa59041e73fe9cbe5018d9258bp0,
    0x1.43c62a9d02414p2
  },
  { // Entry 382
    -0x1.602a2aaa59041e73fe9cbe5018d9258bp0,
    -0x1.43c62a9d02414p2
  },
  { // Entry 383
    0x1.597f46e10aa0ef6e7b79babd52218e41p0,
    0x1.1c99654961f92p2
  },
  { // Entry 384
    -0x1.597f46e10aa0ef6e7b79babd52218e41p0,
    -0x1.1c99654961f92p2
  },
  { // Entry 385
    0x1.50d20254a2ff42dab732523958fa024cp0,
    0x1.ead93feb8361fp1
  },
  { // Entry 386
    -0x1.50d20254a2ff42dab732523958fa024cp0,
    -0x1.ead93feb8361fp1
  },
  { // Entry 387
    0x1.45190c030df0f68611f816a36d10b59ap0,
    0x1.9c7fb54442d1ap1
  },
  { // Entry 388
    -0x1.45190c030df0f68611f816a36d10b59ap0,
    -0x1.9c7fb54442d1ap1
  },
  { // Entry 389
    0x1.34794d6993e603dc236dc9700bc984e9p0,
    0x1.4e262a9d02415p1
  },
  { // Entry 390
    -0x1.34794d6993e603dc236dc9700bc984e9p0,
    -0x1.4e262a9d02415p1
  },
  { // Entry 391
    0x1.1b598910bd9bdfeeb608b6b41a96f287p0,
    0x1.ff993feb83620p0
  },
  { // Entry 392
    -0x1.1b598910bd9bdfeeb608b6b41a96f287p0,
    -0x1.ff993feb83620p0
  },
  { // Entry 393
    0x1.e44c9309197c4f98392215a424630bb4p-1,
    0x1.62e62a9d02416p0
  },
  { // Entry 394
    -0x1.e44c9309197c4f98392215a424630bb4p-1,
    -0x1.62e62a9d02416p0
  },
  { // Entry 395
    0x1.5150f1acfb0190aa9794ba0211b4eb4bp-1,
    0x1.8c662a9d02419p-1
  },
  { // Entry 396
    -0x1.5150f1acfb0190aa9794ba0211b4eb4bp-1,
    -0x1.8c662a9d02419p-1
  },
  { // Entry 397
    -0x1.073ea15c614e11668ba9fe75888fee13p0,
    -0x1.a8aa1d11c44ffp0
  },
  { // Entry 398
    0x1.073ea15c614e11668ba9fe75888fee13p0,
    0x1.a8aa1d11c44ffp0
  },
  { // Entry 399
    -0x1.0215495ceb1806c15504264e9f1be222p0,
    -0x1.95ec8b9e03d54p0
  },
  { // Entry 400
    0x1.0215495ceb1806c15504264e9f1be222p0,
    0x1.95ec8b9e03d54p0
  },
  { // Entry 401
    -0x1.f923661b52647e658c1f9707f87d1606p-1,
    -0x1.832efa2a435a9p0
  },
  { // Entry 402
    0x1.f923661b52647e658c1f9707f87d1606p-1,
    0x1.832efa2a435a9p0
  },
  { // Entry 403
    -0x1.ed57806b9090def7310604bffed0093dp-1,
    -0x1.707168b682dfep0
  },
  { // Entry 404
    0x1.ed57806b9090def7310604bffed0093dp-1,
    0x1.707168b682dfep0
  },
  { // Entry 405
    -0x1.e0b524b578b4212100f5f78ecd69a1ddp-1,
    -0x1.5db3d742c2653p0
  },
  { // Entry 406
    0x1.e0b524b578b4212100f5f78ecd69a1ddp-1,
    0x1.5db3d742c2653p0
  },
  { // Entry 407
    -0x1.d3290701e8ac987ea5732b16701a05fcp-1,
    -0x1.4af645cf01ea8p0
  },
  { // Entry 408
    0x1.d3290701e8ac987ea5732b16701a05fcp-1,
    0x1.4af645cf01ea8p0
  },
  { // Entry 409
    -0x1.c49e488683ace4d5fd4683f7caab7e9fp-1,
    -0x1.3838b45b416fdp0
  },
  { // Entry 410
    0x1.c49e488683ace4d5fd4683f7caab7e9fp-1,
    0x1.3838b45b416fdp0
  },
  { // Entry 411
    -0x1.b4fe843e9e803b2349ffd384aab807f3p-1,
    -0x1.257b22e780f52p0
  },
  { // Entry 412
    0x1.b4fe843e9e803b2349ffd384aab807f3p-1,
    0x1.257b22e780f52p0
  },
  { // Entry 413
    -0x1.a431f39bc6f4fc2f533fb8b685f7fa56p-1,
    -0x1.12bd9173c07abp0
  },
  { // Entry 414
    0x1.a431f39bc6f4fc2f533fb8b685f7fa56p-1,
    0x1.12bd9173c07abp0
  },
  { // Entry 415
    -0x1.871278e2b0226c7be314f39e634cb866p-1,
    -0x1.ea5c3ed5b3850p-1
  },
  { // Entry 416
    0x1.871278e2b0226c7be314f39e634cb866p-1,
    0x1.ea5c3ed5b3850p-1
  },
  { // Entry 417
    -0x1.7b8b3be13fca614c858af0d2c2879b7ap-1,
    -0x1.d4b87dab670a0p-1
  },
  { // Entry 418
    0x1.7b8b3be13fca614c858af0d2c2879b7ap-1,
    0x1.d4b87dab670a0p-1
  },
  { // Entry 419
    -0x1.6f851ed60f1e0ce1ff2d5577433c5ab2p-1,
    -0x1.bf14bc811a8f0p-1
  },
  { // Entry 420
    0x1.6f851ed60f1e0ce1ff2d5577433c5ab2p-1,
    0x1.bf14bc811a8f0p-1
  },
  { // Entry 421
    -0x1.62fb644de198ccbb0b7e0d32484d4ec0p-1,
    -0x1.a970fb56ce140p-1
  },
  { // Entry 422
    0x1.62fb644de198ccbb0b7e0d32484d4ec0p-1,
    0x1.a970fb56ce140p-1
  },
  { // Entry 423
    -0x1.55e986b4afe0cfdcf0138634c7c95b2bp-1,
    -0x1.93cd3a2c81990p-1
  },
  { // Entry 424
    0x1.55e986b4afe0cfdcf0138634c7c95b2bp-1,
    0x1.93cd3a2c81990p-1
  },
  { // Entry 425
    -0x1.484b52126a2735deb224632c4c2e4042p-1,
    -0x1.7e297902351e0p-1
  },
  { // Entry 426
    0x1.484b52126a2735deb224632c4c2e4042p-1,
    0x1.7e297902351e0p-1
  },
  { // Entry 427
    -0x1.3a1d01c9f4b1e99685e3fe739fdcffdap-1,
    -0x1.6885b7d7e8a30p-1
  },
  { // Entry 428
    0x1.3a1d01c9f4b1e99685e3fe739fdcffdap-1,
    0x1.6885b7d7e8a30p-1
  },
  { // Entry 429
    -0x1.2b5b626353bb47148742f9c053cd45c3p-1,
    -0x1.52e1f6ad9c280p-1
  },
  { // Entry 430
    0x1.2b5b626353bb47148742f9c053cd45c3p-1,
    0x1.52e1f6ad9c280p-1
  },
  { // Entry 431
    -0x1.1c03f735e818163698043ffa524dd5f7p-1,
    -0x1.3d3e35834fad0p-1
  },
  { // Entry 432
    0x1.1c03f735e818163698043ffa524dd5f7p-1,
    0x1.3d3e35834fad0p-1
  },
  { // Entry 433
    -0x1.eab7b2edbe26eb1b5fb149357f51d6c9p-2,
    -0x1.0a0b02501c799p-1
  },
  { // Entry 434
    0x1.eab7b2edbe26eb1b5fb149357f51d6c9p-2,
    0x1.0a0b02501c799p-1
  },
  { // Entry 435
    -0x1.bb12f34bbefd630026b351ba15c3d256p-2,
    -0x1.d8f7208e6b82cp-2
  },
  { // Entry 436
    0x1.bb12f34bbefd630026b351ba15c3d256p-2,
    0x1.d8f7208e6b82cp-2
  },
  { // Entry 437
    -0x1.894ae0cb0ee2f00789eee093998b4a9bp-2,
    -0x1.9dd83c7c9e126p-2
  },
  { // Entry 438
    0x1.894ae0cb0ee2f00789eee093998b4a9bp-2,
    0x1.9dd83c7c9e126p-2
  },
  { // Entry 439
    -0x1.5579fdc3a8f3f9cf3f863dc6aa9b7198p-2,
    -0x1.62b9586ad0a20p-2
  },
  { // Entry 440
    0x1.5579fdc3a8f3f9cf3f863dc6aa9b7198p-2,
    0x1.62b9586ad0a20p-2
  },
  { // Entry 441
    -0x1.1fc79cfbf4e7b55f4dc25f1890fecd53p-2,
    -0x1.279a74590331ap-2
  },
  { // Entry 442
    0x1.1fc79cfbf4e7b55f4dc25f1890fecd53p-2,
    0x1.279a74590331ap-2
  },
  { // Entry 443
    -0x1.d0d0f85f973cce547bb0dc0a38708bffp-3,
    -0x1.d8f7208e6b829p-3
  },
  { // Entry 444
    0x1.d0d0f85f973cce547bb0dc0a38708bffp-3,
    0x1.d8f7208e6b829p-3
  },
  { // Entry 445
    -0x1.5f3d415cb47fed760072dbaeb268ceefp-3,
    -0x1.62b9586ad0a1ep-3
  },
  { // Entry 446
    0x1.5f3d415cb47fed760072dbaeb268ceefp-3,
    0x1.62b9586ad0a1ep-3
  },
  { // Entry 447
    -0x1.d6e1431de5be5630dec33d31fb926cbfp-4,
    -0x1.d8f7208e6b826p-4
  },
  { // Entry 448
    0x1.d6e1431de5be5630dec33d31fb926cbfp-4,
    0x1.d8f7208e6b826p-4
  },
  { // Entry 449
    -0x1.d870dcfcfe7d4ce3742c7268f8f5e0e8p-5,
    -0x1.d8f7208e6b82dp-5
  },
  { // Entry 450
    0x1.d870dcfcfe7d4ce3742c7268f8f5e0e8p-5,
    0x1.d8f7208e6b82dp-5
  },
  { // Entry 451
    0x1.d870dcfcfe7d4ce3742c7268f8f5e0e8p-5,
    0x1.d8f7208e6b82dp-5
  },
  { // Entry 452
    -0x1.d870dcfcfe7d4ce3742c7268f8f5e0e8p-5,
    -0x1.d8f7208e6b82dp-5
  },
  { // Entry 453
    0x1.d6e1431de5bec4b79b64ec5a67bbcc08p-4,
    0x1.d8f7208e6b82dp-4
  },
  { // Entry 454
    -0x1.d6e1431de5bec4b79b64ec5a67bbcc08p-4,
    -0x1.d8f7208e6b82dp-4
  },
  { // Entry 455
    0x1.5f3d415cb4802b98cc41263eda7f242ap-3,
    0x1.62b9586ad0a22p-3
  },
  { // Entry 456
    -0x1.5f3d415cb4802b98cc41263eda7f242ap-3,
    -0x1.62b9586ad0a22p-3
  },
  { // Entry 457
    0x1.d0d0f85f973d0b16e9de3a03bdc6808bp-3,
    0x1.d8f7208e6b82dp-3
  },
  { // Entry 458
    -0x1.d0d0f85f973d0b16e9de3a03bdc6808bp-3,
    -0x1.d8f7208e6b82dp-3
  },
  { // Entry 459
    0x1.1fc79cfbf4e7d2e9265fe8f12eda96cap-2,
    0x1.279a74590331cp-2
  },
  { // Entry 460
    -0x1.1fc79cfbf4e7d2e9265fe8f12eda96cap-2,
    -0x1.279a74590331cp-2
  },
  { // Entry 461
    0x1.5579fdc3a8f4166188aad00fcf71b510p-2,
    0x1.62b9586ad0a22p-2
  },
  { // Entry 462
    -0x1.5579fdc3a8f4166188aad00fcf71b510p-2,
    -0x1.62b9586ad0a22p-2
  },
  { // Entry 463
    0x1.894ae0cb0ee30b895f6381f3b133dc04p-2,
    0x1.9dd83c7c9e128p-2
  },
  { // Entry 464
    -0x1.894ae0cb0ee30b895f6381f3b133dc04p-2,
    -0x1.9dd83c7c9e128p-2
  },
  { // Entry 465
    0x1.bb12f34bbefd7d5fccadb160103a2001p-2,
    0x1.d8f7208e6b82ep-2
  },
  { // Entry 466
    -0x1.bb12f34bbefd7d5fccadb160103a2001p-2,
    -0x1.d8f7208e6b82ep-2
  },
  { // Entry 467
    0x1.eab7b2edbe26eb1b5fb149357f51d6c9p-2,
    0x1.0a0b02501c799p-1
  },
  { // Entry 468
    -0x1.eab7b2edbe26eb1b5fb149357f51d6c9p-2,
    -0x1.0a0b02501c799p-1
  },
  { // Entry 469
    0x1.1c03f735e817e7f7c907ff3c4e54650dp-1,
    0x1.3d3e35834faccp-1
  },
  { // Entry 470
    -0x1.1c03f735e817e7f7c907ff3c4e54650dp-1,
    -0x1.3d3e35834faccp-1
  },
  { // Entry 471
    0x1.2b5b626353bb1a939a57893481fc6efep-1,
    0x1.52e1f6ad9c27cp-1
  },
  { // Entry 472
    -0x1.2b5b626353bb1a939a57893481fc6efep-1,
    -0x1.52e1f6ad9c27cp-1
  },
  { // Entry 473
    0x1.3a1d01c9f4b1becd56338b2ff004552cp-1,
    0x1.6885b7d7e8a2cp-1
  },
  { // Entry 474
    -0x1.3a1d01c9f4b1becd56338b2ff004552cp-1,
    -0x1.6885b7d7e8a2cp-1
  },
  { // Entry 475
    0x1.484b52126a270cc4c2f0b9b8d5749c23p-1,
    0x1.7e297902351dcp-1
  },
  { // Entry 476
    -0x1.484b52126a270cc4c2f0b9b8d5749c23p-1,
    -0x1.7e297902351dcp-1
  },
  { // Entry 477
    0x1.55e986b4afe0a867e17b875f8892133ep-1,
    0x1.93cd3a2c8198cp-1
  },
  { // Entry 478
    -0x1.55e986b4afe0a867e17b875f8892133ep-1,
    -0x1.93cd3a2c8198cp-1
  },
  { // Entry 479
    0x1.62fb644de198a6df044c5f206ab189e5p-1,
    0x1.a970fb56ce13cp-1
  },
  { // Entry 480
    -0x1.62fb644de198a6df044c5f206ab189e5p-1,
    -0x1.a970fb56ce13cp-1
  },
  { // Entry 481
    0x1.6f851ed60f1de8920ad396732d80e630p-1,
    0x1.bf14bc811a8ecp-1
  },
  { // Entry 482
    -0x1.6f851ed60f1de8920ad396732d80e630p-1,
    -0x1.bf14bc811a8ecp-1
  },
  { // Entry 483
    0x1.7b8b3be13fca3e7ae61ece393dc20351p-1,
    0x1.d4b87dab6709cp-1
  },
  { // Entry 484
    -0x1.7b8b3be13fca3e7ae61ece393dc20351p-1,
    -0x1.d4b87dab6709cp-1
  },
  { // Entry 485
    0x1.871278e2b0224b1a57a7517aa6080561p-1,
    0x1.ea5c3ed5b384cp-1
  },
  { // Entry 486
    -0x1.871278e2b0224b1a57a7517aa6080561p-1,
    -0x1.ea5c3ed5b384cp-1
  },
  { // Entry 487
    0x1.a431f39bc6f4fc2f533fb8b685f7fa56p-1,
    0x1.12bd9173c07abp0
  },
  { // Entry 488
    -0x1.a431f39bc6f4fc2f533fb8b685f7fa56p-1,
    -0x1.12bd9173c07abp0
  },
  { // Entry 489
    0x1.b4fe843e9e8072727b4b8be7730dc9f5p-1,
    0x1.257b22e780f56p0
  },
  { // Entry 490
    -0x1.b4fe843e9e8072727b4b8be7730dc9f5p-1,
    -0x1.257b22e780f56p0
  },
  { // Entry 491
    0x1.c49e488683ad184b42699159db8963c3p-1,
    0x1.3838b45b41701p0
  },
  { // Entry 492
    -0x1.c49e488683ad184b42699159db8963c3p-1,
    -0x1.3838b45b41701p0
  },
  { // Entry 493
    0x1.d3290701e8acc868f20733059c0c608ep-1,
    0x1.4af645cf01eacp0
  },
  { // Entry 494
    -0x1.d3290701e8acc868f20733059c0c608ep-1,
    -0x1.4af645cf01eacp0
  },
  { // Entry 495
    0x1.e0b524b578b44dca424e286b8612b332p-1,
    0x1.5db3d742c2657p0
  },
  { // Entry 496
    -0x1.e0b524b578b44dca424e286b8612b332p-1,
    -0x1.5db3d742c2657p0
  },
  { // Entry 497
    0x1.ed57806b909108a3ff02c70a568bf594p-1,
    0x1.707168b682e02p0
  },
  { // Entry 498
    -0x1.ed57806b909108a3ff02c70a568bf594p-1,
    -0x1.707168b682e02p0
  },
  { // Entry 499
    0x1.f923661b5264a5551df6c3d4c279e2c6p-1,
    0x1.832efa2a435adp0
  },
  { // Entry 500
    -0x1.f923661b5264a5551df6c3d4c279e2c6p-1,
    -0x1.832efa2a435adp0
  },
  { // Entry 501
    0x1.0215495ceb1818f77c287b62995eeddbp0,
    0x1.95ec8b9e03d58p0
  },
  { // Entry 502
    -0x1.0215495ceb1818f77c287b62995eeddbp0,
    -0x1.95ec8b9e03d58p0
  },
  { // Entry 503
    0x1.073ea15c614e11668ba9fe75888fee13p0,
    0x1.a8aa1d11c44ffp0
  },
  { // Entry 504
    -0x1.073ea15c614e11668ba9fe75888fee13p0,
    -0x1.a8aa1d11c44ffp0
  },
  { // Entry 505
    0x1.96c4c0ec290ebef92ab936700e7d3f1bp-1,
    0x1.04aff6d330942p0
  },
  { // Entry 506
    -0x1.96c4c0ec290ebef92ab936700e7d3f1bp-1,
    -0x1.04aff6d330942p0
  },
  { // Entry 507
    0x1.96c565a66992e578d5536359e24d1cffp-1,
    0x1.04b09e98dcdb4p0
  },
  { // Entry 508
    -0x1.96c565a66992e578d5536359e24d1cffp-1,
    -0x1.04b09e98dcdb4p0
  },
  { // Entry 509
    0x1.96c60a603e270ac6f5547fd0c1f8f8ecp-1,
    0x1.04b1465e89226p0
  },
  { // Entry 510
    -0x1.96c60a603e270ac6f5547fd0c1f8f8ecp-1,
    -0x1.04b1465e89226p0
  },
  { // Entry 511
    0x1.96c6af19a6cb76e043213a66372fc856p-1,
    0x1.04b1ee2435698p0
  },
  { // Entry 512
    -0x1.96c6af19a6cb76e043213a66372fc856p-1,
    -0x1.04b1ee2435698p0
  },
  { // Entry 513
    0x1.96c753d2a38071c172287dd0e901a28ep-1,
    0x1.04b295e9e1b0ap0
  },
  { // Entry 514
    -0x1.96c753d2a38071c172287dd0e901a28ep-1,
    -0x1.04b295e9e1b0ap0
  },
  { // Entry 515
    0x1.96c7f88b3446436730e2c7c9e49c64fap-1,
    0x1.04b33daf8df7cp0
  },
  { // Entry 516
    -0x1.96c7f88b3446436730e2c7c9e49c64fap-1,
    -0x1.04b33daf8df7cp0
  },
  { // Entry 517
    0x1.96c89d43591d33ce28d17fec2513bfcbp-1,
    0x1.04b3e5753a3eep0
  },
  { // Entry 518
    -0x1.96c89d43591d33ce28d17fec2513bfcbp-1,
    -0x1.04b3e5753a3eep0
  },
  { // Entry 519
    0x1.96c941fb12058af2fe7e4e965a300441p-1,
    0x1.04b48d3ae6860p0
  },
  { // Entry 520
    -0x1.96c941fb12058af2fe7e4e965a300441p-1,
    -0x1.04b48d3ae6860p0
  },
  { // Entry 521
    0x1.96c9e6b25eff61b237930a7d05a731ebp-1,
    0x1.04b5350092ccfp0
  },
  { // Entry 522
    -0x1.96c9e6b25eff61b237930a7d05a731ebp-1,
    -0x1.04b5350092ccfp0
  },
  { // Entry 523
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 524
    0.0,
    0x1.0p-1074
  },
  { // Entry 525
    -0.0,
    -0.0
  },
  { // Entry 526
    0.0,
    0x1.0p-1074
  },
  { // Entry 527
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 528
    0x1.0c152382d73648a8c8f9175719d84f03p-1,
    0x1.279a74590331bp-1
  },
  { // Entry 529
    -0x1.0c152382d73648a8c8f9175719d84f03p-1,
    -0x1.279a74590331bp-1
  },
  { // Entry 530
    0x1.0c152382d73654a8c8f917571a1aed4ap-1,
    0x1.279a74590331cp-1
  },
  { // Entry 531
    -0x1.0c152382d73654a8c8f917571a1aed4ap-1,
    -0x1.279a74590331cp-1
  },
  { // Entry 532
    0x1.0c152382d73660a8c8f917571a0a6821p-1,
    0x1.279a74590331dp-1
  },
  { // Entry 533
    -0x1.0c152382d73660a8c8f917571a0a6821p-1,
    -0x1.279a74590331dp-1
  },
  { // Entry 534
    0x1.0c152382d7365277925622b33812561ep0,
    0x1.bb67ae8584ca9p0
  },
  { // Entry 535
    -0x1.0c152382d7365277925622b33812561ep0,
    -0x1.bb67ae8584ca9p0
  },
  { // Entry 536
    0x1.0c152382d7365677925622b338471928p0,
    0x1.bb67ae8584caap0
  },
  { // Entry 537
    -0x1.0c152382d7365677925622b338471928p0,
    -0x1.bb67ae8584caap0
  },
  { // Entry 538
    0x1.0c152382d7365a77925622b338446f3cp0,
    0x1.bb67ae8584cabp0
  },
  { // Entry 539
    -0x1.0c152382d7365a77925622b338446f3cp0,
    -0x1.bb67ae8584cabp0
  },
  { // Entry 540
    0x1.a64eec3cc23fbdfe90b96189d12851b4p-2,
    0x1.bffffffffffffp-2
  },
  { // Entry 541
    -0x1.a64eec3cc23fbdfe90b96189d12851b4p-2,
    -0x1.bffffffffffffp-2
  },
  { // Entry 542
    0x1.a64eec3cc23fcb6c84f92bd2003ce26cp-2,
    0x1.cp-2
  },
  { // Entry 543
    -0x1.a64eec3cc23fcb6c84f92bd2003ce26cp-2,
    -0x1.cp-2
  },
  { // Entry 544
    0x1.a64eec3cc23fd8da7938f61a2f29ff73p-2,
    0x1.c000000000001p-2
  },
  { // Entry 545
    -0x1.a64eec3cc23fd8da7938f61a2f29ff73p-2,
    -0x1.c000000000001p-2
  },
  { // Entry 546
    0x1.345f01cce37ba96325eacdc6f7ceec8cp-1,
    0x1.5ffffffffffffp-1
  },
  { // Entry 547
    -0x1.345f01cce37ba96325eacdc6f7ceec8cp-1,
    -0x1.5ffffffffffffp-1
  },
  { // Entry 548
    0x1.345f01cce37bb440844df1c4409fe779p-1,
    0x1.6p-1
  },
  { // Entry 549
    -0x1.345f01cce37bb440844df1c4409fe779p-1,
    -0x1.6p-1
  },
  { // Entry 550
    0x1.345f01cce37bbf1de2b115c1891fbafap-1,
    0x1.6000000000001p-1
  },
  { // Entry 551
    -0x1.345f01cce37bbf1de2b115c1891fbafap-1,
    -0x1.6000000000001p-1
  },
  { // Entry 552
    0x1.bde70ed439fe5f73a215d6096c04b42bp-1,
    0x1.2ffffffffffffp0
  },
  { // Entry 553
    -0x1.bde70ed439fe5f73a215d6096c04b42bp-1,
    -0x1.2ffffffffffffp0
  },
  { // Entry 554
    0x1.bde70ed439fe6cba95391a7f421b3821p-1,
    0x1.3p0
  },
  { // Entry 555
    -0x1.bde70ed439fe6cba95391a7f421b3821p-1,
    -0x1.3p0
  },
  { // Entry 556
    0x1.bde70ed439fe7a01885c5ef51760662ap-1,
    0x1.3000000000001p0
  },
  { // Entry 557
    -0x1.bde70ed439fe7a01885c5ef51760662ap-1,
    -0x1.3000000000001p0
  },
  { // Entry 558
    0x1.2e75728833a53c7ab9de734b9eb4f397p0,
    0x1.37fffffffffffp1
  },
  { // Entry 559
    -0x1.2e75728833a53c7ab9de734b9eb4f397p0,
    -0x1.37fffffffffffp1
  },
  { // Entry 560
    0x1.2e75728833a54116e3ef7326bd9839p0,
    0x1.380p1
  },
  { // Entry 561
    -0x1.2e75728833a54116e3ef7326bd9839p0,
    -0x1.380p1
  },
  { // Entry 562
    0x1.2e75728833a545b30e007301dc13e399p0,
    0x1.3800000000001p1
  },
  { // Entry 563
    -0x1.2e75728833a545b30e007301dc13e399p0,
    -0x1.3800000000001p1
  },
  { // Entry 564
    0x1.0640a74d6105ee338c5bcc6c7348c123p-4,
    0x1.069c8b46b3792p-4
  },
  { // Entry 565
    -0x1.0640a74d6105ee338c5bcc6c7348c123p-4,
    -0x1.069c8b46b3792p-4
  },
  { // Entry 566
    0x1.052fab368e062e72fbf2d39fe9d18888p-3,
    0x1.069c8b46b3792p-3
  },
  { // Entry 567
    -0x1.052fab368e062e72fbf2d39fe9d18888p-3,
    -0x1.069c8b46b3792p-3
  },
  { // Entry 568
    0x1.852a21876f242e8b182abd42c41ee89dp-3,
    0x1.89ead0ea0d35bp-3
  },
  { // Entry 569
    -0x1.852a21876f242e8b182abd42c41ee89dp-3,
    -0x1.89ead0ea0d35bp-3
  },
  { // Entry 570
    0x1.01123bc10a64bf0ab62d6ef7f32651aap-2,
    0x1.069c8b46b3792p-2
  },
  { // Entry 571
    -0x1.01123bc10a64bf0ab62d6ef7f32651aap-2,
    -0x1.069c8b46b3792p-2
  },
  { // Entry 572
    0x1.3daa733ee5357808e68aee008972c828p-2,
    0x1.4843ae1860576p-2
  },
  { // Entry 573
    -0x1.3daa733ee5357808e68aee008972c828p-2,
    -0x1.4843ae1860576p-2
  },
  { // Entry 574
    0x1.780c45b9736a9089f2fe1f8efa60bf44p-2,
    0x1.89ead0ea0d35ap-2
  },
  { // Entry 575
    -0x1.780c45b9736a9089f2fe1f8efa60bf44p-2,
    -0x1.89ead0ea0d35ap-2
  },
  { // Entry 576
    0x1.affaac96d797029e0b8ab4083d980b68p-2,
    0x1.cb91f3bbba13ep-2
  },
  { // Entry 577
    -0x1.affaac96d797029e0b8ab4083d980b68p-2,
    -0x1.cb91f3bbba13ep-2
  },
  { // Entry 578
    0x1.e54c7f9dac6708f315d38c8a8c2ce4d3p-2,
    0x1.069c8b46b3791p-1
  },
  { // Entry 579
    -0x1.e54c7f9dac6708f315d38c8a8c2ce4d3p-2,
    -0x1.069c8b46b3791p-1
  },
  { // Entry 580
    0x1.0bf560a09b924073e473cb0d5c32501ep-1,
    0x1.27701caf89e83p-1
  },
  { // Entry 581
    -0x1.0bf560a09b924073e473cb0d5c32501ep-1,
    -0x1.27701caf89e83p-1
  },
  { // Entry 582
    0x1.23e717d0fa7b0b8bf45d2cd120f6d29ep-1,
    0x1.4843ae1860575p-1
  },
  { // Entry 583
    -0x1.23e717d0fa7b0b8bf45d2cd120f6d29ep-1,
    -0x1.4843ae1860575p-1
  },
  { // Entry 584
    0x1.3a7e3f4793afa9a24b0112ea83035c7ep-1,
    0x1.69173f8136c67p-1
  },
  { // Entry 585
    -0x1.3a7e3f4793afa9a24b0112ea83035c7ep-1,
    -0x1.69173f8136c67p-1
  },
  { // Entry 586
    0x1.4fc2c55f7154871c8daa35843857b7ffp-1,
    0x1.89ead0ea0d359p-1
  },
  { // Entry 587
    -0x1.4fc2c55f7154871c8daa35843857b7ffp-1,
    -0x1.89ead0ea0d359p-1
  },
  { // Entry 588
    0x1.63c05ef8a353c6d1360ead977c2adb94p-1,
    0x1.aabe6252e3a4bp-1
  },
  { // Entry 589
    -0x1.63c05ef8a353c6d1360ead977c2adb94p-1,
    -0x1.aabe6252e3a4bp-1
  },
  { // Entry 590
    0x1.7685624cb374ad8950ee302aee748ad9p-1,
    0x1.cb91f3bbba13dp-1
  },
  { // Entry 591
    -0x1.7685624cb374ad8950ee302aee748ad9p-1,
    -0x1.cb91f3bbba13dp-1
  },
  { // Entry 592
    0x1.8821d1878dcb0371d2ed00f8bad7755ep-1,
    0x1.ec6585249082fp-1
  },
  { // Entry 593
    -0x1.8821d1878dcb0371d2ed00f8bad7755ep-1,
    -0x1.ec6585249082fp-1
  },
  { // Entry 594
    0x1.98a69592999488465c8b6185dd58b38ap-1,
    0x1.069c8b46b3791p0
  },
  { // Entry 595
    -0x1.98a69592999488465c8b6185dd58b38ap-1,
    -0x1.069c8b46b3791p0
  },
  { // Entry 596
    0x1.a824e56beafb17efb9ed12695185cc5bp-1,
    0x1.170653fb1eb0ap0
  },
  { // Entry 597
    -0x1.a824e56beafb17efb9ed12695185cc5bp-1,
    -0x1.170653fb1eb0ap0
  },
  { // Entry 598
    0x1.b6add448714e627e74ee9ce6911993e6p-1,
    0x1.27701caf89e83p0
  },
  { // Entry 599
    -0x1.b6add448714e627e74ee9ce6911993e6p-1,
    -0x1.27701caf89e83p0
  },
  { // Entry 600
    0x1.c4520007344f8b36a1c610e27f4bb57ep-1,
    0x1.37d9e563f51fcp0
  },
  { // Entry 601
    -0x1.c4520007344f8b36a1c610e27f4bb57ep-1,
    -0x1.37d9e563f51fcp0
  },
  { // Entry 602
    0x1.d12159a144ff3c88e549b6c7fe977a6bp-1,
    0x1.4843ae1860575p0
  },
  { // Entry 603
    -0x1.d12159a144ff3c88e549b6c7fe977a6bp-1,
    -0x1.4843ae1860575p0
  },
  { // Entry 604
    0x1.dd2b01e17c4270caa5ead83118478c99p-1,
    0x1.58ad76cccb8eep0
  },
  { // Entry 605
    -0x1.dd2b01e17c4270caa5ead83118478c99p-1,
    -0x1.58ad76cccb8eep0
  },
  { // Entry 606
    0x1.e87d358361bd4751c472fe76608804f7p-1,
    0x1.69173f8136c67p0
  },
  { // Entry 607
    -0x1.e87d358361bd4751c472fe76608804f7p-1,
    -0x1.69173f8136c67p0
  },
  { // Entry 608
    0x1.f32544b66aa5dfd1d5c551c7b435f099p-1,
    0x1.79810835a1fe0p0
  },
  { // Entry 609
    -0x1.f32544b66aa5dfd1d5c551c7b435f099p-1,
    -0x1.79810835a1fe0p0
  },
  { // Entry 610
    0x1.fd2f92d1f51f1d323eacb60983a6f40dp-1,
    0x1.89ead0ea0d359p0
  },
  { // Entry 611
    -0x1.fd2f92d1f51f1d323eacb60983a6f40dp-1,
    -0x1.89ead0ea0d359p0
  },
  { // Entry 612
    0x1.0353cdddc16607e33b1f4c9d55ff1784p0,
    0x1.9a54999e786d2p0
  },
  { // Entry 613
    -0x1.0353cdddc16607e33b1f4c9d55ff1784p0,
    -0x1.9a54999e786d2p0
  },
  { // Entry 614
    0x1.07cbfe8c14dd9ae6823776b5a4d81ba9p0,
    0x1.aabe6252e3a4bp0
  },
  { // Entry 615
    -0x1.07cbfe8c14dd9ae6823776b5a4d81ba9p0,
    -0x1.aabe6252e3a4bp0
  },
  { // Entry 616
    0x1.0c0540ee6eff5cb8c83f0e7e225652c0p0,
    0x1.bb282b074edc4p0
  },
  { // Entry 617
    -0x1.0c0540ee6eff5cb8c83f0e7e225652c0p0,
    -0x1.bb282b074edc4p0
  },
  { // Entry 618
    0x1.1004179915f3bd7827be1c9d557de4b1p0,
    0x1.cb91f3bbba13dp0
  },
  { // Entry 619
    -0x1.1004179915f3bd7827be1c9d557de4b1p0,
    -0x1.cb91f3bbba13dp0
  },
  { // Entry 620
    0x1.13cca8f590cdd610776bb232694ba1c1p0,
    0x1.dbfbbc70254b6p0
  },
  { // Entry 621
    -0x1.13cca8f590cdd610776bb232694ba1c1p0,
    -0x1.dbfbbc70254b6p0
  },
  { // Entry 622
    0x1.1762c60438ce2cf59a91a21864529016p0,
    0x1.ec6585249082fp0
  },
  { // Entry 623
    -0x1.1762c60438ce2cf59a91a21864529016p0,
    -0x1.ec6585249082fp0
  },
  { // Entry 624
    0x1.1ac9f0f5f0ac59ef468d0e8c13eecc94p0,
    0x1.fccf4dd8fbba8p0
  },
  { // Entry 625
    -0x1.1ac9f0f5f0ac59ef468d0e8c13eecc94p0,
    -0x1.fccf4dd8fbba8p0
  },
  { // Entry 626
    0x1.1e05637ffc0a8a6d0a7e22324ebefacfp0,
    0x1.069c8b46b3791p1
  },
  { // Entry 627
    -0x1.1e05637ffc0a8a6d0a7e22324ebefacfp0,
    -0x1.069c8b46b3791p1
  },
  { // Entry 628
    0x1.211814d79540eebd6dda8be7ed197d84p0,
    0x1.0ed16fa0e914ep1
  },
  { // Entry 629
    -0x1.211814d79540eebd6dda8be7ed197d84p0,
    -0x1.0ed16fa0e914ep1
  },
  { // Entry 630
    0x1.2404bf4b3ead000faf892c3f4eb4bfa9p0,
    0x1.170653fb1eb0bp1
  },
  { // Entry 631
    -0x1.2404bf4b3ead000faf892c3f4eb4bfa9p0,
    -0x1.170653fb1eb0bp1
  },
  { // Entry 632
    0x1.26cde575b64162e9e462d564797a5dd7p0,
    0x1.1f3b3855544c8p1
  },
  { // Entry 633
    -0x1.26cde575b64162e9e462d564797a5dd7p0,
    -0x1.1f3b3855544c8p1
  },
  { // Entry 634
    0x1.2975d70a874ee2c0fbc4d32b9997edb4p0,
    0x1.27701caf89e85p1
  },
  { // Entry 635
    -0x1.2975d70a874ee2c0fbc4d32b9997edb4p0,
    -0x1.27701caf89e85p1
  },
  { // Entry 636
    0x1.2bfeb53ef2d629fd2ec3bbe0988ec127p0,
    0x1.2fa50109bf842p1
  },
  { // Entry 637
    -0x1.2bfeb53ef2d629fd2ec3bbe0988ec127p0,
    -0x1.2fa50109bf842p1
  },
  { // Entry 638
    0x1.2e6a76d3a7c4daa88cd0858debcbfd55p0,
    0x1.37d9e563f51ffp1
  },
  { // Entry 639
    -0x1.2e6a76d3a7c4daa88cd0858debcbfd55p0,
    -0x1.37d9e563f51ffp1
  },
  { // Entry 640
    0x1.30baebc4d0b12279c4c6a70a83ec7404p0,
    0x1.400ec9be2abbcp1
  },
  { // Entry 641
    -0x1.30baebc4d0b12279c4c6a70a83ec7404p0,
    -0x1.400ec9be2abbcp1
  },
  { // Entry 642
    0x1.32f1c0a688709db9016d269725c02a4fp0,
    0x1.4843ae1860579p1
  },
  { // Entry 643
    -0x1.32f1c0a688709db9016d269725c02a4fp0,
    -0x1.4843ae1860579p1
  },
  { // Entry 644
    0x1.351081b3f9205c658eef3c57bcc8acb2p0,
    0x1.5078927295f36p1
  },
  { // Entry 645
    -0x1.351081b3f9205c658eef3c57bcc8acb2p0,
    -0x1.5078927295f36p1
  },
  { // Entry 646
    0x1.37189d975e5f9cb962f7bf8cf038ccc8p0,
    0x1.58ad76cccb8f3p1
  },
  { // Entry 647
    -0x1.37189d975e5f9cb962f7bf8cf038ccc8p0,
    -0x1.58ad76cccb8f3p1
  },
  { // Entry 648
    0x1.390b67f0f05fe3c31d028790ff0ff571p0,
    0x1.60e25b27012b0p1
  },
  { // Entry 649
    -0x1.390b67f0f05fe3c31d028790ff0ff571p0,
    -0x1.60e25b27012b0p1
  },
  { // Entry 650
    0x1.3aea1ba270fc7663f575c66a2dbf5ff8p0,
    0x1.69173f8136c6dp1
  },
  { // Entry 651
    -0x1.3aea1ba270fc7663f575c66a2dbf5ff8p0,
    -0x1.69173f8136c6dp1
  },
  { // Entry 652
    0x1.3cb5dce4b8f630b629d722f5ae3dc757p0,
    0x1.714c23db6c62ap1
  },
  { // Entry 653
    -0x1.3cb5dce4b8f630b629d722f5ae3dc757p0,
    -0x1.714c23db6c62ap1
  },
  { // Entry 654
    0x1.3e6fbb2c41396ce4aeff19d97552d217p0,
    0x1.79810835a1fe7p1
  },
  { // Entry 655
    -0x1.3e6fbb2c41396ce4aeff19d97552d217p0,
    -0x1.79810835a1fe7p1
  },
  { // Entry 656
    0x1.4018b2e13fe932bca7539dacbfa4d09ep0,
    0x1.81b5ec8fd79a4p1
  },
  { // Entry 657
    -0x1.4018b2e13fe932bca7539dacbfa4d09ep0,
    -0x1.81b5ec8fd79a4p1
  },
  { // Entry 658
    0x1.41b1aeef8e4ae6bd8723cc148d6caf10p0,
    0x1.89ead0ea0d35bp1
  },
  { // Entry 659
    -0x1.41b1aeef8e4ae6bd8723cc148d6caf10p0,
    -0x1.89ead0ea0d35bp1
  },
  { // Entry 660
    -0x1.6807a9c540dd353125463348a685edc8p0,
    -0x1.81b5ec8fd799fp2
  },
  { // Entry 661
    0x1.6807a9c540dd353125463348a685edc8p0,
    0x1.81b5ec8fd799fp2
  },
  { // Entry 662
    -0x1.6631e1a59590376d984470d99cc8df7bp0,
    -0x1.714c23db6c626p2
  },
  { // Entry 663
    0x1.6631e1a59590376d984470d99cc8df7bp0,
    0x1.714c23db6c626p2
  },
  { // Entry 664
    -0x1.6431bb7edf2bb723008b3c51ca448a76p0,
    -0x1.60e25b27012adp2
  },
  { // Entry 665
    0x1.6431bb7edf2bb723008b3c51ca448a76p0,
    0x1.60e25b27012adp2
  },
  { // Entry 666
    -0x1.6201493b022361bd3c406520761b65cfp0,
    -0x1.5078927295f34p2
  },
  { // Entry 667
    0x1.6201493b022361bd3c406520761b65cfp0,
    0x1.5078927295f34p2
  },
  { // Entry 668
    -0x1.5f9977a47aee17d0f12c193a7dd62259p0,
    -0x1.400ec9be2abbbp2
  },
  { // Entry 669
    0x1.5f9977a47aee17d0f12c193a7dd62259p0,
    0x1.400ec9be2abbbp2
  },
  { // Entry 670
    -0x1.5cf1c53dd9ca9fa29b3bb04ec56e073fp0,
    -0x1.2fa50109bf842p2
  },
  { // Entry 671
    0x1.5cf1c53dd9ca9fa29b3bb04ec56e073fp0,
    0x1.2fa50109bf842p2
  },
  { // Entry 672
    -0x1.59ffe278fb5d0fd66d3a875f34e955b9p0,
    -0x1.1f3b3855544c9p2
  },
  { // Entry 673
    0x1.59ffe278fb5d0fd66d3a875f34e955b9p0,
    0x1.1f3b3855544c9p2
  },
  { // Entry 674
    -0x1.56b732e5cd9e7665c855c33ec7ba86a3p0,
    -0x1.0ed16fa0e9150p2
  },
  { // Entry 675
    0x1.56b732e5cd9e7665c855c33ec7ba86a3p0,
    0x1.0ed16fa0e9150p2
  },
  { // Entry 676
    -0x1.530823483d3605b2bd96ffaf2c4679c9p0,
    -0x1.fccf4dd8fbbaep1
  },
  { // Entry 677
    0x1.530823483d3605b2bd96ffaf2c4679c9p0,
    0x1.fccf4dd8fbbaep1
  },
  { // Entry 678
    -0x1.4edf430c0024477cefffec364da85c1dp0,
    -0x1.dbfbbc70254bcp1
  },
  { // Entry 679
    0x1.4edf430c0024477cefffec364da85c1dp0,
    0x1.dbfbbc70254bcp1
  },
  { // Entry 680
    -0x1.4a2407447a81c7dc1121259e08565d3ep0,
    -0x1.bb282b074edcap1
  },
  { // Entry 681
    0x1.4a2407447a81c7dc1121259e08565d3ep0,
    0x1.bb282b074edcap1
  },
  { // Entry 682
    -0x1.44b710bde944f5b73d2380913fb96b93p0,
    -0x1.9a54999e786d8p1
  },
  { // Entry 683
    0x1.44b710bde944f5b73d2380913fb96b93p0,
    0x1.9a54999e786d8p1
  },
  { // Entry 684
    -0x1.3e6fbb2c41396997fae3ce7cb202ab3cp0,
    -0x1.79810835a1fe6p1
  },
  { // Entry 685
    0x1.3e6fbb2c41396997fae3ce7cb202ab3cp0,
    0x1.79810835a1fe6p1
  },
  { // Entry 686
    -0x1.37189d975e5fa09a38272d7f560e0da4p0,
    -0x1.58ad76cccb8f4p1
  },
  { // Entry 687
    0x1.37189d975e5fa09a38272d7f560e0da4p0,
    0x1.58ad76cccb8f4p1
  },
  { // Entry 688
    -0x1.2e6a76d3a7c4e87fefa518c326ab6156p0,
    -0x1.37d9e563f5202p1
  },
  { // Entry 689
    0x1.2e6a76d3a7c4e87fefa518c326ab6156p0,
    0x1.37d9e563f5202p1
  },
  { // Entry 690
    -0x1.2404bf4b3ead1be0d614e16bd1916f4dp0,
    -0x1.170653fb1eb10p1
  },
  { // Entry 691
    0x1.2404bf4b3ead1be0d614e16bd1916f4dp0,
    0x1.170653fb1eb10p1
  },
  { // Entry 692
    -0x1.1762c60438ce5938069b20cf6314944ap0,
    -0x1.ec6585249083cp0
  },
  { // Entry 693
    0x1.1762c60438ce5938069b20cf6314944ap0,
    0x1.ec6585249083cp0
  },
  { // Entry 694
    -0x1.07cbfe8c14ddd1f1d38ba981b0996a1ap0,
    -0x1.aabe6252e3a58p0
  },
  { // Entry 695
    0x1.07cbfe8c14ddd1f1d38ba981b0996a1ap0,
    0x1.aabe6252e3a58p0
  },
  { // Entry 696
    -0x1.e87d358361bdd2789fd13900549104c2p-1,
    -0x1.69173f8136c74p0
  },
  { // Entry 697
    0x1.e87d358361bdd2789fd13900549104c2p-1,
    0x1.69173f8136c74p0
  },
  { // Entry 698
    -0x1.b6add448714f14e4cbd045740116f534p-1,
    -0x1.27701caf89e90p0
  },
  { // Entry 699
    0x1.b6add448714f14e4cbd045740116f534p-1,
    0x1.27701caf89e90p0
  },
  { // Entry 700
    -0x1.7685624cb37593eb960af368aeea2616p-1,
    -0x1.cb91f3bbba157p-1
  },
  { // Entry 701
    0x1.7685624cb37593eb960af368aeea2616p-1,
    0x1.cb91f3bbba157p-1
  },
  { // Entry 702
    -0x1.23e717d0fa7c2705659e11ed85e6dac4p-1,
    -0x1.4843ae186058ep-1
  },
  { // Entry 703
    0x1.23e717d0fa7c2705659e11ed85e6dac4p-1,
    0x1.4843ae186058ep-1
  },
  { // Entry 704
    -0x1.780c45b9736d2d89e5dbc5fe7167a786p-2,
    -0x1.89ead0ea0d38ap-2
  },
  { // Entry 705
    0x1.780c45b9736d2d89e5dbc5fe7167a786p-2,
    0x1.89ead0ea0d38ap-2
  },
  { // Entry 706
    -0x1.052fab368e0bf61ea3f942bd2601e1bap-3,
    -0x1.069c8b46b37f0p-3
  },
  { // Entry 707
    0x1.052fab368e0bf61ea3f942bd2601e1bap-3,
    0x1.069c8b46b37f0p-3
  },
  { // Entry 708
    0x1.052fab368e0066c753ec64819b76a489p-3,
    0x1.069c8b46b3734p-3
  },
  { // Entry 709
    -0x1.052fab368e0066c753ec64819b76a489p-3,
    -0x1.069c8b46b3734p-3
  },
  { // Entry 710
    0x1.780c45b973680f69ff94600d976ecca3p-2,
    0x1.89ead0ea0d32cp-2
  },
  { // Entry 711
    -0x1.780c45b973680f69ff94600d976ecca3p-2,
    -0x1.89ead0ea0d32cp-2
  },
  { // Entry 712
    0x1.23e717d0fa7a1216d86181eab105dcf9p-1,
    0x1.4843ae186055fp-1
  },
  { // Entry 713
    -0x1.23e717d0fa7a1216d86181eab105dcf9p-1,
    -0x1.4843ae186055fp-1
  },
  { // Entry 714
    0x1.7685624cb373f375056aa629c14d7f7ep-1,
    0x1.cb91f3bbba128p-1
  },
  { // Entry 715
    -0x1.7685624cb373f375056aa629c14d7f7ep-1,
    -0x1.cb91f3bbba128p-1
  },
  { // Entry 716
    0x1.b6add448714dcb8a52cd35a987330f71p-1,
    0x1.27701caf89e78p0
  },
  { // Entry 717
    -0x1.b6add448714dcb8a52cd35a987330f71p-1,
    -0x1.27701caf89e78p0
  },
  { // Entry 718
    0x1.e87d358361bcd19359996a7779c977a2p-1,
    0x1.69173f8136c5cp0
  },
  { // Entry 719
    -0x1.e87d358361bcd19359996a7779c977a2p-1,
    -0x1.69173f8136c5cp0
  },
  { // Entry 720
    0x1.07cbfe8c14dd6c531603e943f23b5395p0,
    0x1.aabe6252e3a40p0
  },
  { // Entry 721
    -0x1.07cbfe8c14dd6c531603e943f23b5395p0,
    -0x1.aabe6252e3a40p0
  },
  { // Entry 722
    0x1.1762c60438ce078252d85e42621311efp0,
    0x1.ec65852490824p0
  },
  { // Entry 723
    -0x1.1762c60438ce078252d85e42621311efp0,
    -0x1.ec65852490824p0
  },
  { // Entry 724
    0x1.2404bf4b3eacd91e132bfb674e2913adp0,
    0x1.170653fb1eb04p1
  },
  { // Entry 725
    -0x1.2404bf4b3eacd91e132bfb674e2913adp0,
    -0x1.170653fb1eb04p1
  },
  { // Entry 726
    0x1.2e6a76d3a7c4b1226452cbee254cb00ep0,
    0x1.37d9e563f51f6p1
  },
  { // Entry 727
    -0x1.2e6a76d3a7c4b1226452cbee254cb00ep0,
    -0x1.37d9e563f51f6p1
  },
  { // Entry 728
    0x1.37189d975e5f721039ee06227b2cc34ep0,
    0x1.58ad76cccb8e8p1
  },
  { // Entry 729
    -0x1.37189d975e5f721039ee06227b2cc34ep0,
    -0x1.58ad76cccb8e8p1
  },
  { // Entry 730
    0x1.3e6fbb2c413941ff899c462376afaff3p0,
    0x1.79810835a1fdap1
  },
  { // Entry 731
    -0x1.3e6fbb2c413941ff899c462376afaff3p0,
    -0x1.79810835a1fdap1
  },
  { // Entry 732
    0x1.44b710bde944d3a9aeff63d91fa1f037p0,
    0x1.9a54999e786ccp1
  },
  { // Entry 733
    -0x1.44b710bde944d3a9aeff63d91fa1f037p0,
    -0x1.9a54999e786ccp1
  },
  { // Entry 734
    0x1.4a2407447a81aa4a6751ba1c00ad16b4p0,
    0x1.bb282b074edbep1
  },
  { // Entry 735
    -0x1.4a2407447a81aa4a6751ba1c00ad16b4p0,
    -0x1.bb282b074edbep1
  },
  { // Entry 736
    0x1.4edf430c00242d9760af2ba3d134ee30p0,
    0x1.dbfbbc70254b0p1
  },
  { // Entry 737
    -0x1.4edf430c00242d9760af2ba3d134ee30p0,
    -0x1.dbfbbc70254b0p1
  },
  { // Entry 738
    0x1.530823483d35eed7bdc41c7d43d4d1bep0,
    0x1.fccf4dd8fbba2p1
  },
  { // Entry 739
    -0x1.530823483d35eed7bdc41c7d43d4d1bep0,
    -0x1.fccf4dd8fbba2p1
  },
  { // Entry 740
    0x1.56b732e5cd9e621620c292f21c370a65p0,
    0x1.0ed16fa0e914ap2
  },
  { // Entry 741
    -0x1.56b732e5cd9e621620c292f21c370a65p0,
    -0x1.0ed16fa0e914ap2
  },
  { // Entry 742
    0x1.59ffe278fb5cfdacbc51061667641320p0,
    0x1.1f3b3855544c3p2
  },
  { // Entry 743
    -0x1.59ffe278fb5cfdacbc51061667641320p0,
    -0x1.1f3b3855544c3p2
  },
  { // Entry 744
    0x1.5cf1c53dd9ca8f4d320efaf2bed238dep0,
    0x1.2fa50109bf83cp2
  },
  { // Entry 745
    -0x1.5cf1c53dd9ca8f4d320efaf2bed238dep0,
    -0x1.2fa50109bf83cp2
  },
  { // Entry 746
    0x1.5f9977a47aee090d54ca7b763af2b8f6p0,
    0x1.400ec9be2abb5p2
  },
  { // Entry 747
    -0x1.5f9977a47aee090d54ca7b763af2b8f6p0,
    -0x1.400ec9be2abb5p2
  },
  { // Entry 748
    0x1.6201493b02235454cfe997849b56e6a4p0,
    0x1.5078927295f2ep2
  },
  { // Entry 749
    -0x1.6201493b02235454cfe997849b56e6a4p0,
    -0x1.5078927295f2ep2
  },
  { // Entry 750
    0x1.6431bb7edf2baae88464ead12ab4619ep0,
    0x1.60e25b27012a7p2
  },
  { // Entry 751
    -0x1.6431bb7edf2baae88464ead12ab4619ep0,
    -0x1.60e25b27012a7p2
  },
  { // Entry 752
    0x1.6631e1a595902c3b42171a76898ec8fbp0,
    0x1.714c23db6c620p2
  },
  { // Entry 753
    -0x1.6631e1a595902c3b42171a76898ec8fbp0,
    -0x1.714c23db6c620p2
  },
  { // Entry 754
    0x1.6807a9c540dd2ae72a3e8ad8c9147867p0,
    0x1.81b5ec8fd7999p2
  },
  { // Entry 755
    -0x1.6807a9c540dd2ae72a3e8ad8c9147867p0,
    -0x1.81b5ec8fd7999p2
  },
  { // Entry 756
    0x1.ef652dceca4daec044deb346c4b08d48p-5,
    0x1.effffffffffffp-5
  },
  { // Entry 757
    -0x1.ef652dceca4daec044deb346c4b08d48p-5,
    -0x1.effffffffffffp-5
  },
  { // Entry 758
    0x1.ef652dceca4dbeb14ee907159dd1c369p-5,
    0x1.fp-5
  },
  { // Entry 759
    -0x1.ef652dceca4dbeb14ee907159dd1c369p-5,
    -0x1.fp-5
  },
  { // Entry 760
    0x1.ef652dceca4dcea258f35ae476f20359p-5,
    0x1.f000000000001p-5
  },
  { // Entry 761
    -0x1.ef652dceca4dcea258f35ae476f20359p-5,
    -0x1.f000000000001p-5
  },
  { // Entry 762
    0x1.f57ab026c3a8ecb83ec0ccdd10add49ep-4,
    0x1.f7fffffffffffp-4
  },
  { // Entry 763
    -0x1.f57ab026c3a8ecb83ec0ccdd10add49ep-4,
    -0x1.f7fffffffffffp-4
  },
  { // Entry 764
    0x1.f57ab026c3a8fc7b278a06e9d0c43e3ap-4,
    0x1.f80p-4
  },
  { // Entry 765
    -0x1.f57ab026c3a8fc7b278a06e9d0c43e3ap-4,
    -0x1.f80p-4
  },
  { // Entry 766
    0x1.f57ab026c3a90c3e105340f690d6d5afp-4,
    0x1.f800000000001p-4
  },
  { // Entry 767
    -0x1.f57ab026c3a90c3e105340f690d6d5afp-4,
    -0x1.f800000000001p-4
  },
  { // Entry 768
    0x1.4923024ccb77ffc36091a6f234051783p-3,
    0x1.4bfffffffffffp-3
  },
  { // Entry 769
    -0x1.4923024ccb77ffc36091a6f234051783p-3,
    -0x1.4bfffffffffffp-3
  },
  { // Entry 770
    0x1.4923024ccb780f5a7e2ead4e2bd24d33p-3,
    0x1.4c0p-3
  },
  { // Entry 771
    -0x1.4923024ccb780f5a7e2ead4e2bd24d33p-3,
    -0x1.4c0p-3
  },
  { // Entry 772
    0x1.4923024ccb781ef19bcbb3aa2395a92bp-3,
    0x1.4c00000000001p-3
  },
  { // Entry 773
    -0x1.4923024ccb781ef19bcbb3aa2395a92bp-3,
    -0x1.4c00000000001p-3
  },
  { // Entry 774
    0x1.2a73a661eaf04c94833e0199180e931dp-2,
    0x1.3333333333332p-2
  },
  { // Entry 775
    -0x1.2a73a661eaf04c94833e0199180e931dp-2,
    -0x1.3333333333332p-2
  },
  { // Entry 776
    0x1.2a73a661eaf05b424f928e83f4ea7bc2p-2,
    0x1.3333333333333p-2
  },
  { // Entry 777
    -0x1.2a73a661eaf05b424f928e83f4ea7bc2p-2,
    -0x1.3333333333333p-2
  },
  { // Entry 778
    0x1.2a73a661eaf069f01be71b6ed1a61259p-2,
    0x1.3333333333334p-2
  },
  { // Entry 779
    -0x1.2a73a661eaf069f01be71b6ed1a61259p-2,
    -0x1.3333333333334p-2
  },
  { // Entry 780
    0x1.2fc48220cc1fce7fc93a77a07e48b002p-1,
    0x1.594317acc4ef8p-1
  },
  { // Entry 781
    -0x1.2fc48220cc1fce7fc93a77a07e48b002p-1,
    -0x1.594317acc4ef8p-1
  },
  { // Entry 782
    0x1.2fc48220cc1fd97f6b9419f2cefa0646p-1,
    0x1.594317acc4ef9p-1
  },
  { // Entry 783
    -0x1.2fc48220cc1fd97f6b9419f2cefa0646p-1,
    -0x1.594317acc4ef9p-1
  },
  { // Entry 784
    0x1.2fc48220cc1fe47f0dedbc451f59c99cp-1,
    0x1.594317acc4efap-1
  },
  { // Entry 785
    -0x1.2fc48220cc1fe47f0dedbc451f59c99cp-1,
    -0x1.594317acc4efap-1
  },
  { // Entry 786
    0x1.538f57b89061e1a19793adab72dc4cd0p-1,
    0x1.8ffffffffffffp-1
  },
  { // Entry 787
    -0x1.538f57b89061e1a19793adab72dc4cd0p-1,
    -0x1.8ffffffffffffp-1
  },
  { // Entry 788
    0x1.538f57b89061eb9122d5096b7cf267ebp-1,
    0x1.9p-1
  },
  { // Entry 789
    -0x1.538f57b89061eb9122d5096b7cf267ebp-1,
    -0x1.9p-1
  },
  { // Entry 790
    0x1.538f57b89061f580ae16652b86bb6353p-1,
    0x1.9000000000001p-1
  },
  { // Entry 791
    -0x1.538f57b89061f580ae16652b86bb6353p-1,
    -0x1.9000000000001p-1
  },
  { // Entry 792
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 793
    0.0,
    0x1.0p-1074
  },
  { // Entry 794
    -0.0,
    -0.0
  },
  { // Entry 795
    0.0,
    0x1.0p-1074
  },
  { // Entry 796
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 797
    0x1.91cd24dd4f86f3abcfa4276d83a13d73p-5,
    0x1.921fb54442d17p-5
  },
  { // Entry 798
    -0x1.91cd24dd4f86f3abcfa4276d83a13d73p-5,
    -0x1.921fb54442d17p-5
  },
  { // Entry 799
    0x1.91cd24dd4f8703a1f7188f1d645421b1p-5,
    0x1.921fb54442d18p-5
  },
  { // Entry 800
    -0x1.91cd24dd4f8703a1f7188f1d645421b1p-5,
    -0x1.921fb54442d18p-5
  },
  { // Entry 801
    0x1.91cd24dd4f8713981e8cf6cd45063dd6p-5,
    0x1.921fb54442d19p-5
  },
  { // Entry 802
    -0x1.91cd24dd4f8713981e8cf6cd45063dd6p-5,
    -0x1.921fb54442d19p-5
  },
  { // Entry 803
    0x1.90d6dfbf0463be2efc3d3ae995b9e240p-4,
    0x1.921fb54442d17p-4
  },
  { // Entry 804
    -0x1.90d6dfbf0463be2efc3d3ae995b9e240p-4,
    -0x1.921fb54442d17p-4
  },
  { // Entry 805
    0x1.90d6dfbf0463ce07e23e541458c4aa07p-4,
    0x1.921fb54442d18p-4
  },
  { // Entry 806
    -0x1.90d6dfbf0463ce07e23e541458c4aa07p-4,
    -0x1.921fb54442d18p-4
  },
  { // Entry 807
    0x1.90d6dfbf0463dde0c83f6d3f1bcc5cd7p-4,
    0x1.921fb54442d19p-4
  },
  { // Entry 808
    -0x1.90d6dfbf0463dde0c83f6d3f1bcc5cd7p-4,
    -0x1.921fb54442d19p-4
  },
  { // Entry 809
    0x1.8d128eae9561353a88062ef0a34b4e80p-3,
    0x1.921fb54442d17p-3
  },
  { // Entry 810
    -0x1.8d128eae9561353a88062ef0a34b4e80p-3,
    -0x1.921fb54442d17p-3
  },
  { // Entry 811
    0x1.8d128eae956144a27ad04eaa5b924d06p-3,
    0x1.921fb54442d18p-3
  },
  { // Entry 812
    -0x1.8d128eae956144a27ad04eaa5b924d06p-3,
    -0x1.921fb54442d18p-3
  },
  { // Entry 813
    0x1.8d128eae9561540a6d9a6e6413cda4f7p-3,
    0x1.921fb54442d19p-3
  },
  { // Entry 814
    -0x1.8d128eae9561540a6d9a6e6413cda4f7p-3,
    -0x1.921fb54442d19p-3
  },
  { // Entry 815
    0x1.7f2d6a24777e099c2376cf0898b3c360p-2,
    0x1.921fb54442d17p-2
  },
  { // Entry 816
    -0x1.7f2d6a24777e099c2376cf0898b3c360p-2,
    -0x1.921fb54442d17p-2
  },
  { // Entry 817
    0x1.7f2d6a24777e1778e0d5c62102085610p-2,
    0x1.921fb54442d18p-2
  },
  { // Entry 818
    -0x1.7f2d6a24777e1778e0d5c62102085610p-2,
    -0x1.921fb54442d18p-2
  },
  { // Entry 819
    0x1.7f2d6a24777e25559e34bd396b372d9ep-2,
    0x1.921fb54442d19p-2
  },
  { // Entry 820
    -0x1.7f2d6a24777e25559e34bd396b372d9ep-2,
    -0x1.921fb54442d19p-2
  },
  { // Entry 821
    0x1.54e04c05d069fa1ecac0c3f5d7fae70fp-1,
    0x1.921fb54442d17p-1
  },
  { // Entry 822
    -0x1.54e04c05d069fa1ecac0c3f5d7fae70fp-1,
    -0x1.921fb54442d17p-1
  },
  { // Entry 823
    0x1.54e04c05d06a04041ccf30f00110c0f6p-1,
    0x1.921fb54442d18p-1
  },
  { // Entry 824
    -0x1.54e04c05d06a04041ccf30f00110c0f6p-1,
    -0x1.921fb54442d18p-1
  },
  { // Entry 825
    0x1.54e04c05d06a0de96edd9dea29d9b191p-1,
    0x1.921fb54442d19p-1
  },
  { // Entry 826
    -0x1.54e04c05d06a0de96edd9dea29d9b191p-1,
    -0x1.921fb54442d19p-1
  },
  { // Entry 827
    0x1.00fe987ed02fed962e123a7e12a6d283p0,
    0x1.921fb54442d17p0
  },
  { // Entry 828
    -0x1.00fe987ed02fed962e123a7e12a6d283p0,
    -0x1.921fb54442d17p0
  },
  { // Entry 829
    0x1.00fe987ed02ff23377d99ec36db533fep0,
    0x1.921fb54442d18p0
  },
  { // Entry 830
    -0x1.00fe987ed02ff23377d99ec36db533fep0,
    -0x1.921fb54442d18p0
  },
  { // Entry 831
    0x1.00fe987ed02ff6d0c1a10308c880b0d3p0,
    0x1.921fb54442d19p0
  },
  { // Entry 832
    -0x1.00fe987ed02ff6d0c1a10308c880b0d3p0,
    -0x1.921fb54442d19p0
  },
  { // Entry 833
    0x1.433b8a322ddd266fd81ec843d7c92a7ap0,
    0x1.921fb54442d17p1
  },
  { // Entry 834
    -0x1.433b8a322ddd266fd81ec843d7c92a7ap0,
    -0x1.921fb54442d17p1
  },
  { // Entry 835
    0x1.433b8a322ddd29618168a21c962c68bcp0,
    0x1.921fb54442d18p1
  },
  { // Entry 836
    -0x1.433b8a322ddd29618168a21c962c68bcp0,
    -0x1.921fb54442d18p1
  },
  { // Entry 837
    0x1.433b8a322ddd2c532ab27bf55459320bp0,
    0x1.921fb54442d19p1
  },
  { // Entry 838
    -0x1.433b8a322ddd2c532ab27bf55459320bp0,
    -0x1.921fb54442d19p1
  },
  { // Entry 839
    0x1.69b8154baf42e0f527ff3f4df7a4633ep0,
    0x1.921fb54442d17p2
  },
  { // Entry 840
    -0x1.69b8154baf42e0f527ff3f4df7a4633ep0,
    -0x1.921fb54442d17p2
  },
  { // Entry 841
    0x1.69b8154baf42e289ea46de59f75a7b90p0,
    0x1.921fb54442d18p2
  },
  { // Entry 842
    -0x1.69b8154baf42e289ea46de59f75a7b90p0,
    -0x1.921fb54442d18p2
  },
  { // Entry 843
    0x1.69b8154baf42e41eac8e7d65f6f129e7p0,
    0x1.921fb54442d19p2
  },
  { // Entry 844
    -0x1.69b8154baf42e41eac8e7d65f6f129e7p0,
    -0x1.921fb54442d19p2
  },
  { // Entry 845
    0x1.7dcb7c5c399ec04ad5c1eabbb0cccf9fp0,
    0x1.921fb54442d17p3
  },
  { // Entry 846
    -0x1.7dcb7c5c399ec04ad5c1eabbb0cccf9fp0,
    -0x1.921fb54442d17p3
  },
  { // Entry 847
    0x1.7dcb7c5c399ec11908f5986443f30bdap0,
    0x1.921fb54442d18p3
  },
  { // Entry 848
    -0x1.7dcb7c5c399ec11908f5986443f30bdap0,
    -0x1.921fb54442d18p3
  },
  { // Entry 849
    0x1.7dcb7c5c399ec1e73c29460cd708f9d8p0,
    0x1.921fb54442d19p3
  },
  { // Entry 850
    -0x1.7dcb7c5c399ec1e73c29460cd708f9d8p0,
    -0x1.921fb54442d19p3
  },
  { // Entry 851
    0x1.87f17cfda0b5caf7b170dd86f8287b63p0,
    0x1.921fb54442d17p4
  },
  { // Entry 852
    -0x1.87f17cfda0b5caf7b170dd86f8287b63p0,
    -0x1.921fb54442d17p4
  },
  { // Entry 853
    0x1.87f17cfda0b5cb5f4832c04cdf736f84p0,
    0x1.921fb54442d18p4
  },
  { // Entry 854
    -0x1.87f17cfda0b5cb5f4832c04cdf736f84p0,
    -0x1.921fb54442d18p4
  },
  { // Entry 855
    0x1.87f17cfda0b5cbc6def4a312c6b628b0p0,
    0x1.921fb54442d19p4
  },
  { // Entry 856
    -0x1.87f17cfda0b5cbc6def4a312c6b628b0p0,
    -0x1.921fb54442d19p4
  },
  { // Entry 857
    0x1.8d08152eddb7a3b8c976d7e120ba1197p0,
    0x1.921fb54442d17p5
  },
  { // Entry 858
    -0x1.8d08152eddb7a3b8c976d7e120ba1197p0,
    -0x1.921fb54442d17p5
  },
  { // Entry 859
    0x1.8d08152eddb7a3eca4948f3acff50864p0,
    0x1.921fb54442d18p5
  },
  { // Entry 860
    -0x1.8d08152eddb7a3eca4948f3acff50864p0,
    -0x1.921fb54442d18p5
  },
  { // Entry 861
    0x1.8d08152eddb7a4207fb246947f2bdf35p0,
    0x1.921fb54442d19p5
  },
  { // Entry 862
    -0x1.8d08152eddb7a4207fb246947f2bdf35p0,
    -0x1.921fb54442d19p5
  },
  { // Entry 863
    0x1.8f93d4b78b7cddf446e36e538b980193p0,
    0x1.921fb54442d17p6
  },
  { // Entry 864
    -0x1.8f93d4b78b7cddf446e36e538b980193p0,
    -0x1.921fb54442d17p6
  },
  { // Entry 865
    0x1.8f93d4b78b7cde0e366aa212646d3cb6p0,
    0x1.921fb54442d18p6
  },
  { // Entry 866
    -0x1.8f93d4b78b7cde0e366aa212646d3cb6p0,
    -0x1.921fb54442d18p6
  },
  { // Entry 867
    0x1.8f93d4b78b7cde2825f1d5d13d40678bp0,
    0x1.921fb54442d19p6
  },
  { // Entry 868
    -0x1.8f93d4b78b7cde2825f1d5d13d40678bp0,
    -0x1.921fb54442d19p6
  },
  { // Entry 869
    0x1.90d9c2ed8873775a4f6e3fe4c3a5982bp0,
    0x1.921fb54442d17p7
  },
  { // Entry 870
    -0x1.90d9c2ed8873775a4f6e3fe4c3a5982bp0,
    -0x1.921fb54442d17p7
  },
  { // Entry 871
    0x1.90d9c2ed887377674770eac36c2436b5p0,
    0x1.921fb54442d18p7
  },
  { // Entry 872
    -0x1.90d9c2ed887377674770eac36c2436b5p0,
    -0x1.921fb54442d18p7
  },
  { // Entry 873
    0x1.90d9c2ed887377743f7395a214a1cd0ep0,
    0x1.921fb54442d19p7
  },
  { // Entry 874
    -0x1.90d9c2ed887377743f7395a214a1cd0ep0,
    -0x1.921fb54442d19p7
  },
  { // Entry 875
    0x1.2b5f4b53c7948df5568782d0a75b8459p0,
    0x1.2d97c7f3321d1p1
  },
  { // Entry 876
    -0x1.2b5f4b53c7948df5568782d0a75b8459p0,
    -0x1.2d97c7f3321d1p1
  },
  { // Entry 877
    0x1.2b5f4b53c79492d7b5a6cd6203c9aae2p0,
    0x1.2d97c7f3321d2p1
  },
  { // Entry 878
    -0x1.2b5f4b53c79492d7b5a6cd6203c9aae2p0,
    -0x1.2d97c7f3321d2p1
  },
  { // Entry 879
    0x1.2b5f4b53c79497ba14c617f35fc7662ep0,
    0x1.2d97c7f3321d3p1
  },
  { // Entry 880
    -0x1.2b5f4b53c79497ba14c617f35fc7662ep0,
    -0x1.2d97c7f3321d3p1
  },
  { // Entry 881
    0x1.524a69fcff2af09f5f140df341a455ddp0,
    0x1.f6a7a2955385dp1
  },
  { // Entry 882
    -0x1.524a69fcff2af09f5f140df341a455ddp0,
    -0x1.f6a7a2955385dp1
  },
  { // Entry 883
    0x1.524a69fcff2af2923cab5c00b660c55fp0,
    0x1.f6a7a2955385ep1
  },
  { // Entry 884
    -0x1.524a69fcff2af2923cab5c00b660c55fp0,
    -0x1.f6a7a2955385ep1
  },
  { // Entry 885
    0x1.524a69fcff2af4851a42aa0e2aff61bcp0,
    0x1.f6a7a2955385fp1
  },
  { // Entry 886
    -0x1.524a69fcff2af4851a42aa0e2aff61bcp0,
    -0x1.f6a7a2955385fp1
  },
  { // Entry 887
    0x1.5c97d37d98aa37af1a1b75a619098288p0,
    0x1.2d97c7f3321d1p2
  },
  { // Entry 888
    -0x1.5c97d37d98aa37af1a1b75a619098288p0,
    -0x1.2d97c7f3321d1p2
  },
  { // Entry 889
    0x1.5c97d37d98aa3a711b94359371aaf903p0,
    0x1.2d97c7f3321d2p2
  },
  { // Entry 890
    -0x1.5c97d37d98aa3a711b94359371aaf903p0,
    -0x1.2d97c7f3321d2p2
  },
  { // Entry 891
    0x1.5c97d37d98aa3d331d0cf580ca04c102p0,
    0x1.2d97c7f3321d3p2
  },
  { // Entry 892
    -0x1.5c97d37d98aa3d331d0cf580ca04c102p0,
    -0x1.2d97c7f3321d3p2
  },
  { // Entry 893
    0x1.64102fc571c7422b6ad0ed05fd24e652p0,
    0x1.5fdbbe9bba774p2
  },
  { // Entry 894
    -0x1.64102fc571c7422b6ad0ed05fd24e652p0,
    -0x1.5fdbbe9bba774p2
  },
  { // Entry 895
    0x1.64102fc571c744381d266feb08ddfcc4p0,
    0x1.5fdbbe9bba775p2
  },
  { // Entry 896
    -0x1.64102fc571c744381d266feb08ddfcc4p0,
    -0x1.5fdbbe9bba775p2
  },
  { // Entry 897
    0x1.64102fc571c74644cf7bf2d01468e265p0,
    0x1.5fdbbe9bba776p2
  },
  { // Entry 898
    -0x1.64102fc571c74644cf7bf2d01468e265p0,
    -0x1.5fdbbe9bba776p2
  },
  { // Entry 899
    0x1.6e2561a6cd2181c009d7d863e666c437p0,
    0x1.c463abeccb2bap2
  },
  { // Entry 900
    -0x1.6e2561a6cd2181c009d7d863e666c437p0,
    -0x1.c463abeccb2bap2
  },
  { // Entry 901
    0x1.6e2561a6cd21830183c87ae1761354b0p0,
    0x1.c463abeccb2bbp2
  },
  { // Entry 902
    -0x1.6e2561a6cd21830183c87ae1761354b0p0,
    -0x1.c463abeccb2bbp2
  },
  { // Entry 903
    0x1.6e2561a6cd218442fdb91d5f05a99ap0,
    0x1.c463abeccb2bcp2
  },
  { // Entry 904
    -0x1.6e2561a6cd218442fdb91d5f05a99ap0,
    -0x1.c463abeccb2bcp2
  },
  { // Entry 905
    0x1.71b4100f0956769d1c64ae4d729107a5p0,
    0x1.f6a7a2955385dp2
  },
  { // Entry 906
    -0x1.71b4100f0956769d1c64ae4d729107a5p0,
    -0x1.f6a7a2955385dp2
  },
  { // Entry 907
    0x1.71b4100f095677a27b2c03b940d5e613p0,
    0x1.f6a7a2955385ep2
  },
  { // Entry 908
    -0x1.71b4100f095677a27b2c03b940d5e613p0,
    -0x1.f6a7a2955385ep2
  },
  { // Entry 909
    0x1.71b4100f095678a7d9f359250f0a64c8p0,
    0x1.f6a7a2955385fp2
  },
  { // Entry 910
    -0x1.71b4100f095678a7d9f359250f0a64c8p0,
    -0x1.f6a7a2955385fp2
  },
  { // Entry 911
    0x1.749f96097c7015073733e2e3659a844bp0,
    0x1.1475cc9eedeffp3
  },
  { // Entry 912
    -0x1.749f96097c7015073733e2e3659a844bp0,
    -0x1.1475cc9eedeffp3
  },
  { // Entry 913
    0x1.749f96097c7016b86e95ca64b3f1546fp0,
    0x1.1475cc9eedfp3
  },
  { // Entry 914
    -0x1.749f96097c7016b86e95ca64b3f1546fp0,
    -0x1.1475cc9eedfp3
  },
  { // Entry 915
    0x1.749f96097c701869a5f7b1e60216a952p0,
    0x1.1475cc9eedf01p3
  },
  { // Entry 916
    -0x1.749f96097c701869a5f7b1e60216a952p0,
    -0x1.1475cc9eedf01p3
  },
  { // Entry 917
    0x1.77100abbdfe4f88c42b76a1a44ccb487p0,
    0x1.2d97c7f3321d1p3
  },
  { // Entry 918
    -0x1.77100abbdfe4f88c42b76a1a44ccb487p0,
    -0x1.2d97c7f3321d1p3
  },
  { // Entry 919
    0x1.77100abbdfe4f9f90d90533c02b3964ep0,
    0x1.2d97c7f3321d2p3
  },
  { // Entry 920
    -0x1.77100abbdfe4f9f90d90533c02b3964ep0,
    -0x1.2d97c7f3321d2p3
  },
  { // Entry 921
    0x1.77100abbdfe4fb65d8693c5dc07431bdp0,
    0x1.2d97c7f3321d3p3
  },
  { // Entry 922
    -0x1.77100abbdfe4fb65d8693c5dc07431bdp0,
    -0x1.2d97c7f3321d3p3
  },
  { // Entry 923
    0x1.79216b94b662deb07e2d6de7f1804507p0,
    0x1.46b9c347764a2p3
  },
  { // Entry 924
    -0x1.79216b94b662deb07e2d6de7f1804507p0,
    -0x1.46b9c347764a2p3
  },
  { // Entry 925
    0x1.79216b94b662dfe7d5a91b73c06086ebp0,
    0x1.46b9c347764a3p3
  },
  { // Entry 926
    -0x1.79216b94b662dfe7d5a91b73c06086ebp0,
    -0x1.46b9c347764a3p3
  },
  { // Entry 927
    0x1.79216b94b662e11f2d24c8ff8f2294b3p0,
    0x1.46b9c347764a4p3
  },
  { // Entry 928
    -0x1.79216b94b662e11f2d24c8ff8f2294b3p0,
    -0x1.46b9c347764a4p3
  },
  { // Entry 929
    0x1.7ae7d7e5d1f9ee2a0e89a2289062ad74p0,
    0x1.5fdbbe9bba774p3
  },
  { // Entry 930
    -0x1.7ae7d7e5d1f9ee2a0e89a2289062ad74p0,
    -0x1.5fdbbe9bba774p3
  },
  { // Entry 931
    0x1.7ae7d7e5d1f9ef36dc870ed6964fa9dfp0,
    0x1.5fdbbe9bba775p3
  },
  { // Entry 932
    -0x1.7ae7d7e5d1f9ef36dc870ed6964fa9dfp0,
    -0x1.5fdbbe9bba775p3
  },
  { // Entry 933
    0x1.7ae7d7e5d1f9f043aa847b849c24674ap0,
    0x1.5fdbbe9bba776p3
  },
  { // Entry 934
    -0x1.7ae7d7e5d1f9f043aa847b849c24674ap0,
    -0x1.5fdbbe9bba776p3
  },
  { // Entry 935
    0x1.7c722476319a280dab0b4cf4c187f8abp0,
    0x1.78fdb9effea45p3
  },
  { // Entry 936
    -0x1.7c722476319a280dab0b4cf4c187f8abp0,
    -0x1.78fdb9effea45p3
  },
  { // Entry 937
    0x1.7c722476319a28f8131f5d500f0f03e6p0,
    0x1.78fdb9effea46p3
  },
  { // Entry 938
    -0x1.7c722476319a28f8131f5d500f0f03e6p0,
    -0x1.78fdb9effea46p3
  },
  { // Entry 939
    0x1.7c722476319a29e27b336dab5c824dedp0,
    0x1.78fdb9effea47p3
  },
  { // Entry 940
    -0x1.7c722476319a29e27b336dab5c824dedp0,
    -0x1.78fdb9effea47p3
  },
  { // Entry 941
    0x1.7efc711c97aca34b1628231d4f4fabe2p0,
    0x1.ab41b09886fe8p3
  },
  { // Entry 942
    -0x1.7efc711c97aca34b1628231d4f4fabe2p0,
    -0x1.ab41b09886fe8p3
  },
  { // Entry 943
    0x1.7efc711c97aca401df609cab03bab68cp0,
    0x1.ab41b09886fe9p3
  },
  { // Entry 944
    -0x1.7efc711c97aca401df609cab03bab68cp0,
    -0x1.ab41b09886fe9p3
  },
  { // Entry 945
    0x1.7efc711c97aca4b8a8991638b818241cp0,
    0x1.ab41b09886feap3
  },
  { // Entry 946
    -0x1.7efc711c97aca4b8a8991638b818241cp0,
    -0x1.ab41b09886feap3
  },
  { // Entry 947
    0x1.800bb15ffe80dd150b83506ecafcd897p0,
    0x1.c463abeccb2bap3
  },
  { // Entry 948
    -0x1.800bb15ffe80dd150b83506ecafcd897p0,
    -0x1.c463abeccb2bap3
  },
  { // Entry 949
    0x1.800bb15ffe80ddb82f1388a941a8215cp0,
    0x1.c463abeccb2bbp3
  },
  { // Entry 950
    -0x1.800bb15ffe80ddb82f1388a941a8215cp0,
    -0x1.c463abeccb2bbp3
  },
  { // Entry 951
    0x1.800bb15ffe80de5b52a3c0e3b847eeaap0,
    0x1.c463abeccb2bcp3
  },
  { // Entry 952
    -0x1.800bb15ffe80de5b52a3c0e3b847eeaap0,
    -0x1.c463abeccb2bcp3
  },
  { // Entry 953
    0x1.80fe86b132e8f8618de08cf337993ca3p0,
    0x1.dd85a7410f58bp3
  },
  { // Entry 954
    -0x1.80fe86b132e8f8618de08cf337993ca3p0,
    -0x1.dd85a7410f58bp3
  },
  { // Entry 955
    0x1.80fe86b132e8f8f40c19d09e489d38e1p0,
    0x1.dd85a7410f58cp3
  },
  { // Entry 956
    -0x1.80fe86b132e8f8f40c19d09e489d38e1p0,
    -0x1.dd85a7410f58cp3
  },
  { // Entry 957
    0x1.80fe86b132e8f9868a53144959976f3cp0,
    0x1.dd85a7410f58dp3
  },
  { // Entry 958
    -0x1.80fe86b132e8f9868a53144959976f3cp0,
    -0x1.dd85a7410f58dp3
  },
  { // Entry 959
    0x1.81d92def25f25718c6829a063fb81fd7p0,
    0x1.f6a7a2955385dp3
  },
  { // Entry 960
    -0x1.81d92def25f25718c6829a063fb81fd7p0,
    -0x1.f6a7a2955385dp3
  },
  { // Entry 961
    0x1.81d92def25f2579d0b06bd55e5dd10d1p0,
    0x1.f6a7a2955385ep3
  },
  { // Entry 962
    -0x1.81d92def25f2579d0b06bd55e5dd10d1p0,
    -0x1.f6a7a2955385ep3
  },
  { // Entry 963
    0x1.81d92def25f258214f8ae0a58bf99edep0,
    0x1.f6a7a2955385fp3
  },
  { // Entry 964
    -0x1.81d92def25f258214f8ae0a58bf99edep0,
    -0x1.f6a7a2955385fp3
  },
  { // Entry 965
    0x1.829f16bb7d95108c0eb21238a0c53f5ep0,
    0x1.07e4cef4cbd96p4
  },
  { // Entry 966
    -0x1.829f16bb7d95108c0eb21238a0c53f5ep0,
    -0x1.07e4cef4cbd96p4
  },
  { // Entry 967
    0x1.829f16bb7d95117c16ba648f3486d718p0,
    0x1.07e4cef4cbd97p4
  },
  { // Entry 968
    -0x1.829f16bb7d95117c16ba648f3486d718p0,
    -0x1.07e4cef4cbd97p4
  },
  { // Entry 969
    0x1.829f16bb7d95126c1ec2b6e5c82b6edep0,
    0x1.07e4cef4cbd98p4
  },
  { // Entry 970
    -0x1.829f16bb7d95126c1ec2b6e5c82b6edep0,
    -0x1.07e4cef4cbd98p4
  },
  { // Entry 971
    0x1.835311c4fa5d7c37c557b7a5a3338324p0,
    0x1.1475cc9eedeffp4
  },
  { // Entry 972
    -0x1.835311c4fa5d7c37c557b7a5a3338324p0,
    -0x1.1475cc9eedeffp4
  },
  { // Entry 973
    0x1.835311c4fa5d7d128c5fa09cc922483dp0,
    0x1.1475cc9eedfp4
  },
  { // Entry 974
    -0x1.835311c4fa5d7d128c5fa09cc922483dp0,
    -0x1.1475cc9eedfp4
  },
  { // Entry 975
    0x1.835311c4fa5d7ded53678993eef7d037p0,
    0x1.1475cc9eedf01p4
  },
  { // Entry 976
    -0x1.835311c4fa5d7ded53678993eef7d037p0,
    -0x1.1475cc9eedf01p4
  },
  { // Entry 977
    0x1.83f7731825dc9d8ff5737093bb3540dep0,
    0x1.2106ca4910068p4
  },
  { // Entry 978
    -0x1.83f7731825dc9d8ff5737093bb3540dep0,
    -0x1.2106ca4910068p4
  },
  { // Entry 979
    0x1.83f7731825dc9e582ebc020978ee1a95p0,
    0x1.2106ca4910069p4
  },
  { // Entry 980
    -0x1.83f7731825dc9e582ebc020978ee1a95p0,
    -0x1.2106ca4910069p4
  },
  { // Entry 981
    0x1.83f7731825dc9f206804937f3690da9bp0,
    0x1.2106ca491006ap4
  },
  { // Entry 982
    -0x1.83f7731825dc9f206804937f3690da9bp0,
    -0x1.2106ca491006ap4
  },
  { // Entry 983
    0x1.848e2bec799ece48230ea9b4de60cfb7p0,
    0x1.2d97c7f3321d1p4
  },
  { // Entry 984
    -0x1.848e2bec799ece48230ea9b4de60cfb7p0,
    -0x1.2d97c7f3321d1p4
  },
  { // Entry 985
    0x1.848e2bec799ecf0011a08e93bfcbf6bap0,
    0x1.2d97c7f3321d2p4
  },
  { // Entry 986
    -0x1.848e2bec799ecf0011a08e93bfcbf6bap0,
    -0x1.2d97c7f3321d2p4
  },
  { // Entry 987
    0x1.848e2bec799ecfb800327372a123a7b7p0,
    0x1.2d97c7f3321d3p4
  },
  { // Entry 988
    -0x1.848e2bec799ecfb800327372a123a7b7p0,
    -0x1.2d97c7f3321d3p4
  },
  { // Entry 989
    0x1.8518de4b48e76e411ea1cdeeb59cbf77p0,
    0x1.3a28c59d54339p4
  },
  { // Entry 990
    -0x1.8518de4b48e76e411ea1cdeeb59cbf77p0,
    -0x1.3a28c59d54339p4
  },
  { // Entry 991
    0x1.8518de4b48e76eeaab2a58ab739c30cbp0,
    0x1.3a28c59d5433ap4
  },
  { // Entry 992
    -0x1.8518de4b48e76eeaab2a58ab739c30cbp0,
    -0x1.3a28c59d5433ap4
  },
  { // Entry 993
    0x1.8518de4b48e76f9437b2e368318a6869p0,
    0x1.3a28c59d5433bp4
  },
  { // Entry 994
    -0x1.8518de4b48e76f9437b2e368318a6869p0,
    -0x1.3a28c59d5433bp4
  },
  { // Entry 995
    0x1.8598ec35167127ce203d29cce66b685bp0,
    0x1.46b9c347764a2p4
  },
  { // Entry 996
    -0x1.8598ec35167127ce203d29cce66b685bp0,
    -0x1.46b9c347764a2p4
  },
  { // Entry 997
    0x1.8598ec351671286aea010a7cf15304a4p0,
    0x1.46b9c347764a3p4
  },
  { // Entry 998
    -0x1.8598ec351671286aea010a7cf15304a4p0,
    -0x1.46b9c347764a3p4
  },
  { // Entry 999
    0x1.8598ec3516712907b3c4eb2cfc2b4f2dp0,
    0x1.46b9c347764a4p4
  },
  { // Entry 1000
    -0x1.8598ec3516712907b3c4eb2cfc2b4f2dp0,
    -0x1.46b9c347764a4p4
  },
  { // Entry 1001
    0x1.860f836e59cf533a5f5acd977fb3bd1bp0,
    0x1.534ac0f19860bp4
  },
  { // Entry 1002
    -0x1.860f836e59cf533a5f5acd977fb3bd1bp0,
    -0x1.534ac0f19860bp4
  },
  { // Entry 1003
    0x1.860f836e59cf53cbc97c4e327874fe3fp0,
    0x1.534ac0f19860cp4
  },
  { // Entry 1004
    -0x1.860f836e59cf53cbc97c4e327874fe3fp0,
    -0x1.534ac0f19860cp4
  },
  { // Entry 1005
    0x1.860f836e59cf545d339dcecd7128903ap0,
    0x1.534ac0f19860dp4
  },
  { // Entry 1006
    -0x1.860f836e59cf545d339dcecd7128903ap0,
    -0x1.534ac0f19860dp4
  },
  { // Entry 1007
    0x1.867da6c87b57e8adf8990014ae6c012fp0,
    0x1.5fdbbe9bba774p4
  },
  { // Entry 1008
    -0x1.867da6c87b57e8adf8990014ae6c012fp0,
    -0x1.5fdbbe9bba774p4
  },
  { // Entry 1009
    0x1.867da6c87b57e935349724e0cc37b311p0,
    0x1.5fdbbe9bba775p4
  },
  { // Entry 1010
    -0x1.867da6c87b57e935349724e0cc37b311p0,
    -0x1.5fdbbe9bba775p4
  },
  { // Entry 1011
    0x1.867da6c87b57e9bc709549ace9f71ee9p0,
    0x1.5fdbbe9bba776p4
  },
  { // Entry 1012
    -0x1.867da6c87b57e9bc709549ace9f71ee9p0,
    -0x1.5fdbbe9bba776p4
  },
  { // Entry 1013
    0x1.86e435818151b84fe25834c19a7e2e5fp0,
    0x1.6c6cbc45dc8dcp4
  },
  { // Entry 1014
    -0x1.86e435818151b84fe25834c19a7e2e5fp0,
    -0x1.6c6cbc45dc8dcp4
  },
  { // Entry 1015
    0x1.86e435818151b8cdf86e6345f58c69fap0,
    0x1.6c6cbc45dc8ddp4
  },
  { // Entry 1016
    -0x1.86e435818151b8cdf86e6345f58c69fap0,
    -0x1.6c6cbc45dc8ddp4
  },
  { // Entry 1017
    0x1.86e435818151b94c0e8491ca508f98b5p0,
    0x1.6c6cbc45dc8dep4
  },
  { // Entry 1018
    -0x1.86e435818151b94c0e8491ca508f98b5p0,
    -0x1.6c6cbc45dc8dep4
  },
  { // Entry 1019
    0x1.8743f12bf9fc92a7f65de8d6cd3df59dp0,
    0x1.78fdb9effea45p4
  },
  { // Entry 1020
    -0x1.8743f12bf9fc92a7f65de8d6cd3df59dp0,
    -0x1.78fdb9effea45p4
  },
  { // Entry 1021
    0x1.8743f12bf9fc931dcc400e45f1cbfd18p0,
    0x1.78fdb9effea46p4
  },
  { // Entry 1022
    -0x1.8743f12bf9fc931dcc400e45f1cbfd18p0,
    -0x1.78fdb9effea46p4
  },
  { // Entry 1023
    0x1.8743f12bf9fc9393a22233b51650089fp0,
    0x1.78fdb9effea47p4
  },
  { // Entry 1024
    -0x1.8743f12bf9fc9393a22233b51650089fp0,
    -0x1.78fdb9effea47p4
  },
  { // Entry 1025
    0x1.879d82738cdb0715c7e50907e7a87c80p0,
    0x1.858eb79a20baep4
  },
  { // Entry 1026
    -0x1.879d82738cdb0715c7e50907e7a87c80p0,
    -0x1.858eb79a20baep4
  },
  { // Entry 1027
    0x1.879d82738cdb07842634f187eb77dddcp0,
    0x1.858eb79a20bafp4
  },
  { // Entry 1028
    -0x1.879d82738cdb07842634f187eb77dddcp0,
    -0x1.858eb79a20bafp4
  },
  { // Entry 1029
    0x1.879d82738cdb07f28484da07ef3e3230p0,
    0x1.858eb79a20bb0p4
  },
  { // Entry 1030
    -0x1.879d82738cdb07f28484da07ef3e3230p0,
    -0x1.858eb79a20bb0p4
  },
  { // Entry 1031
    0x1.921fb54442d18467898cc51701b829a2p0,
    0x1.fffffffffffffp62
  },
  { // Entry 1032
    -0x1.921fb54442d18467898cc51701b829a2p0,
    -0x1.fffffffffffffp62
  },
  { // Entry 1033
    0x1.921fb54442d18467898cc51701b839a2p0,
    0x1.0p63
  },
  { // Entry 1034
    -0x1.921fb54442d18467898cc51701b839a2p0,
    -0x1.0p63
  },
  { // Entry 1035
    0x1.921fb54442d18467898cc51701b859a2p0,
    0x1.0000000000001p63
  },
  { // Entry 1036
    -0x1.921fb54442d18467898cc51701b859a2p0,
    -0x1.0000000000001p63
  },
  { // Entry 1037
    0x1.921fb52442d18469898befc1ac62e44cp0,
    0x1.fffffffffffffp26
  },
  { // Entry 1038
    -0x1.921fb52442d18469898befc1ac62e44cp0,
    -0x1.fffffffffffffp26
  },
  { // Entry 1039
    0x1.921fb52442d18469898cefc1ac62e44cp0,
    0x1.0p27
  },
  { // Entry 1040
    -0x1.921fb52442d18469898cefc1ac62e44cp0,
    -0x1.0p27
  },
  { // Entry 1041
    0x1.921fb52442d18469898eefc1ac62e44cp0,
    0x1.0000000000001p27
  },
  { // Entry 1042
    -0x1.921fb52442d18469898eefc1ac62e44cp0,
    -0x1.0000000000001p27
  },
  { // Entry 1043
    0x1.921fb44442d1846989da1a6c570d8eccp0,
    0x1.fffffffffffffp23
  },
  { // Entry 1044
    -0x1.921fb44442d1846989da1a6c570d8eccp0,
    -0x1.fffffffffffffp23
  },
  { // Entry 1045
    0x1.921fb44442d1846989e21a6c570d8ec4p0,
    0x1.0p24
  },
  { // Entry 1046
    -0x1.921fb44442d1846989e21a6c570d8ec4p0,
    -0x1.0p24
  },
  { // Entry 1047
    0x1.921fb44442d1846989f21a6c570d8eb3p0,
    0x1.0000000000001p24
  },
  { // Entry 1048
    -0x1.921fb44442d1846989f21a6c570d8eb3p0,
    -0x1.0000000000001p24
  },
  { // Entry 1049
    0x1.5368c951e9cfc7c24c38fb77a1dfa57cp0,
    0x1.fffffffffffffp1
  },
  { // Entry 1050
    -0x1.5368c951e9cfc7c24c38fb77a1dfa57cp0,
    -0x1.fffffffffffffp1
  },
  { // Entry 1051
    0x1.5368c951e9cfc9a42e1add5983cfb3a8p0,
    0x1.0p2
  },
  { // Entry 1052
    -0x1.5368c951e9cfc9a42e1add5983cfb3a8p0,
    -0x1.0p2
  },
  { // Entry 1053
    0x1.5368c951e9cfcd67f1dea11d475ac643p0,
    0x1.0000000000001p2
  },
  { // Entry 1054
    -0x1.5368c951e9cfcd67f1dea11d475ac643p0,
    -0x1.0000000000001p2
  },
  { // Entry 1055
    0x1.1b6e192ebbe443939e676eed7053450cp0,
    0x1.fffffffffffffp0
  },
  { // Entry 1056
    -0x1.1b6e192ebbe443939e676eed7053450cp0,
    -0x1.fffffffffffffp0
  },
  { // Entry 1057
    0x1.1b6e192ebbe446c6d19aa220a39af320p0,
    0x1.0p1
  },
  { // Entry 1058
    -0x1.1b6e192ebbe446c6d19aa220a39af320p0,
    -0x1.0p1
  },
  { // Entry 1059
    0x1.1b6e192ebbe44d2d3801088709af6e01p0,
    0x1.0000000000001p1
  },
  { // Entry 1060
    -0x1.1b6e192ebbe44d2d3801088709af6e01p0,
    -0x1.0000000000001p1
  },
  { // Entry 1061
    0x1.921fb54442d17c69898cc517019839a2p-1,
    0x1.fffffffffffffp-1
  },
  { // Entry 1062
    -0x1.921fb54442d17c69898cc517019839a2p-1,
    -0x1.fffffffffffffp-1
  },
  { // Entry 1063
    0x1.921fb54442d18469898cc51701b839a2p-1,
    0x1.0p0
  },
  { // Entry 1064
    -0x1.921fb54442d18469898cc51701b839a2p-1,
    -0x1.0p0
  },
  { // Entry 1065
    0x1.921fb54442d19469898cc517013839a2p-1,
    0x1.0000000000001p0
  },
  { // Entry 1066
    -0x1.921fb54442d19469898cc517013839a2p-1,
    -0x1.0000000000001p0
  },
  { // Entry 1067
    0x1.dac670561bb4e9be12fbbf0cab93d258p-2,
    0x1.fffffffffffffp-2
  },
  { // Entry 1068
    -0x1.dac670561bb4e9be12fbbf0cab93d258p-2,
    -0x1.fffffffffffffp-2
  },
  { // Entry 1069
    0x1.dac670561bb4f68adfc88bd978751a06p-2,
    0x1.0p-1
  },
  { // Entry 1070
    -0x1.dac670561bb4f68adfc88bd978751a06p-2,
    -0x1.0p-1
  },
  { // Entry 1071
    0x1.dac670561bb510247962257311bcc81bp-2,
    0x1.0000000000001p-1
  },
  { // Entry 1072
    -0x1.dac670561bb510247962257311bcc81bp-2,
    -0x1.0000000000001p-1
  },
  { // Entry 1073
    0x1.f5b75f92c80dc71bcc802edce02e0a97p-3,
    0x1.fffffffffffffp-3
  },
  { // Entry 1074
    -0x1.f5b75f92c80dc71bcc802edce02e0a97p-3,
    -0x1.fffffffffffffp-3
  },
  { // Entry 1075
    0x1.f5b75f92c80dd62adb8f3debef442fcbp-3,
    0x1.0p-2
  },
  { // Entry 1076
    -0x1.f5b75f92c80dd62adb8f3debef442fcbp-3,
    -0x1.0p-2
  },
  { // Entry 1077
    0x1.f5b75f92c80df448f9ad5c0a0d45f554p-3,
    0x1.0000000000001p-2
  },
  { // Entry 1078
    -0x1.f5b75f92c80df448f9ad5c0a0d45f554p-3,
    -0x1.0000000000001p-2
  },
  { // Entry 1079
    0x1.fd5ba9aac2f6cca4951f70426d4e3181p-4,
    0x1.fffffffffffffp-4
  },
  { // Entry 1080
    -0x1.fd5ba9aac2f6cca4951f70426d4e3181p-4,
    -0x1.fffffffffffffp-4
  },
  { // Entry 1081
    0x1.fd5ba9aac2f6dc65912f313e7d111defp-4,
    0x1.0p-3
  },
  { // Entry 1082
    -0x1.fd5ba9aac2f6dc65912f313e7d111defp-4,
    -0x1.0p-3
  },
  { // Entry 1083
    0x1.fd5ba9aac2f6fbe7894eb3369c8b5496p-4,
    0x1.0000000000001p-3
  },
  { // Entry 1084
    -0x1.fd5ba9aac2f6fbe7894eb3369c8b5496p-4,
    -0x1.0000000000001p-3
  },
  { // Entry 1085
    0x1.ff55bb72cfde8c7d865f15c80c6b8bb0p-5,
    0x1.fffffffffffffp-5
  },
  { // Entry 1086
    -0x1.ff55bb72cfde8c7d865f15c80c6b8bb0p-5,
    -0x1.fffffffffffffp-5
  },
  { // Entry 1087
    0x1.ff55bb72cfde9c6d964f25b81c5c1aa2p-5,
    0x1.0p-4
  },
  { // Entry 1088
    -0x1.ff55bb72cfde9c6d964f25b81c5c1aa2p-5,
    -0x1.0p-4
  },
  { // Entry 1089
    0x1.ff55bb72cfdebc4db62f45983c3a3e7cp-5,
    0x1.0000000000001p-4
  },
  { // Entry 1090
    -0x1.ff55bb72cfdebc4db62f45983c3a3e7cp-5,
    -0x1.0000000000001p-4
  },
  { // Entry 1091
    0x1.ffd55bba97623a88ee3b2ecbb917a476p-6,
    0x1.fffffffffffffp-6
  },
  { // Entry 1092
    -0x1.ffd55bba97623a88ee3b2ecbb917a476p-6,
    -0x1.fffffffffffffp-6
  },
  { // Entry 1093
    0x1.ffd55bba97624a84ef3aeedbb518c427p-6,
    0x1.0p-5
  },
  { // Entry 1094
    -0x1.ffd55bba97624a84ef3aeedbb518c427p-6,
    -0x1.0p-5
  },
  { // Entry 1095
    0x1.ffd55bba97626a7cf13a6efbad1a43e7p-6,
    0x1.0000000000001p-5
  },
  { // Entry 1096
    -0x1.ffd55bba97626a7cf13a6efbad1a43e7p-6,
    -0x1.0000000000001p-5
  },
  { // Entry 1097
    0x1.fff555bbb7299b78cf08ad801befb881p-7,
    0x1.fffffffffffffp-7
  },
  { // Entry 1098
    -0x1.fff555bbb7299b78cf08ad801befb881p-7,
    -0x1.fffffffffffffp-7
  },
  { // Entry 1099
    0x1.fff555bbb729ab77cf18ac802beec090p-7,
    0x1.0p-6
  },
  { // Entry 1100
    -0x1.fff555bbb729ab77cf18ac802beec090p-7,
    -0x1.0p-6
  },
  { // Entry 1101
    0x1.fff555bbb729cb75cf38aa804beca0b4p-7,
    0x1.0000000000001p-6
  },
  { // Entry 1102
    -0x1.fff555bbb729cb75cf38aa804beca0b4p-7,
    -0x1.0000000000001p-6
  },
  { // Entry 1103
    0x1.fffffff5555545bbbbbcb72972876256p-15,
    0x1.fffffffffffffp-15
  },
  { // Entry 1104
    -0x1.fffffff5555545bbbbbcb72972876256p-15,
    -0x1.fffffffffffffp-15
  },
  { // Entry 1105
    0x1.fffffff5555555bbbbbbb72972976256p-15,
    0x1.0p-14
  },
  { // Entry 1106
    -0x1.fffffff5555555bbbbbbb72972976256p-15,
    -0x1.0p-14
  },
  { // Entry 1107
    0x1.fffffff5555575bbbbb9b72972b76256p-15,
    0x1.0000000000001p-14
  },
  { // Entry 1108
    -0x1.fffffff5555575bbbbb9b72972b76256p-15,
    -0x1.0000000000001p-14
  },
  { // Entry 1109
    0x1.ffffffffffffed5555555555559bbbbbp-28,
    0x1.fffffffffffffp-28
  },
  { // Entry 1110
    -0x1.ffffffffffffed5555555555559bbbbbp-28,
    -0x1.fffffffffffffp-28
  },
  { // Entry 1111
    0x1.fffffffffffffd5555555555555bbbbbp-28,
    0x1.0p-27
  },
  { // Entry 1112
    -0x1.fffffffffffffd5555555555555bbbbbp-28,
    -0x1.0p-27
  },
  { // Entry 1113
    0x1.0000000000000eaaaaaaaaaaaa6dddddp-27,
    0x1.0000000000001p-27
  },
  { // Entry 1114
    -0x1.0000000000000eaaaaaaaaaaaa6dddddp-27,
    -0x1.0000000000001p-27
  },
  { // Entry 1115
    0x1.ffffffffffffeff555555555555655bbp-31,
    0x1.fffffffffffffp-31
  },
  { // Entry 1116
    -0x1.ffffffffffffeff555555555555655bbp-31,
    -0x1.fffffffffffffp-31
  },
  { // Entry 1117
    0x1.fffffffffffffff555555555555555bbp-31,
    0x1.0p-30
  },
  { // Entry 1118
    -0x1.fffffffffffffff555555555555555bbp-31,
    -0x1.0p-30
  },
  { // Entry 1119
    0x1.0000000000000ffaaaaaaaaaaaa9aaddp-30,
    0x1.0000000000001p-30
  },
  { // Entry 1120
    -0x1.0000000000000ffaaaaaaaaaaaa9aaddp-30,
    -0x1.0000000000001p-30
  },
  { // Entry 1121
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 1122
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.fffffffffffffp1023
  },
  { // Entry 1123
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.fffffffffffffp1023
  },
  { // Entry 1124
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 1125
    0x1.921fb54442d18469898cc51701b839a2p0,
    HUGE_VAL
  },
  { // Entry 1126
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -HUGE_VAL
  },
  { // Entry 1127
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.fffffffffffffp1023
  },
  { // Entry 1128
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.fffffffffffffp1023
  },
  { // Entry 1129
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.ffffffffffffep1023
  },
  { // Entry 1130
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.ffffffffffffep1023
  },
  { // Entry 1131
    0x1.433b8a322ddd29618168a21c962c68bcp0,
    0x1.921fb54442d18p1
  },
  { // Entry 1132
    -0x1.433b8a322ddd29618168a21c962c68bcp0,
    -0x1.921fb54442d18p1
  },
  { // Entry 1133
    0x1.00fe987ed02ff23377d99ec36db533fep0,
    0x1.921fb54442d18p0
  },
  { // Entry 1134
    -0x1.00fe987ed02ff23377d99ec36db533fep0,
    -0x1.921fb54442d18p0
  },
  { // Entry 1135
    0x1.921fb54442d19469898cc517013839a2p-1,
    0x1.0000000000001p0
  },
  { // Entry 1136
    -0x1.921fb54442d19469898cc517013839a2p-1,
    -0x1.0000000000001p0
  },
  { // Entry 1137
    0x1.921fb54442d18469898cc51701b839a2p-1,
    0x1.0p0
  },
  { // Entry 1138
    -0x1.921fb54442d18469898cc51701b839a2p-1,
    -0x1.0p0
  },
  { // Entry 1139
    0x1.921fb54442d17c69898cc517019839a2p-1,
    0x1.fffffffffffffp-1
  },
  { // Entry 1140
    -0x1.921fb54442d17c69898cc517019839a2p-1,
    -0x1.fffffffffffffp-1
  },
  { // Entry 1141
    0x1.54e04c05d06a04041ccf30f00110c0f6p-1,
    0x1.921fb54442d18p-1
  },
  { // Entry 1142
    -0x1.54e04c05d06a04041ccf30f00110c0f6p-1,
    -0x1.921fb54442d18p-1
  },
  { // Entry 1143
    0x1.0000000000000fffffffffffffffffffp-1022,
    0x1.0000000000001p-1022
  },
  { // Entry 1144
    -0x1.0000000000000fffffffffffffffffffp-1022,
    -0x1.0000000000001p-1022
  },
  { // Entry 1145
    0x1.ffffffffffffffffffffffffffffffffp-1023,
    0x1.0p-1022
  },
  { // Entry 1146
    -0x1.ffffffffffffffffffffffffffffffffp-1023,
    -0x1.0p-1022
  },
  { // Entry 1147
    0x1.ffffffffffffdfffffffffffffffffffp-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 1148
    -0x1.ffffffffffffdfffffffffffffffffffp-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 1149
    0x1.ffffffffffffbfffffffffffffffffffp-1023,
    0x1.ffffffffffffcp-1023
  },
  { // Entry 1150
    -0x1.ffffffffffffbfffffffffffffffffffp-1023,
    -0x1.ffffffffffffcp-1023
  },
  { // Entry 1151
    0x1.ffffffffffffffffffffffffffffffffp-1074,
    0x1.0p-1073
  },
  { // Entry 1152
    -0x1.ffffffffffffffffffffffffffffffffp-1074,
    -0x1.0p-1073
  },
  { // Entry 1153
    0.0,
    0x1.0p-1074
  },
  { // Entry 1154
    -0.0,
    -0x1.0p-1074
  },
  { // Entry 1155
    0.0,
    0.0
  },
  { // Entry 1156
    -0.0,
    -0.0
  }
};
