/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"

DWORD ReadDWord(HKEY key, LPCTSTR subKey, DWORD defaultValue)
{
	DWORD bytes = sizeof(DWORD);
	DWORD work;
	DWORD type;

	if (key == NULL) {
		return defaultValue;
	}
	if (RegQueryValueEx(key, subKey, 0, &type, (LPBYTE)&work, &bytes) == ERROR_SUCCESS) {
		if (type == REG_DWORD) {
			return work;
		}
	}
	return defaultValue;
}

BOOL WriteDWord(HKEY key, LPCTSTR subKey, DWORD value)
{
	return (RegSetValueEx(key, subKey, 0, REG_DWORD, (LPBYTE)&value, sizeof(DWORD)) == ERROR_SUCCESS);
}

BOOL ReadBool(HKEY key, LPCTSTR subKey, BOOL defaultValue)
{
	return (ReadDWord(key, subKey, defaultValue) ? 1 : 0);
}

BOOL WriteBool(HKEY key, LPCTSTR subKey, BOOL value)
{
	return WriteDWord(key, subKey, (value ? 1 : 0));
}
