/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"

HMODULE GetDLLModuleHandle();

void debug_print(const TCHAR *format, ...)
{
	TCHAR filename[MAX_PATH];
	TCHAR logname[MAX_PATH];
	SYSTEMTIME st;
	GetLocalTime(&st);

	if (GetModuleFileName(GetDLLModuleHandle(), filename, _countof(filename)) == 0) {
		// Oo͎siW[擾łj
		return;
	}

	HRESULT hr = StringCchPrintf(logname, _countof(logname), _T("%s_%04d%02d%02d.log"), filename, (int)st.wYear, (int)st.wMonth, (int)st.wDay);
	if (FAILED(hr)) {
		// Oo͎sipXj
		return;
	}

	HANDLE hMutex = CreateMutex(NULL, FALSE, _T("AlterDnD Log Section"));
	WaitForSingleObject(hMutex , INFINITE);

	FILE *fp;
	_tfopen_s(&fp, logname, _T("a"));
	if (fp != NULL) {
		va_list argptr;
		HMODULE hMod;
		TCHAR exename[MAX_PATH] = _T("");

		hMod = GetModuleHandle(NULL);
		GetModuleFileName(hMod, exename, _countof(exename));

		va_start(argptr, format);
		_ftprintf(fp, _T("%04d/%02d/%02d %02d:%02d:%02d.%03d\t%s[%08x]\t"),
			(int)st.wYear, (int)st.wMonth, (int)st.wDay,
			(int)st.wHour, (int)st.wMinute, (int)st.wSecond, (int)st.wMilliseconds,
			exename, (unsigned)hMod);
		_vftprintf(fp, format, argptr);
		_fputtc(_T('\n'), fp);
		va_end(argptr);

		fclose(fp);
	}
	ReleaseMutex(hMutex);
	CloseHandle(hMutex);
}
