/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"
#include "AlterDnD_DLL.h"
#include "DropTargetWrapper.h"

void LockThisDLL();
void UnlockThisDLL();

DropTargetWrapper::DropTargetWrapper(HWND hwnd, IDropTarget *pTarget, WORD thisTargetType)
{
	LockThisDLL();
	CoCreateInstance(CLSID_DragDropHelper, NULL, CLSCTX_INPROC_SERVER, IID_IDropTargetHelper, (LPVOID*)&m_pdth);

	m_hWnd = hwnd;
	m_cRef = 0;
	m_pTarget = pTarget;
	m_thisTargetType = thisTargetType;
	ULONG count = m_pTarget->AddRef();
	DP(_T("DropTargetWrapper:DropTargetWrapper  m_pTarget->AddRef() hwnd=%x count=%d"), m_hWnd, (int)count);
}

DropTargetWrapper::~DropTargetWrapper()
{
	ULONG ret = m_pTarget->Release();
	DP(_T("DropTargetWrapper:~DropTargetWrapper  m_pTarget->Release() hwnd=%x count=%d"), m_hWnd, (int)ret);
	m_pTarget = NULL;

	m_pdth->Release();
	UnlockThisDLL();
}

IDropTarget* DropTargetWrapper::GetOriginalTarget()
{
	ULONG count = m_pTarget->AddRef();
	DP(_T("DropTargetWrapper::GetOriginalTarget hwnd=%x count=%d"), m_hWnd, count);
	return m_pTarget;
}

STDMETHODIMP DropTargetWrapper::QueryInterface(REFIID riid, void **ppvObject)
{
	DP(_T("DropTargetWrapper::QueryInterface hwnd=%x"), m_hWnd);

	*ppvObject = NULL;

	if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IDropTarget) || IsEqualIID(riid, IID_DropTargetWrapper))
		*ppvObject = static_cast<IDropTarget *>(this);
	else
		return E_NOINTERFACE;

	AddRef();

	return S_OK;
}

STDMETHODIMP_(ULONG) DropTargetWrapper::AddRef()
{
	DP(_T("DropTargetWrapper::AddRef hwnd=%x count=%d"), m_hWnd, m_cRef + 1);
	return InterlockedIncrement(&m_cRef);
}

STDMETHODIMP_(ULONG) DropTargetWrapper::Release()
{
	DP(_T("DropTargetWrapper::Release hwnd=%x count=%d"), m_hWnd, m_cRef - 1);
	if (InterlockedDecrement(&m_cRef) == 0) {
		DP(_T("hwnd=%x delete"), m_hWnd);
		delete this;
	}
	return m_cRef;
}

void DropTargetWrapper::EffectFilter(DWORD grfKeyState, LPDWORD pEffect)
{
	switch (m_DnDMode) {
	case DNDMODE_DISABLE:
		*pEffect = DROPEFFECT_NONE;
		break;
	case DNDMODE_ANY_KEYDOWN:
		if ((grfKeyState & (MK_SHIFT | MK_CONTROL | MK_ALT)) == 0) {
			*pEffect = DROPEFFECT_NONE;
		}
		break;
	default:	// DNDMODE_NORMAL,DNDMODE_RBUTTON_SIMULATE
		break;
	}
}

BOOL DropTargetWrapper::IsTarget(WORD mode)
{
	return ((mode & m_thisTargetType) != m_thisTargetType);
}

DWORD DropTargetWrapper::KeyStateL2R(DWORD grfKeyState)
{
	return (grfKeyState & ~MK_LBUTTON) | MK_RBUTTON;
}

BOOL DropTargetWrapper::DoUseOwnDropTargetHelper(POINTL pt, DWORD dwEffect)
{
	// Effect̏ODropTargetHelperł邩ADropTargetɔC邩̔

	// hbv֎~ł͂Ȃꍇ́ADropTargetɔC
	if (dwEffect != DROPEFFECT_NONE) {
		return FALSE;
	}

	// fXNgbvȊȌꍇ́AODropTargetHelpergB
	// TODO fXNgbvȊOADropTargetɔCǁA
	//      ztH_nꂽpdwEffect𖳎\̂...
	if (m_thisTargetType != DNDTARGET_DESKTOP) {
		return TRUE;
	}

	// fXNgbv̏ꍇ́AfXNgbvł̃ACR̈ړoȂƎgÂ炢̂ŁA
	// ACRʒuւ̃hbv́ADropTargetɔCB
	TCHAR buff[32] = { _T('\0') };
	GetClassName(m_hWnd, buff, sizeof(buff));
	DP(_T("TargetType=DNDTARGET_DESKTOP  class=%s"), buff);

	HWND hShell = FindWindowEx(m_hWnd, NULL, _T("SHELLDLL_DefView"), NULL);
	if (!hShell) {
		// SHELLDLL_DefViewꍇ̓fXNgbvł͂Ȃ̂ŁAODropTargetHelpergB
		DP(_T("SHELLDLL_DefView not found. hwnd=%x"), m_hWnd);
		return TRUE;
	}
	HWND hList = FindWindowEx(hShell, NULL, _T("SysListView32"), _T("FolderView"));
	if (!hList) {
		// SysListView32ꍇ̓fXNgbvł͂Ȃ̂ŁAODropTargetHelpergB
		DP(_T("SysListView32 not found. hwnd=%x"), m_hWnd);
		return TRUE;
	}

	// ACRɂꍇ́AODropTargetHelpergB
	LVHITTESTINFO ht;
	ht.pt.x = pt.x;
	ht.pt.y = pt.y;
	ClientToScreen(m_hWnd, &ht.pt);
	ScreenToClient(hList, &ht.pt);

	int index = ListView_HitTest(hList, &ht);
	DP(_T("ListView_HitTest index=%d  pt=%d,%d(%d,%d)"), index, ht.pt.x, ht.pt.y, pt.x, pt.y);
	return (index != -1);
}

STDMETHODIMP DropTargetWrapper::DragEnter(IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
	// {^ŊJnĂȂꍇ́Aʏʂ̏sB
	m_pDataObj = NULL;
	if ((grfKeyState & MK_LBUTTON) == 0) {
		return m_pTarget->DragEnter(pDataObj, grfKeyState, pt, pdwEffect);
	}

	// hbOhbvɐݒ肪ύXƂ܂̂ŁAJnɋL
	GetDnDMode(&m_DnDMode, &m_DnDTargets);

	// ̃NXݒ肳ꂽEChEΏۊOɐݒ肳ĂꍇAȂ
	if (IsTarget(m_DnDTargets)) {
		return m_pTarget->DragEnter(pDataObj, grfKeyState, pt, pdwEffect);
	}

	m_pDataObj = pDataObj;
	m_pDataObj->AddRef();

	DP(_T("DropTargetWrapper:DragEnter=%x,%x"), grfKeyState, *pdwEffect);
	if (m_DnDMode == DNDMODE_RBUTTON_SIMULATE) {
		return m_pTarget->DragEnter(pDataObj, KeyStateL2R(grfKeyState), pt, pdwEffect);
	}
	EffectFilter(grfKeyState, pdwEffect);

	// Windows 7 ȍ~ŁAƎDropHandlero^ĂACRŁA
	// DROPEFFECT_NONE <=> DROPEFFECT_NONEȊO ̐؂ւsƁA
	// xACRォOȂƁA\XVȂB
	// ktH_DropHandlerȂǂ́AnpdwEffect𖳎Ă݂B
	// DROPEFFECT_NONE ̏ꍇ́ADropTargetɗ炸AŃACR`悷B

	// AfXNgbv̏ꍇ́AfXNgbvł̃ACR̈ړoȂƎgÂ炢̂ŁA
	// ACRʒuւ̃hbv́ADropTargetɔCB
	useOwnHelper = DoUseOwnDropTargetHelper(pt, *pdwEffect);
	if (useOwnHelper) {
		POINT pt2 = { pt.x, pt.y };
		return m_pdth->DragEnter(m_hWnd, m_pDataObj, &pt2, DROPEFFECT_NONE);
	} else {
		return m_pTarget->DragEnter(pDataObj, grfKeyState, pt, pdwEffect);
	}
}

STDMETHODIMP DropTargetWrapper::DragOver(DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
	// {^ŊJnĂȂꍇÃNXZbgEChEΏۊȌꍇ́A
	// ʏʂ̏sB
	if (m_pDataObj == NULL) {
		return m_pTarget->DragOver(grfKeyState, pt, pdwEffect);
	}

	DP(_T("DropTargetWrapper:DragOver hwnd=%x param=%x,%x"), m_hWnd, grfKeyState, *pdwEffect);
	if (m_DnDMode == DNDMODE_RBUTTON_SIMULATE) {
		return m_pTarget->DragOver(KeyStateL2R(grfKeyState), pt, pdwEffect);
	}
	EffectFilter(grfKeyState, pdwEffect);
	DP(_T("DropTargetWrapper:DragOver2 hwnd=%x param=%x,%x"), m_hWnd, grfKeyState, *pdwEffect);

	BOOL prevUseOwn = useOwnHelper;
	useOwnHelper = DoUseOwnDropTargetHelper(pt, *pdwEffect);
	if (useOwnHelper) {
		DP(_T("useOwnHelper=TRUE"));
		POINT pt2 = { pt.x, pt.y };
		if (!prevUseOwn) {
			DP(_T("m_pTarget->DragLeave()"));
			m_pTarget->DragLeave();
			m_pdth->DragEnter(m_hWnd, m_pDataObj, &pt2, DROPEFFECT_NONE);
		}
		DP(_T("m_pdth->DragOver(&pt2, DROPEFFECT_NONE)"));
		return m_pdth->DragOver(&pt2, DROPEFFECT_NONE);
	} else {
		DP(_T("useOwnHelper=FALSE"));
		if (prevUseOwn) {
			DP(_T("m_pdth->DragLeave()"));
			DWORD effect = *pdwEffect;
			m_pdth->DragLeave();
			m_pTarget->DragEnter(m_pDataObj, grfKeyState, pt, &effect);
		}
		DP(_T("DropTargetWrapper:m_pTarget->DragOver=%x,%x"), grfKeyState, *pdwEffect);
		return m_pTarget->DragOver(grfKeyState, pt, pdwEffect);
	}
}

STDMETHODIMP DropTargetWrapper::DragLeave()
{
	// {^ŊJnĂȂꍇÃNXZbgEChEΏۊȌꍇ́A
	// ʏʂ̏sB
	if (m_pDataObj == NULL) {
		return m_pTarget->DragLeave();
	}
	m_pDataObj->Release();
	m_pDataObj = NULL;

	if (m_DnDMode == DNDMODE_RBUTTON_SIMULATE) {
		return m_pTarget->DragLeave();
	}

	DP(_T("DropTargetWrapper:DragLeave hwnd=%x"), m_hWnd);
	if (useOwnHelper) {
		return m_pdth->DragLeave();
	} else {
		return m_pTarget->DragLeave();
	}
}

STDMETHODIMP DropTargetWrapper::Drop(IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
	DP(_T("DropTargetWrapper:Drop hwnd=%x param=%x,%x"), m_hWnd, grfKeyState, *pdwEffect);
	//DnDFilter(&grfKeyState, pdwEffect);
	//DP(_T("DropTargetWrapper:Drop2=%x,%x"), grfKeyState, *pdwEffect);
	HRESULT hr = m_pTarget->Drop(pDataObj, grfKeyState, pt, pdwEffect);
	//DP(_T("DROPEFFECT=%d"), (int)*pdwEffect);
	return hr;
}
