/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#pragma once

#include "stdafx.h"

// {1D18C667-02E8-4744-866B-4F4CAC4D565E}
static const IID IID_DropTargetWrapper = 
{ 0x1d18c667, 0x2e8, 0x4744, { 0x86, 0x6b, 0x4f, 0x4c, 0xac, 0x4d, 0x56, 0x5e } };
   
class DropTargetWrapper : public IDropTarget
{
public:
	DropTargetWrapper(HWND hwnd, IDropTarget *pTarget);
	~DropTargetWrapper();

	STDMETHODIMP QueryInterface(REFIID riid, void **ppvObject);
	STDMETHODIMP_(ULONG) AddRef();
	STDMETHODIMP_(ULONG) Release();
	
	STDMETHODIMP DragEnter(IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect);
	STDMETHODIMP DragOver(DWORD grfKeyState, POINTL pt, DWORD *pdwEffect);
	STDMETHODIMP DragLeave();
	STDMETHODIMP Drop(IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect);

	IDropTarget* GetOriginalTarget();

private:
	LONG m_cRef;
	IDropTarget *m_pTarget;
	HWND m_hWnd;
	
	void DnDFilter(LPDWORD pKeyState, LPDWORD pEffect);
};
