/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"
#include "Locale.h"

static HINSTANCE ghDefaultRes;
static HINSTANCE ghLangRes;

BOOL InitialLocaleResource(HINSTANCE hInstance)
{
	TCHAR exeName[MAX_PATH];
	TCHAR resName[MAX_PATH];
	TCHAR langName[4];
	TCHAR ctryName[4];

	ghDefaultRes = hInstance;

	LCID local = GetUserDefaultLCID();
	GetLocaleInfo(local, LOCALE_SISO639LANGNAME, langName, _countof(langName));
	GetLocaleInfo(local, LOCALE_SISO3166CTRYNAME, ctryName, _countof(ctryName));
	
	GetModuleFileName(hInstance, exeName, _countof(exeName));
	exeName[_tcslen(exeName) - 4] = _T('\0');

	StringCchCopy(resName, _countof(resName), exeName);
	StringCchCat(resName, _countof(resName), _T("_"));
	StringCchCat(resName, _countof(resName), langName);
	StringCchCat(resName, _countof(resName), _T("-"));
	StringCchCat(resName, _countof(resName), ctryName);
	StringCchCat(resName, _countof(resName), _T(".dll"));

	ghLangRes = LoadLibrary(resName);
	if (ghLangRes) {
		return TRUE;
	}

	// AlterDnD_xx-XX.dll ΁AAlterDnD_xx.dll g
	StringCchCopy(resName, _countof(resName), exeName);
	StringCchCat(resName, _countof(resName), _T("_"));
	StringCchCat(resName, _countof(resName), langName);
	StringCchCat(resName, _countof(resName), _T(".dll"));

	ghLangRes = LoadLibrary(resName);
	if (ghLangRes) {
		return TRUE;
	}
	return FALSE;
}

void LoadStringLocale(UINT uID, LPTSTR buff, int buffSize)
{
	if (ghLangRes) {
		if (LoadString(ghLangRes, uID, buff, buffSize)) {
			return;
		}
	}
	if (LoadString(ghDefaultRes, uID, buff, buffSize)) {
		return;
	}
	_stprintf_s(buff, buffSize, _T("# uID = %d"), uID);
}

HICON LoadIconLocale(LPCWSTR lpIconName)
{
	HICON hIcon;

	if (ghLangRes) {
		hIcon = LoadIcon(ghLangRes, lpIconName);
		if (hIcon) {
			return hIcon;
		}
	}
	return LoadIcon(ghDefaultRes, lpIconName);
}

HMENU LoadMenuLocale(LPCTSTR lpMenuName)
{
	HMENU hMenu;

	if (ghLangRes) {
		hMenu = LoadMenu(ghLangRes, lpMenuName);
		if (hMenu) {
			return hMenu;
		}
	}
	return LoadMenu(ghDefaultRes, lpMenuName);
}

INT_PTR DialogBoxLocale(LPCTSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc)
{
	INT_PTR dlg;
	if (ghLangRes) {
		dlg = DialogBox(ghLangRes, lpTemplateName, hWndParent, lpDialogFunc);
		if (dlg != -1) {
			return dlg;
		}
	}
	return DialogBox(ghDefaultRes, lpTemplateName, hWndParent, lpDialogFunc);
}

