/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"
#include "AlterDnD.h"
#include "Locale.h"
#include "../AlterDnD_DLL/AlterDnD_DLL.h"

#define MAX_LOADSTRING 100

// O[oϐ:
HINSTANCE hInst;								// ݂̃C^[tFCX
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
ATOM				MyRegisterClass(HINSTANCE hInstance);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
HANDLE				CreateMutexNew(LPCTSTR name);

int APIENTRY _tWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPTSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	hInst = hInstance; // O[oϐɃCX^Xi[܂B

	HANDLE mutex = CreateMutexNew(_T("AlterDnD Mutex"));
	if (mutex == NULL) {
		//DP(_T("MMEx Started exit!"));
		return 0;
	}
	InitialLocaleResource(hInstance);

	LoadStringLocale(IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadStringLocale(IDC_ALTERDND, szWindowClass, MAX_LOADSTRING);

	LoadDnDMode();

	MyRegisterClass(hInstance);

	// bZ[W󂯎p̃_~[EBhE
	HWND hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);
	if (!hWnd) {
		TCHAR szMsg[MAX_LOADSTRING];
		LoadStringLocale(IDS_ERR_CREATE_WINDOW, szMsg, MAX_LOADSTRING);
		MessageBox(NULL, szMsg, szTitle, MB_ICONERROR);
		ReleaseMutex(mutex);
		return FALSE;
	}
	//ShowWindow(hWnd, nCmdShow);
	//UpdateWindow(hWnd);
	InstallHook();

	MSG msg;
	HACCEL hAccelTable;

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_ALTERDND));
	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0)) {
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	UninstallHook();
	ReleaseMutex(mutex);

	return (int) msg.wParam;
}

HANDLE CreateMutexNew(LPCTSTR name)
{
	HANDLE hMutex = CreateMutex(NULL, TRUE, name);
	if (GetLastError() == ERROR_ALREADY_EXISTS) {
		ReleaseMutex(hMutex);
		return NULL;
	}
	return hMutex;
}

//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIconLocale(MAKEINTRESOURCE(IDI_ALTERDND));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW + 1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIconLocale(MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static UINT s_uTaskbarRestart;
	static HMENU hMenu;
	static HMENU hPopupMenu;

	switch (message)
	{
	case WM_CREATE:
		{
			s_uTaskbarRestart = RegisterWindowMessage(TEXT("TaskbarCreated"));
			hMenu = LoadMenuLocale(MAKEINTRESOURCE(IDC_ALTERDND));
			hPopupMenu = GetSubMenu(hMenu, 0);

			AddTaskTrayIcon(hWnd);
		}
		return 0;
	case WM_TIMER:
		if (wParam == ID_TIMER_RETRY_TRAY) {
			AddTaskTrayIcon(hWnd);
			return 0;
		}
		break;
	case WM_INITMENUPOPUP:
		if ((HMENU)wParam == hPopupMenu) {
			MENUITEMINFO mii;
			ZeroMemory(&mii, sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_STATE | MIIM_FTYPE;
			mii.fType = MFT_RADIOCHECK;

			DWORD mode = GetDnDMode();

			mii.fState = (mode == DNDMODE_NORMAL) ? MFS_CHECKED : MFS_UNCHECKED;
			SetMenuItemInfo(hPopupMenu, IDM_DND_NORMAL, FALSE, &mii);

			mii.fState = (mode == DNDMODE_ANY_KEYDOWN) ? MFS_CHECKED : MFS_UNCHECKED;
			SetMenuItemInfo(hPopupMenu, IDM_DND_ANY_KEYDONWN, FALSE, &mii);

			mii.fState = (mode == DNDMODE_RBUTTON_SIMULATE) ? MFS_CHECKED : MFS_UNCHECKED;
			SetMenuItemInfo(hPopupMenu, IDM_DND_RBUTTON_SIMULATE, FALSE, &mii);

			mii.fState = (mode == DNDMODE_FORBIDS) ? MFS_CHECKED : MFS_UNCHECKED;
			SetMenuItemInfo(hPopupMenu, IDM_DND_FORBIDS, FALSE, &mii);

			return 0;
		}
		break;
	case WM_COMMAND:
		{
			// Iꂽj[̉:
			switch (LOWORD(wParam)) {
			case IDM_DND_NORMAL:
				SetDnDMode(DNDMODE_NORMAL);
				SaveDnDMode();
				return 0;
			case IDM_DND_ANY_KEYDONWN:
				SetDnDMode(DNDMODE_ANY_KEYDOWN);
				SaveDnDMode();
				return 0;
			case IDM_DND_RBUTTON_SIMULATE:
				SetDnDMode(DNDMODE_RBUTTON_SIMULATE);
				SaveDnDMode();
				return 0;
			case IDM_DND_FORBIDS:
				SetDnDMode(DNDMODE_FORBIDS);
				SaveDnDMode();
				return 0;
			case IDM_ABOUT:
				DialogBoxLocale(MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
				return 0;
			case IDM_EXIT:
				DestroyWindow(hWnd);
				return 0;
			default:
				break;
			}
		}
		break;
	case WM_ALTERDND_TRAY_ICON:
		if (wParam == ID_ALTERDND_TRAY_ICON) {
			POINT pt;

			switch (lParam) {
			case WM_RBUTTONUP:
				GetCursorPos(&pt);
				SetForegroundWindow(hWnd);
				TrackPopupMenu(hPopupMenu, TPM_BOTTOMALIGN, pt.x, pt.y, 0, hWnd, NULL);
			}
		}
		return 0;
	case WM_DESTROY:
		RemoveTaskTrayIcon(hWnd);
		PostQuitMessage(0);
		return 0;
	default:
		if(message == s_uTaskbarRestart) {
			AddTaskTrayIcon(hWnd);
			return 0;
		}
		break;
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

// o[W{bNX̃bZ[W nh[łB
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message) {
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

