<?php
/**
* singleton class manager
*
* @auther Haruki Setoyama <haruki@planewave.org>
* @lisence BSD
* @version $Id: singleton.php,v 1.1 2003/06/15 13:08:41 haruki Exp $
* @access public
*/
if(! class_exists('singleton'))
{
    if(!defined('SINGLETON_GLOBAL')) define('SINGLETON_GLOBAL', 'SINGLETON');

    class singleton
    {

        /**
        * singleton::init()
        * alias of singleton::self() for initialization porpose.
        * @access public
        */
        function init()
        {
            singleton::self();
        }

        /**
        * singleton::self()
        * get instance singleton class itself.
        * @access public
        */
        function &self()
        {
            static $obj;
            if(!isset($obj))
            {
                $obj = new singleton;
                if(!isset($GLOBALS[SINGLETON_GLOBAL]))
                    $GLOBALS[SINGLETON_GLOBAL] =& $obj;
            }
            return $obj;
        }

        /**
        * singleton::getInstance()
        * @param class name that you want to make singleton.
        * @access public
        */
        function &getInstance($name)
        {
            $singleton =& singleton::self();
            return $singleton->instance($name);
        }

        /**
        * instance
        * @param class name that you want to make singleton.
        * @access public
        */
        function &instance($name)
        {
            if(!isset($this->$name))
            {
                if(! class_exists($name))
                {
                    trigger_error('singleton::instance()::Class "'.$name.'" not exist', E_USER_WARNING);
                    return null;
                }
                $this->$name = new $name;
                if(is_callable(array($this->$name, 'getInstance')))
                {
                    $this->$name =& $this->$name->getInstance();
                }
            }
            return $this->$name;
        }

        function isInstanciated($name)
        {
            $singleton =& singleton::self();
            return (!isset($singleton->$name)) ? false : true;
        }
    }
}

?>