package net.bakingpowder.jspl.tcprelay_distributed.sendRelay;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

//import net.bakingpowder.tmiz.proxy.ConnectControl;

/**
 * @author Tomoo D. Mizukami/JAIST/Softbank Publishing Inc.
 * 
 * This class is multi-thread class for buffer-interchange-function.
 */
public class SendInput2Output implements Runnable {
	private InputStream in = null;
	private OutputStream out = null;
	private SendConnectControl cc = null;
	private byte buffer[] = null;
	private static int BUFFER_SIZE = 4096;
	private boolean stopper = false;
	
	public synchronized void stopd(){
		this.stopper = true;
	}
	
	/**
	 * @param in
	 *            InputStream
	 * @param out
	 *            OutputStream
	 * @param cm
	 *            ConnectControl
	 */
	public SendInput2Output(InputStream in, OutputStream out, SendConnectControl cc) {
		this.in = in;
		this.out = out;
		this.cc = cc;
		buffer = new byte[BUFFER_SIZE];

		t = new Thread(this);
		t.start();
	}
	private Thread t;

	public void run() {
		try {
			int bytesRead = 0;

			LOOP1 : while (!this.stopper) {

				if ((bytesRead = in.read(buffer, 0, BUFFER_SIZE)) == -1)
					break;

				out.write(buffer, 0, bytesRead);
				
			}

		} catch (IOException e) {
			//ignore
		}
		cc.ThreadArrivedEnd(this);
	}
}