package org.maachang.reflect ;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 高速クラス読み込み.
 *
 * @version 2009/03/29
 * @author  masahito suzuki
 * @since   FastReflect 1.00
 */
abstract class FastReflectClass {
    private FastReflectClass() {}
    
    /**
     * 未アクセス時の破棄時間.
     */
    private static final long WAIT_TIME = 15000L ;
    
    /**
     * クラスキャッシュ用.
     */
    protected static final Map<String,FastClassElement> cacheClass = new ConcurrentHashMap<String,FastClassElement>() ;
    protected static final FastReflectMon mon = new FastReflectMon() ;
    
    /**
     * 指定パッケージ名のクラス情報を取得.
     * @param name 対象のクラス名を設定します.
     * @return FastClassElement 対象のクラス情報が返されます.
     * @exception ClassNotFoundException ロードクラス例外.
     */
    public static final FastClassElement getClass( String name )
        throws ClassNotFoundException {
        if( name == null || name.length() <= 0 ) {
            throw new IllegalArgumentException( "クラス名が指定されていません" ) ;
        }
        FastClassElement ret = cacheClass.get( name ) ;
        if( ret == null ) {
            Class c ;
            if( (c = Class.forName( name )) != null ) {
                ret = new FastClassElement( c ) ;
                cacheClass.put( name,ret ) ;
            }
        }
        if( ret != null ) {
            ret.update() ;
        }
        return ret ;
    }
    
    /**
     * 指定パッケージ名のクラス情報を取得.
     * @param cl 対象のクラスローダを設定します.
     * @param name 対象のクラス名を設定します.
     * @return Class 対象のクラス情報が返されます.
     * @exception ClassNotFoundException ロードクラス例外.
     */
    public static final FastClassElement getClass( ClassLoader cl,String name )
        throws ClassNotFoundException {
        if( name == null || name.length() <= 0 ) {
            throw new IllegalArgumentException( "クラス名が指定されていません" ) ;
        }
        FastClassElement ret = cacheClass.get( name ) ;
        if( ret == null ) {
            Class c ;
            if( cl == null ) {
                c = Class.forName( name ) ;
            }
            else {
                c = cl.loadClass( name ) ;
            }
            if( c != null ) {
                ret = new FastClassElement( c ) ;
                cacheClass.put( name,ret ) ;
            }
        }
        if( ret != null ) {
            ret.update() ;
        }
        return ret ;
    }
    
    // オブジェクト未利用監視.
    private static class FastReflectMon extends Thread {
        FastReflectMon() {
            try {
                this.setDaemon( true ) ;
                this.start() ;
            } catch( Exception e ) {
            }
        }
        
        public void run() {
            long WAIT = FastReflectClass.WAIT_TIME ;
            while( true ) {
                Map<String,FastClassElement> m = FastReflectClass.cacheClass ;
                String k ;
                FastClassElement v ;
                try {
                    Iterator it = m.keySet().iterator() ;
                    while( it.hasNext() ) {
                        Thread.sleep( 50L ) ;
                        k = (String)it.next() ;
                        v = m.get( k ) ;
                        if( v != null ) {
                            if( v.getLastAccessTime() + WAIT <= System.currentTimeMillis() ) {
                                m.remove( k ) ;
                            }
                        }
                    }
                    Thread.sleep( 50L ) ;
                } catch( InterruptedException ite ) {
                    break ;
                } catch ( NullPointerException ne ) {
                } catch( OutOfMemoryError mem ) {
                } catch( Exception e ) {
                }
            }
        }
    }
}
