/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.InvocationTargetException;
import org.maachang.reflect.FastClassElement;
import org.maachang.reflect.FastFieldChild;
import org.maachang.reflect.FastReflectClass;
import org.maachang.reflect.FastReflectUtil;

public abstract class FastReflect {
    public static final String VERSION = "1.05";
    private static final String OBJECT_NAME = Object.class.getName();

    private FastReflect() {
    }

    public static final boolean isSunPackage() {
        return FastClassElement._IS_SUN_PACKAGE;
    }

    public static final void clearCacheAll() {
        FastReflectClass.cacheClass.clear();
    }

    public static final void clearCache(String name) {
        FastReflectClass.cacheClass.remove(name);
    }

    public static final Class getClass(String name) throws ClassNotFoundException {
        return FastReflect.getClass(null, name);
    }

    public static final Class getClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("\u30af\u30e9\u30b9\u540d\u306f\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        FastClassElement em = FastReflectClass.getClass(loader, name);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return em.getClassObject();
    }

    public static final Object newInstance(String name) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        return FastReflect.newInstance(null, name, (Object[])null);
    }

    public static final Object newInstance(ClassLoader loader, String name) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        return FastReflect.newInstance(loader, name, (Object[])null);
    }

    public static final Object newInstance(String name, Object ... args) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        return FastReflect.newInstance(null, name, args);
    }

    public static final Object newInstance(ClassLoader loader, String name, Object ... args) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        FastClassElement em = FastReflectClass.getClass(loader, name);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (name == OBJECT_NAME) {
            return new Object();
        }
        Class[] types = FastReflectUtil.getParamsType(args);
        do {
            Object ret;
            if ((ret = em.newInstance(types, args, loader)) != null) {
                return ret;
            }
            String superName = em.getSuperClassName();
            em = null;
            if (superName == OBJECT_NAME || superName == null) continue;
            em = FastReflectClass.getClass(loader, superName);
        } while (em != null);
        throw new NoSuchMethodException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306b\u5bfe\u3057\u3066\u3001\u5bfe\u8c61\u5f15\u6570\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public static final Object newInstanceTo(ClassLoader loader, String name, Object[] args, Class[] types) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        FastClassElement em = FastReflectClass.getClass(loader, name);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (name == OBJECT_NAME) {
            return new Object();
        }
        if (args != null && args.length > 0 && types == null) {
            types = FastReflectUtil.getParamsType(args);
        } else if (types != null) {
            types = FastReflectUtil.getParamsTypeByClass(types);
        }
        do {
            Object ret;
            if ((ret = em.newInstance(types, args, loader)) != null) {
                return ret;
            }
            String superName = em.getSuperClassName();
            em = null;
            if (superName == OBJECT_NAME || superName == null) continue;
            em = FastReflectClass.getClass(loader, superName);
        } while (em != null);
        throw new NoSuchMethodException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306b\u5bfe\u3057\u3066\u3001\u5bfe\u8c61\u5f15\u6570\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public static final void setField(String clazzName, Object target, String name, Object value) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        FastReflect.setField(null, clazzName, target, name, value);
    }

    public static final void setField(ClassLoader loader, String clazzName, Object target, String name, Object value) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        FastFieldChild f;
        boolean staticFlag;
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        boolean bl = staticFlag = target == null;
        while ((f = em.getField(staticFlag, name)) == null) {
            String superName = em.getSuperClassName();
            em = null;
            if (superName != null) {
                em = FastReflectClass.getClass(loader, superName);
            }
            if (em != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        f.set(target, value);
    }

    public static final void setField(Class clazz, Object target, String name, Object value) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        FastReflect.setField(null, clazz, target, name, value);
    }

    public static final void setField(ClassLoader loader, Class clazz, Object target, String name, Object value) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        FastFieldChild f;
        boolean staticFlag;
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        boolean bl = staticFlag = target == null;
        while ((f = em.getField(staticFlag, name)) == null) {
            String superName = em.getSuperClassName();
            em = null;
            if (superName != null) {
                em = FastReflectClass.getClass(loader, superName);
            }
            if (em != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        f.set(target, value);
    }

    public static final Object getField(String clazzName, Object target, String name) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        return FastReflect.getField(null, clazzName, target, name);
    }

    public static final Object getField(ClassLoader loader, String clazzName, Object target, String name) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        FastFieldChild f;
        boolean staticFlag;
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        boolean bl = staticFlag = target == null;
        while ((f = em.getField(staticFlag, name)) == null) {
            String superName = em.getSuperClassName();
            em = null;
            if (superName != null) {
                em = FastReflectClass.getClass(loader, superName);
            }
            if (em != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return f.get(target);
    }

    public static final Object getField(Class clazz, Object target, String name) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        return FastReflect.getField(null, clazz, target, name);
    }

    public static final Object getField(ClassLoader loader, Class clazz, Object target, String name) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        FastFieldChild f;
        boolean staticFlag;
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        boolean bl = staticFlag = target == null;
        while ((f = em.getField(staticFlag, name)) == null) {
            String superName = em.getSuperClassName();
            em = null;
            if (superName != null) {
                em = FastReflectClass.getClass(loader, superName);
            }
            if (em != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return f.get(target);
    }

    public static final Object invoke(String clazzName, Object target, String name) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return FastReflect.invoke(null, clazzName, target, name, (Object[])null);
    }

    public static final Object invoke(ClassLoader loader, String clazzName, Object target, String name) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return FastReflect.invoke(loader, clazzName, target, name, (Object[])null);
    }

    public static final Object invoke(Class clazz, Object target, String name) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return FastReflect.invoke(null, clazz, target, name, (Object[])null);
    }

    public static final Object invoke(ClassLoader loader, Class clazz, Object target, String name) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return FastReflect.invoke(loader, clazz, target, name, (Object[])null);
    }

    public static final Object invoke(String clazzName, Object target, String name, Object ... args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return FastReflect.invoke(null, clazzName, target, name, args);
    }

    public static final Object invoke(ClassLoader loader, String clazzName, Object target, String name, Object ... args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        Object[] ret = new Object[1];
        Class[] types = FastReflectUtil.getParamsType(args);
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }

    public static final Object invoke(Class clazz, Object target, String name, Object ... args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return FastReflect.invoke(null, clazz, target, name, args);
    }

    public static final Object invoke(ClassLoader loader, Class clazz, Object target, String name, Object ... args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        Object[] ret = new Object[1];
        Class[] types = FastReflectUtil.getParamsType(args);
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }

    public static final Object invokeTo(ClassLoader loader, String clazzName, Object target, String name, Object[] args, Class[] types) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (args != null && args.length > 0 && types == null) {
            types = FastReflectUtil.getParamsType(args);
        } else if (types != null) {
            types = FastReflectUtil.getParamsTypeByClass(types);
        }
        Object[] ret = new Object[1];
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }

    public static final Object invokeTo(ClassLoader loader, Class clazz, Object target, String name, Object[] args, Class[] types) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (args != null && args.length > 0 && types == null) {
            types = FastReflectUtil.getParamsType(args);
        } else if (types != null) {
            types = FastReflectUtil.getParamsTypeByClass(types);
        }
        Object[] ret = new Object[1];
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }
}

