/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.maachang.reflect.FastMethodElements;
import org.maachang.reflect.FastReflectPrimitive;
import org.maachang.reflect.FastReflectUtil;

class FastMethodElementsNormal
extends FastMethodElements {
    private final Map<String, FastMethodEmtNormal> map = new HashMap<String, FastMethodEmtNormal>();

    private FastMethodElementsNormal() {
    }

    public FastMethodElementsNormal(Class clazz) throws NoSuchMethodException, InvocationTargetException, NoSuchFieldException, IllegalAccessException {
        Method[] ms = clazz.getDeclaredMethods();
        if (ms != null) {
            for (Method m : ms) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                String name = m.getName();
                if (this.map.containsKey(name)) {
                    FastMethodEmtNormal f = this.map.get(name);
                    if (f.next == null) {
                        f.next = new FastMethodEmtNormal(m);
                        continue;
                    }
                    FastMethodEmtNormal n = f.next;
                    f.next = new FastMethodEmtNormal(m);
                    f.next.next = n;
                    continue;
                }
                this.map.put(name, new FastMethodEmtNormal(m));
            }
        }
    }

    protected void finalize() throws Exception {
        this.map.clear();
    }

    @Override
    public boolean invoke(Object[] result, Object target, String name, ClassLoader cl, Class[] types, Object[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        boolean staticFlag = target == null;
        int argsLen = args == null ? 0 : args.length;
        FastMethodEmtNormal emt = this.map.get(name);
        if (argsLen == 0) {
            while (emt != null) {
                if (staticFlag == emt.isStatic && argsLen == emt.paramsLength) {
                    Object res = emt.method.invoke(target, FastReflectPrimitive.NO_PARAM);
                    if (result != null) {
                        result[0] = res;
                    }
                    return true;
                }
                emt = emt.next;
            }
        } else {
            int pf = 100 * argsLen;
            int score = -1;
            FastMethodEmtNormal targetEmt = null;
            while (emt != null) {
                int sc;
                if (staticFlag == emt.isStatic && argsLen == emt.paramsLength && (sc = FastReflectUtil.parmasScore(emt.primitives, emt.params, types, args, cl)) != -1 && score < sc) {
                    if (sc == pf) {
                        Object res = emt.method.invoke(target, args);
                        if (result != null) {
                            result[0] = res;
                        }
                        return true;
                    }
                    score = sc;
                    targetEmt = emt;
                }
                emt = emt.next;
            }
            if (targetEmt != null) {
                if ((args = FastReflectUtil.convertParams(args, targetEmt.params)) == null) {
                    return false;
                }
                Object res = targetEmt.method.invoke(target, args);
                if (result != null) {
                    result[0] = res;
                }
                return true;
            }
        }
        return false;
    }

    private static class FastMethodEmtNormal {
        protected FastMethodEmtNormal next;
        protected Method method;
        protected Class[] params;
        protected boolean[] primitives;
        protected int paramsLength;
        protected boolean isStatic;

        protected FastMethodEmtNormal(Method method) throws NoSuchMethodException, InvocationTargetException, NoSuchFieldException, IllegalAccessException {
            int len;
            boolean[] pms = null;
            Class<?>[] args = method.getParameterTypes();
            int n = len = args == null ? 0 : args.length;
            if (len == 0) {
                args = FastReflectPrimitive.NO_PARAM_CLASS;
            } else {
                pms = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    pms[i] = args[i].isPrimitive();
                    Class pc = FastReflectPrimitive.CONV_PRIMITIVE.get(args[i]);
                    if (pc == null) continue;
                    args[i] = pc;
                }
            }
            method.setAccessible(true);
            this.method = method;
            this.params = args;
            this.primitives = pms;
            this.paramsLength = len;
            this.isStatic = Modifier.isStatic(method.getModifiers());
        }
    }
}

