/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.maachang.reflect.FastFieldChild;
import org.maachang.reflect.FastFieldElements;

class FastFieldElementsNormal
extends FastFieldElements {
    private final Map<String, FastFieldChildNormal> map = new HashMap<String, FastFieldChildNormal>();

    private FastFieldElementsNormal() {
    }

    public FastFieldElementsNormal(Class clazz) {
        Field[] fs = clazz.getDeclaredFields();
        if (fs != null) {
            for (Field f : fs) {
                if (!Modifier.isPublic(f.getModifiers())) continue;
                f.setAccessible(true);
                FastFieldChildNormal n = new FastFieldChildNormal();
                n.field = f;
                n.staticFlag = Modifier.isStatic(f.getModifiers());
                this.map.put(f.getName(), n);
            }
        }
    }

    protected void finalize() throws Exception {
        this.map.clear();
    }

    @Override
    public FastFieldChild get(boolean staticFlag, String name) {
        FastFieldChildNormal n = this.map.get(name);
        if (n != null && n.staticFlag == staticFlag) {
            return n;
        }
        return null;
    }

    class FastFieldChildNormal
    extends FastFieldChild {
        protected Field field;
        protected boolean staticFlag;

        FastFieldChildNormal() {
        }

        @Override
        public void set(Object target, Object value) throws IllegalAccessException {
            this.field.set(target, value);
        }

        @Override
        public Object get(Object target) throws IllegalAccessException {
            return this.field.get(target);
        }
    }
}

