/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.maachang.reflect.FastConstructorElements;
import org.maachang.reflect.FastReflectPrimitive;
import org.maachang.reflect.FastReflectUtil;
import sun.reflect.ConstructorAccessor;

class FastConstructorElementsSun
extends FastConstructorElements {
    protected static final String ACQUIRE_CONST_ACCESSOR = "acquireConstructorAccessor";
    protected static final String CONST_ACCESSOR = "constructorAccessor";
    private final List<FastConstructorEmtSun> list = new ArrayList<FastConstructorEmtSun>();

    private FastConstructorElementsSun() {
    }

    public FastConstructorElementsSun(Class clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Constructor<?>[] cs = clazz.getDeclaredConstructors();
        if (cs != null) {
            for (Constructor<?> c : cs) {
                if (!Modifier.isPublic(c.getModifiers())) continue;
                this.list.add(new FastConstructorEmtSun(c));
            }
        }
    }

    protected void finalize() throws Exception {
        this.list.clear();
    }

    @Override
    public Object newInstance(ClassLoader cl, Class[] types, Object[] args) throws ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        int argsLen;
        int len = this.list.size();
        int n = argsLen = args == null ? 0 : args.length;
        if (argsLen == 0) {
            for (int i = 0; i < len; ++i) {
                FastConstructorEmtSun emt = this.list.get(i);
                if (emt.paramsLength != 0) continue;
                return emt.constructor.newInstance(FastReflectPrimitive.NO_PARAM);
            }
        } else {
            int pf = 100 * argsLen;
            int score = -1;
            FastConstructorEmtSun targetEmt = null;
            for (int i = 0; i < len; ++i) {
                int sc;
                FastConstructorEmtSun emt = this.list.get(i);
                if (emt.paramsLength != argsLen || (sc = FastReflectUtil.parmasScore(emt.primitives, emt.params, types, args, cl)) == -1 || score >= sc) continue;
                if (sc == pf) {
                    return emt.constructor.newInstance(args);
                }
                score = sc;
                targetEmt = emt;
            }
            if (targetEmt != null) {
                if ((args = FastReflectUtil.convertParams(args, targetEmt.params)) == null) {
                    throw new IllegalAccessException("\u30d1\u30e9\u30e1\u30fc\u30bf\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
                return targetEmt.constructor.newInstance(args);
            }
        }
        return null;
    }

    private static class FastConstructorEmtSun {
        protected ConstructorAccessor constructor;
        protected Class[] params;
        protected boolean[] primitives;
        protected int paramsLength;

        protected FastConstructorEmtSun(Constructor constructor) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
            ConstructorAccessor accessor;
            int len;
            boolean[] pms = null;
            Class<?>[] args = constructor.getParameterTypes();
            int n = len = args == null ? 0 : args.length;
            if (len == 0) {
                args = FastReflectPrimitive.NO_PARAM_CLASS;
            } else {
                pms = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    pms[i] = args[i].isPrimitive();
                    Class pc = FastReflectPrimitive.CONV_PRIMITIVE.get(args[i]);
                    if (pc == null) continue;
                    args[i] = pc;
                }
            }
            constructor.setAccessible(true);
            Method am = constructor.getClass().getDeclaredMethod(FastConstructorElementsSun.ACQUIRE_CONST_ACCESSOR, new Class[0]);
            am.setAccessible(true);
            am.invoke((Object)constructor, new Object[0]);
            am = null;
            Field ma = constructor.getClass().getDeclaredField(FastConstructorElementsSun.CONST_ACCESSOR);
            ma.setAccessible(true);
            this.constructor = accessor = (ConstructorAccessor)ma.get(constructor);
            this.params = args;
            this.primitives = pms;
            this.paramsLength = len;
        }
    }
}

