/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.maachang.reflect.FastConstructorElements;
import org.maachang.reflect.FastFieldElements;
import org.maachang.reflect.FastMethodElements;

class FastClassElement {
    private String name = null;
    private Class clazz = null;
    private String superClazz = null;
    private String[] interfaze = null;
    private FastConstructorElements constructors = null;
    private FastFieldElements fileds = null;
    private FastMethodElements methods = null;
    private final AtomicLong lastAccessTime = new AtomicLong(System.currentTimeMillis());

    private FastClassElement() {
    }

    protected FastClassElement(Class clazz) throws ClassNotFoundException {
        try {
            this.name = clazz.getName();
            this.clazz = clazz;
            this.superClazz = FastClassElement.getSuperClazz(clazz);
            this.interfaze = FastClassElement.getInterface(clazz);
            this.constructors = new FastConstructorElements(clazz);
            this.fileds = new FastFieldElements(clazz);
            this.methods = new FastMethodElements(clazz);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("\u30af\u30e9\u30b9\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    protected FastClassElement(String name, ClassLoader cl) throws ClassNotFoundException {
        Class<?> clazz = cl == null ? Class.forName(name) : cl.loadClass(name);
        this.name = name;
        this.clazz = clazz;
        this.superClazz = FastClassElement.getSuperClazz(clazz);
        this.interfaze = FastClassElement.getInterface(clazz);
        this.constructors = new FastConstructorElements(clazz);
        this.fileds = new FastFieldElements(clazz);
        this.methods = new FastMethodElements(clazz);
    }

    protected void finalize() throws Exception {
        this.name = null;
        this.clazz = null;
        this.superClazz = null;
        this.interfaze = null;
        this.constructors = null;
        this.fileds = null;
        this.methods = null;
    }

    public String getName() {
        return this.name;
    }

    public Class getClassObject() {
        return this.clazz;
    }

    public String getSuperClassName() {
        return this.superClazz;
    }

    public String[] getInterfaseNames() {
        return this.interfaze;
    }

    public Field getField(boolean staticFlag, String name) {
        return this.fileds.get(staticFlag, name);
    }

    public Object newInstance(Class[] types, Object[] args, ClassLoader cl) throws ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        return this.constructors.newInstance(cl, types, args);
    }

    public boolean invokeMethod(Object[] result, Object target, String name, ClassLoader cl, Class[] types, Object[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return this.methods.invoke(result, target, name, cl, types, args);
    }

    public void update() {
        long t = System.currentTimeMillis();
        AtomicLong ato = this.lastAccessTime;
        while (!ato.compareAndSet(ato.get(), t)) {
        }
    }

    public long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    private static final String getSuperClazz(Class clazz) {
        Class c = clazz.getSuperclass();
        if (c == null) {
            return null;
        }
        return c.getName();
    }

    private static final String[] getInterface(Class clazz) {
        Class<?>[] cz = clazz.getInterfaces();
        if (cz == null) {
            return null;
        }
        int len = cz.length;
        if (len > 0) {
            Object[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = cz[i].getName();
                ++i;
            }
            Arrays.sort(ret);
            return ret;
        }
        return null;
    }
}

