package org.maachang.reflect.test ;

import org.maachang.reflect.FastReflect;

// 基本動作確認用.
public class TestBase {
    private static final String THIS = "org.maachang.reflect.test.TestBase" ;
    public static final void main( String[] args ) throws Exception {
        fieldTest() ;
        constructorTest() ;
        methodTest() ;
    }
    
    //////////////////////////////////////////////////////////////////////////
    // フィールドアクセステスト.
    //////////////////////////////////////////////////////////////////////////
    public static int _FIELD = 10 ;
    public String _field = "hoge" ;
    public static final void fieldTest() throws Exception {
        // 読み込み.
        System.out.println( "#field-Test(1)staticアクセス:" + FastReflect.getField( THIS,null,"_FIELD" ) ) ;
        
        TestBase base = new TestBase() ;
        System.out.println( "#field-Test(2)オブジェクトアクセス:" + FastReflect.getField( THIS,base,"_field" ) ) ;
        
        // 書き込み.
        FastReflect.setField( THIS,null,"_FIELD",100 ) ;
        System.out.println( "#field-Test(3)static設定:" + FastReflect.getField( THIS,null,"_FIELD" ) ) ;
        
        FastReflect.setField( THIS,base,"_field","moge" ) ;
        System.out.println( "#field-Test(4)オブジェクト設定:" + FastReflect.getField( THIS,base,"_field" ) ) ;
    }
    
    //////////////////////////////////////////////////////////////////////////
    // コンストラクタアクセステスト.
    //////////////////////////////////////////////////////////////////////////
    public TestBase() {
        System.out.println( "#constructor-Test:ノーマルコンストラクタ" ) ;
    }
    public TestBase( String a ) {
        System.out.println( "#constructor-Test引数付きコンストラクタ:[" + a + "]" ) ;
    }
    public static final void constructorTest() throws Exception {
        // 通常コンストラクタ.
        FastReflect.newInstance( THIS ) ;
        
        // 引数付きコンストラクタ.
        FastReflect.newInstance( THIS,"hoge" ) ;
    }
    
    //////////////////////////////////////////////////////////////////////////
    // メソッドアクセステスト.
    //////////////////////////////////////////////////////////////////////////
    public static final String method1() {
        return "[s]hoge" ;
    }
    public static final String method2(int a) {
        return "[s]hoge(int):" + a ;
    }
    public static final String method2(String a) {
        return "[s]hoge(String):" + a ;
    }
    public final String method3() {
        return "[n]hoge" ;
    }
    public final String method4(int a) {
        return "[n]hoge(int):" + a ;
    }
    public final String method4(String a) {
        return "[n]hoge(String):" + a ;
    }
    public static final void methodTest() throws Exception {
        // static系.
        System.out.println( "#method-test(1)static引数なし:" + FastReflect.invoke( THIS,null,"method1" )) ;
        System.out.println( "#method-test(2)static引数あり(int):" + FastReflect.invoke( THIS,null,"method2",10 )) ;
        System.out.println( "#method-test(3)static引数あり(String):" + FastReflect.invoke( THIS,null,"method2","abcdefg" )) ;
        
        // オブジェクト.
        TestBase base = new TestBase() ;
        System.out.println( "#method-test(1)object引数なし:" + FastReflect.invoke( THIS,base,"method3" )) ;
        System.out.println( "#method-test(2)object引数あり(int):" + FastReflect.invoke( THIS,base,"method4",10 )) ;
        System.out.println( "#method-test(3)object引数あり(String):" + FastReflect.invoke( THIS,base,"method4","abcdefg" )) ;
    }
}

