/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.maachang.reflect.FastClassElement;
import org.maachang.reflect.FastReflectClass;
import org.maachang.reflect.FastReflectPrimitive;

abstract class FastReflectUtil {
    private static final Map<Class, Class> CONV_PRIMITIVE = FastReflectPrimitive.CONV_PRIMITIVE;
    private static final Set<Class> PRIMITIVE = FastReflectPrimitive.PRIMITIVE;
    private static final Object OBJECT = FastReflectPrimitive.OBJECT;
    private static final Object STRING = FastReflectPrimitive.STRING;
    private static final Set<Class> NUMBER_PRIMITIVE = FastReflectPrimitive.NUMBER_PRIMITIVE;
    private static final Map<Class, Integer> CONV_TABLE;

    private FastReflectUtil() {
    }

    public static final Class[] getParamsType(Object ... args) {
        int argsLen;
        if (args == null || (argsLen = args.length) <= 0) {
            return FastReflectPrimitive.NO_PARAM_CLASS;
        }
        Class[] c = new Class[argsLen];
        for (int i = 0; i < argsLen; ++i) {
            if (args[i] == null) continue;
            c[i] = args[i].getClass();
        }
        return c;
    }

    public static final Class[] getParamsTypeByClass(Class[] args) {
        int argsLen;
        if (args == null || (argsLen = args.length) <= 0) {
            return FastReflectPrimitive.NO_PARAM_CLASS;
        }
        for (int i = 0; i < argsLen; ++i) {
            Class pc;
            if (args[i] == null || (pc = CONV_PRIMITIVE.get(args[i])) == null) continue;
            args[i] = pc;
        }
        return args;
    }

    public static final int parmasScore(boolean[] pms, Class[] src, Class[] dest, ClassLoader cl) throws ClassNotFoundException {
        int ret = 0;
        boolean one = true;
        int len = src.length;
        for (int i = 0; i < len; ++i) {
            block10: {
                block9: {
                    Class o;
                    int wScore;
                    FastClassElement em;
                    Class s;
                    block11: {
                        s = src[i];
                        Class d = dest[i];
                        if (d == null) break block10;
                        if (s == d) {
                            ret += 100;
                            continue;
                        }
                        if (s == OBJECT) {
                            ret += 60;
                            continue;
                        }
                        if (NUMBER_PRIMITIVE.contains(s) && NUMBER_PRIMITIVE.contains(d)) {
                            ret += 50;
                            continue;
                        }
                        if (s == STRING && PRIMITIVE.contains(d) || d == STRING && PRIMITIVE.contains(s)) {
                            ret += 40;
                            continue;
                        }
                        em = FastReflectClass.getClass(d.getName());
                        one = false;
                        wScore = 100;
                        if (!s.isInterface()) break block11;
                        String sname = s.getName();
                        do {
                            int befWScore;
                            block12: {
                                block14: {
                                    int lenJ;
                                    Object[] ifce;
                                    block15: {
                                        block13: {
                                            befWScore = --wScore;
                                            ifce = em.getInterfaseNames();
                                            if (ifce == null || (lenJ = ifce.length) <= 0) break block12;
                                            if (Arrays.binarySearch(ifce, sname) == -1) break block13;
                                            one = true;
                                            ret += wScore;
                                            break block14;
                                        }
                                        if (lenJ != 1) break block15;
                                        if ((wScore = FastReflectUtil.toInterface(wScore, sname, (String)ifce[0], cl)) == -1) break block14;
                                        one = true;
                                        ret += wScore;
                                        break block14;
                                    }
                                    for (int j = 0; j < lenJ; ++j) {
                                        if ((wScore = FastReflectUtil.toInterface(wScore, sname, (String)ifce[i], cl)) == -1) continue;
                                        one = true;
                                        ret += wScore;
                                        break;
                                    }
                                }
                                if (one) break block9;
                            }
                            wScore = befWScore;
                            o = (em = FastReflectClass.getClass(em.getSuperClassName())).getClassObject();
                            if (o != OBJECT) continue;
                            return -1;
                        } while (o != s);
                        one = true;
                        ret += wScore;
                        break block9;
                    }
                    do {
                        --wScore;
                        o = (em = FastReflectClass.getClass(em.getSuperClassName())).getClassObject();
                        if (o != OBJECT) continue;
                        return -1;
                    } while (o != s);
                    one = true;
                    ret += wScore;
                }
                if (one) continue;
                return -1;
            }
            if (!pms[i]) continue;
            return -1;
        }
        return ret;
    }

    private static final int toInterface(int wScore, String sname, String name, ClassLoader cl) throws ClassNotFoundException {
        FastClassElement em = FastReflectClass.getClass(cl, name);
        while (em != null) {
            --wScore;
            String superClassName = em.getSuperClassName();
            if (superClassName == sname) {
                return wScore;
            }
            em = FastReflectClass.getClass(cl, superClassName);
        }
        return -1;
    }

    public static final Object[] convertParams(Object[] args, Class[] types) {
        int len = args.length;
        if (len <= 0) {
            return FastReflectPrimitive.NO_PARAM;
        }
        Object[] ret = new Object[len];
        System.arraycopy(args, 0, ret, 0, len);
        for (int i = 0; i < len; ++i) {
            Class<?> d;
            Class s;
            if (ret[i] == null || (s = types[i]) == (d = ret[i].getClass())) continue;
            if (NUMBER_PRIMITIVE.contains(s) && NUMBER_PRIMITIVE.contains(d)) {
                ret[i] = FastReflectUtil.convertNumberPrimitive(ret[i], CONV_TABLE.get(s), CONV_TABLE.get(d));
                continue;
            }
            if (s == STRING && PRIMITIVE.contains(d)) {
                ret[i] = ret[i].toString();
                continue;
            }
            if (d != STRING || !PRIMITIVE.contains(s)) continue;
            if (s == Boolean.class) {
                String str = ((String)args[i]).toLowerCase();
                if (str.equals("true")) {
                    ret[i] = Boolean.TRUE;
                    continue;
                }
                if (str.equals("false")) {
                    ret[i] = Boolean.FALSE;
                    continue;
                }
                throw new ClassCastException("\u7b2c" + (i + 1) + "\u5f15\u6570\u306e\u30ad\u30e3\u30b9\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            Integer o = CONV_TABLE.get(s);
            if (o == null) continue;
            ret[i] = FastReflectUtil.convertNumber(o, (String)ret[i]);
        }
        return ret;
    }

    private static final Object convertNumber(int type, String s) {
        if ((s = s.trim().toLowerCase()).endsWith("f") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
        }
        if (type == 5 || type == 6) {
            return FastReflectUtil.convertType(type, s);
        }
        int p = s.indexOf(".");
        if (p == -1) {
            if (s.startsWith("0x")) {
                int len = (s = s.substring(2)).length();
                if (len > 8) {
                    if (len > 16) {
                        throw new NumberFormatException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                    }
                    long ret = 0L;
                    for (int i = 0; i < len; ++i) {
                        char c = s.charAt(i);
                        if (c >= '1' && c <= '9') {
                            ret |= (long)(c - 48 << i);
                            continue;
                        }
                        if (c < 'a' || c > 'f') continue;
                        ret |= (long)(c - 97 + 10 << i);
                    }
                    switch (type) {
                        case 0: {
                            return (byte)(ret & 0xFFL);
                        }
                        case 1: {
                            return Character.valueOf((char)(ret & 0xFFFFL));
                        }
                        case 2: {
                            return (short)(ret & 0xFFFFL);
                        }
                        case 3: {
                            return (int)(ret & 0xFFFFFFFFL);
                        }
                        case 4: {
                            return ret;
                        }
                    }
                    return null;
                }
                int ret = 0;
                for (int i = 0; i < len; ++i) {
                    char c = s.charAt(i);
                    if (c >= '1' && c <= '9') {
                        ret |= c - 48 << i;
                        continue;
                    }
                    if (c < 'a' || c > 'f') continue;
                    ret |= c - 97 + 10 << i;
                }
                switch (type) {
                    case 0: {
                        return (byte)(ret & 0xFF);
                    }
                    case 1: {
                        return Character.valueOf((char)(ret & 0xFFFF));
                    }
                    case 2: {
                        return (short)(ret & 0xFFFF);
                    }
                    case 3: {
                        return ret;
                    }
                    case 4: {
                        return (long)ret;
                    }
                }
                return null;
            }
            return FastReflectUtil.convertType(type, s);
        }
        return FastReflectUtil.convertType(type, s.substring(0, p));
    }

    private static final Object convertType(int type, String s) {
        switch (type) {
            case 0: {
                return Byte.parseByte(s);
            }
            case 1: {
                return Character.valueOf(s.length() == 1 ? s.charAt(0) : (char)(Integer.parseInt(s) & 0xFFFF));
            }
            case 2: {
                return Short.parseShort(s);
            }
            case 3: {
                return Integer.parseInt(s);
            }
            case 4: {
                return Long.parseLong(s);
            }
            case 5: {
                return Float.valueOf(Float.parseFloat(s));
            }
            case 6: {
                return Double.parseDouble(s);
            }
        }
        return s;
    }

    private static final Object convertNumberPrimitive(Object o, int srcType, int destType) {
        switch (destType) {
            case 0: {
                byte by = (Byte)o;
                switch (srcType) {
                    case 0: {
                        return by;
                    }
                    case 1: {
                        return Character.valueOf((char)by);
                    }
                    case 2: {
                        return (short)by;
                    }
                    case 3: {
                        return (int)by;
                    }
                    case 4: {
                        return (long)by;
                    }
                    case 5: {
                        return Float.valueOf(by);
                    }
                    case 6: {
                        return (double)by;
                    }
                }
            }
            case 1: {
                char c = ((Character)o).charValue();
                switch (srcType) {
                    case 0: {
                        return (byte)c;
                    }
                    case 1: {
                        return Character.valueOf(c);
                    }
                    case 2: {
                        return (short)c;
                    }
                    case 3: {
                        return (int)c;
                    }
                    case 4: {
                        return (long)c;
                    }
                    case 5: {
                        return Float.valueOf(c);
                    }
                    case 6: {
                        return (double)c;
                    }
                }
            }
            case 2: {
                short s = (Short)o;
                switch (srcType) {
                    case 0: {
                        return (byte)s;
                    }
                    case 1: {
                        return Character.valueOf((char)s);
                    }
                    case 2: {
                        return s;
                    }
                    case 3: {
                        return (int)s;
                    }
                    case 4: {
                        return (long)s;
                    }
                    case 5: {
                        return Float.valueOf(s);
                    }
                    case 6: {
                        return (double)s;
                    }
                }
            }
            case 3: {
                int n = (Integer)o;
                switch (srcType) {
                    case 0: {
                        return (byte)n;
                    }
                    case 1: {
                        return Character.valueOf((char)n);
                    }
                    case 2: {
                        return (short)n;
                    }
                    case 3: {
                        return n;
                    }
                    case 4: {
                        return (long)n;
                    }
                    case 5: {
                        return Float.valueOf(n);
                    }
                    case 6: {
                        return (double)n;
                    }
                }
            }
            case 4: {
                long l = (Long)o;
                switch (srcType) {
                    case 0: {
                        return (byte)l;
                    }
                    case 1: {
                        return Character.valueOf((char)l);
                    }
                    case 2: {
                        return (short)l;
                    }
                    case 3: {
                        return (int)l;
                    }
                    case 4: {
                        return l;
                    }
                    case 5: {
                        return Float.valueOf(l);
                    }
                    case 6: {
                        return (double)l;
                    }
                }
            }
            case 5: {
                float f = ((Float)o).floatValue();
                switch (srcType) {
                    case 0: {
                        return (byte)f;
                    }
                    case 1: {
                        return Character.valueOf((char)f);
                    }
                    case 2: {
                        return (short)f;
                    }
                    case 3: {
                        return (int)f;
                    }
                    case 4: {
                        return (long)f;
                    }
                    case 5: {
                        return Float.valueOf(f);
                    }
                    case 6: {
                        return (double)f;
                    }
                }
            }
            case 6: {
                double d = (Double)o;
                switch (srcType) {
                    case 0: {
                        return (byte)d;
                    }
                    case 1: {
                        return Character.valueOf((char)d);
                    }
                    case 2: {
                        return (short)d;
                    }
                    case 3: {
                        return (int)d;
                    }
                    case 4: {
                        return (long)d;
                    }
                    case 5: {
                        return Float.valueOf((float)d);
                    }
                    case 6: {
                        return d;
                    }
                }
            }
        }
        return o;
    }

    static {
        HashMap<Class, Integer> m = new HashMap<Class, Integer>();
        m.put(Byte.class, 0);
        m.put(Character.class, 1);
        m.put(Short.class, 2);
        m.put(Integer.class, 3);
        m.put(Long.class, 4);
        m.put(Float.class, 5);
        m.put(Double.class, 6);
        CONV_TABLE = m;
    }
}

