/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class FastFieldElements {
    private final Map<String, Field> map = new HashMap<String, Field>();

    private FastFieldElements() {
    }

    public FastFieldElements(Class clazz) {
        Field[] fs = clazz.getDeclaredFields();
        if (fs != null) {
            for (Field f : fs) {
                if (!Modifier.isPublic(f.getModifiers())) continue;
                f.setAccessible(true);
                this.map.put(f.getName(), f);
            }
        }
    }

    protected void finalize() throws Exception {
        this.map.clear();
    }

    public Field get(boolean staticFlag, String name) {
        Field f = this.map.get(name);
        if (f != null && Modifier.isStatic(f.getModifiers()) == staticFlag) {
            return f;
        }
        return null;
    }
}

