/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.reflect.FastClassElement;

abstract class FastReflectClass {
    private static final Map<String, FastClassElement> cacheClass = new ConcurrentHashMap<String, FastClassElement>();

    private FastReflectClass() {
    }

    public static final FastClassElement getClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("\u30af\u30e9\u30b9\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        FastClassElement ret = cacheClass.get(name);
        if (ret == null && (c = Class.forName(name)) != null) {
            ret = new FastClassElement(c);
            cacheClass.put(name, ret);
        }
        return ret;
    }

    public static final FastClassElement getClass(ClassLoader cl, String name) throws ClassNotFoundException {
        Class<?> c;
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("\u30af\u30e9\u30b9\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        FastClassElement ret = cacheClass.get(name);
        if (ret == null && (c = cl == null ? Class.forName(name) : cl.loadClass(name)) != null) {
            ret = new FastClassElement(c);
            cacheClass.put(name, ret);
        }
        return ret;
    }
}

