package org.maachang.luxio ;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * NativeFileRawI/O.
 *  
 * @version 2008/12/05
 * @author  masahito suzuki
 * @since   Lux IO 0.1.0
 */
class NativeLuxIO {
    private static boolean initFlag = false ;
    private static final Object sync = new Object() ;
    static {
        synchronized( sync ) {
            String name = LuxioDefine.LIB_NAME ;
            if( System.getProperty( LuxioDefine.LIB_MODE ) != null ) {
                name = System.getProperty( LuxioDefine.LIB_MODE ) ;
            }
            String lib = name + "-" + LuxioDefine.VERSION ;
            switch( Os.getInstance().getOS() ) {
                case Os.OS_WINNT :
                    lib += LuxioDefine.WINDOWS_LIB_PLUS ;
                    System.load( targetDynamincLib( true,lib ) ) ;
                    initFlag = true ;
                    break ;
                case Os.OS_UNIX :
                    lib += LuxioDefine.LINUX_LIB_PLUS ;
                    System.load( targetDynamincLib( true,lib ) ) ;
                    initFlag = true ;
                    break ;
                default :
                    initFlag = false ;
                    break ;
            }
        }
    }
    
    private static final String targetDynamincLib( boolean mode,String lib ) {
        String sp = System.getProperty( "file.separator" ) ;
        File targetDir = null ;
        if( System.getProperty( LuxioDefine.PROPERTY_NAME ) == null ) {
            targetDir = new File( new StringBuilder().
                append( System.getProperty( "user.home" ) ).
                append( sp ).
                append( LuxioDefine.DEFAULT_DIR ).
                toString() );
        }
        else {
            targetDir = new File( System.getProperty( LuxioDefine.PROPERTY_NAME ) );
        }
        if( targetDir.exists() == false ) {
            targetDir.mkdirs() ;
        }
        File outFile = new File( targetDir,lib );
        if( mode == true ) {
            String ntvDir = LuxioDefine.NATIVE_PACKAGE ;
            ntvDir = ntvDir.trim() ;
            if( ntvDir.endsWith( "/" ) == false ) {
                ntvDir += "/" ;
            }
            if( ntvDir.startsWith( "/" ) ) {
                ntvDir = ntvDir.substring( 1 ) ;
            }
            InputStream is = new BufferedInputStream(
                Thread.currentThread().getContextClassLoader().getResourceAsStream(
                    ntvDir + lib ) ) ;
            if( isLibFile( outFile,is ) ) {
                try{
                    OutputStream os = new BufferedOutputStream( new FileOutputStream( outFile ) ) ;
                    try{
                        try{
                            while(true) {
                                int n = is.read();
                                if( n <= -1 ) {
                                    break;
                                }
                                os.write( n );
                            }
                            os.flush() ;
                        }
                        finally{
                            is.close();
                            is = null ;
                        }
                    }
                    finally{
                        os.close();
                        os = null ;
                    }
                }
                catch( Exception e ) {
                    outFile = null ;
                }
            }
            if( is != null ) {
                try {
                    is.close() ;
                } catch( Exception e ) {
                }
                is = null ;
            }
        }
        if( outFile != null ) {
            return outFile.getAbsolutePath() ;
        }
        return null ;
    }
    
    private static final boolean isLibFile( File f,InputStream in ) {
        boolean ret = false ;
        try {
            if( f.exists() == false ) {
                ret = true ;
            }
            else {
                int len = ( int )f.length() ;
                ret = ( len <= 0 || len != in.available() ) ;
            }
        } catch( Exception e ) {
            ret = true ;
        }
        return ret ;
    }
    
    protected static final boolean useInit() {
        boolean ret = false ;
        synchronized( sync ) {
            ret = initFlag ;
        }
        return ret ;
    }
    
    protected static final byte[] nativeString( String s ) {
        byte[] b = s.getBytes() ;
        int len = b.length ;
        byte[] ret = new byte[ len+1 ] ;
        System.arraycopy( b,0,ret,0,len ) ;
        ret[ len ] = 0 ;
        return ret ;
    }
    
    protected NativeLuxIO() {
        
    }
    
    protected static native long open( byte[] name ) ;
    protected static native int close( long handle ) ;
    protected static native byte[] get( long handle,byte[] key ) ;
    protected static native int set( long handle,byte[] key,byte[] value,int valLen ) ;
    protected static native int remove( long handle,byte[] key ) ;
}

