package org.maachang.luxio ;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

/**
 * 指定キーでロック処理.
 * 
 * @version 2008/12/05
 * @author  masahito suzuki
 * @since   Lux IO 0.1.0
 */
class KeyLock {
    
    /**
     * ロックスリープ時間.
     */
    private static final long SLEEP_TIME = 1L ;
    
    /**
     * ロック名群.
     */
    private final Set<String> manager = new ConcurrentSkipListSet<String>() ;
    
    /**
     * コンストラクタ.
     */
    public KeyLock() {
    }
    
    /**
     * 指定キーでロック.
     * @param key ロック対象のキーを設定します.
     * @exceptino InterruptedException スレッド割り込み例外.
     */
    public void lock( String key ) throws InterruptedException {
        while( true ) {
            if( manager.contains( key ) ) {
                Thread.sleep( SLEEP_TIME ) ;
                continue ;
            }
            manager.add( key ) ;
            break ;
        }
    }
    
    /**
     * 指定キーでアンロック.
     * @param key アンロック対象のキーを設定します.
     */
    public void unlock( String key ) {
        manager.remove( key ) ;
    }
}
