#ifdef _WIN32
#ifndef _MMAN_H_INCLUDE_

#include <stddef.h>
#include <sys/types.h>

#include "../wl.h"

#define PROT_READ  0x01
#define PROT_WRITE 0x02

#define MAP_SHARED 0
#define MAP_FAILED 0

#define MS_SYNC 0

#ifdef __cplusplus
extern "C" {
#endif

void *win32_mmap(void *addr, size_t length, int prot, int flags, int fd, off_t offset, HANDLE *h);
int win32_munmap(void *addr, size_t length, HANDLE *h);
int win32_msync(void *addr, size_t length, int flags);

#ifdef __cplusplus
}
#endif

#endif // _MMAN_H_INCLUDE_
#endif
