#ifdef _WIN32
#include <windows.h>
#include <io.h>
#include <sys/types.h>

#include "mman.h"

void *win32_mmap(void *addr, size_t length, int prot, int flags, int fd, off_t offset, HANDLE *h) {
  void *p;
  DWORD flProtect = PAGE_READONLY;
  DWORD dwDesiredAccess = FILE_MAP_READ;

  if (prot & PROT_WRITE) {
    flProtect = PAGE_READWRITE;
    dwDesiredAccess |= FILE_MAP_WRITE;
  }

  *h = CreateFileMappingA((HANDLE) _get_osfhandle(fd), NULL, flProtect, 0, ( DWORD )length, NULL);
  p = MapViewOfFile(*h, dwDesiredAccess, ( DWORD )( ( offset & 0xffffffff00000000 ) >> 32 ), ( DWORD )(offset & 0x00000000ffffffff), 0);

  return p;
}

int win32_munmap(void *addr, size_t length, HANDLE *h) {
  return ((UnmapViewOfFile(addr) & CloseHandle(*h)) != 0) ? 0 : -1;
}

int win32_msync(void *addr, size_t length, int flags) {
  return (FlushViewOfFile(addr, length) != 0) ? 0 : -1;
}
#endif
