/**
 * Copyright (c) 2008 masahito suzuki, Inc. All Rights Reserved.
 */
#ifndef _WIN32
// karnel2.6
#define _XOPEN_SOURCE 600
#define _LARGEFILE64_SOURCE
#define _FILE_OFFSET_BITS 64
#endif

#include "wl.h"
#include "include/org_maachang_luxio_NativeLuxIO.h"
#include "btree.h"

#ifdef _WIN32
#pragma comment(lib,"jvm.lib")
#endif

JNIEXPORT jlong JNICALL Java_org_maachang_luxio_NativeLuxIO_open
  (JNIEnv *env , jclass c, jbyteArray jname ) {
    jbyte* name = (jbyte*)env->GetPrimitiveArrayCritical(jname, NULL);
    Lux::IO::Btree* ret = new Lux::IO::Btree(Lux::IO::CLUSTER);
    bool res = ret->open((const char*)name, Lux::DB_CREAT);
    env->ReleasePrimitiveArrayCritical(jname, name, JNI_ABORT);
    if( !res ) {
        return 0 ;
    }
    return ( jlong )ret ;
}

JNIEXPORT jint JNICALL Java_org_maachang_luxio_NativeLuxIO_close
  (JNIEnv *env , jclass c, jlong handle ) {
    Lux::IO::Btree* bt = ( Lux::IO::Btree* )handle ;
    bool res = bt->close() ;
    delete bt ;
    bt = NULL ;
    return ( !res ) ? -1 : 0 ;
}

JNIEXPORT jbyteArray JNICALL Java_org_maachang_luxio_NativeLuxIO_get
  (JNIEnv *env , jclass c, jlong handle, jbyteArray jkey) {
    jbyteArray ret = NULL ;
    Lux::IO::Btree* bt = ( Lux::IO::Btree* )handle ;
    jbyte* key = (jbyte*)env->GetPrimitiveArrayCritical(jkey, NULL);
    Lux::IO::data_t *val = bt->get(key,(uint32_t)strlen((const char*)key)) ;
    env->ReleasePrimitiveArrayCritical(jkey, key, JNI_ABORT);
    if( val == NULL ) {
        return NULL ;
    }
    if( val->data != NULL ) {
        ret = env->NewByteArray(val->size);
        env->SetByteArrayRegion(ret, 0, val->size, (jbyte*) val->data);
    }
    bt->clean_data( val ) ;
    return ret ;
}

JNIEXPORT jint JNICALL Java_org_maachang_luxio_NativeLuxIO_set
  (JNIEnv *env , jclass c, jlong handle, jbyteArray jkey, jbyteArray jvalue,jint valLen) {
    Lux::IO::Btree* bt = ( Lux::IO::Btree* )handle ;
    jbyte* key = (jbyte*)env->GetPrimitiveArrayCritical(jkey, NULL);
    jbyte* value = (jbyte*)env->GetPrimitiveArrayCritical(jvalue, NULL);
    Lux::IO::data_t tk = {key, (uint32_t)strlen((const char*)key)};
    Lux::IO::data_t tv = {value, (uint32_t)valLen};
    bool res = bt->put( &tk, &tv ) ;
    env->ReleasePrimitiveArrayCritical(jkey, key, JNI_ABORT);
    env->ReleasePrimitiveArrayCritical(jvalue, value, JNI_ABORT);
    return ( !res ) ? -1 : 0 ;
}

JNIEXPORT jint JNICALL Java_org_maachang_luxio_NativeLuxIO_remove
  (JNIEnv *env , jclass c, jlong handle, jbyteArray jkey) {
    Lux::IO::Btree* bt = ( Lux::IO::Btree* )handle ;
    jbyte* key = (jbyte*)env->GetPrimitiveArrayCritical(jkey, NULL);
    bool res = bt->del(key,(uint32_t)strlen((const char*)key)) ;
    env->ReleasePrimitiveArrayCritical(jkey, key, JNI_ABORT);
    return ( !res ) ? -1 : 0 ;
}

