/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.luxio;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.maachang.luxio.LuxIo;
import org.maachang.luxio.TransElement;

public class TransactionLuxIo
implements LuxIo {
    private static final int TYPE_PUT = 0;
    private static final int TYPE_REMOVE = 1;
    private LuxIo luxio = null;
    private final Map<String, TransElement> trans = new HashMap<String, TransElement>();

    public TransactionLuxIo() {
    }

    public TransactionLuxIo(LuxIo luxio) throws Exception {
        this.create(luxio);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(LuxIo luxio) throws Exception {
        if (luxio == null || !luxio.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (luxio instanceof TransactionLuxIo) {
            throw new IOException("TransactionLuxIo\u306fTransactionLuxIo\u306b\u5bfe\u3057\u3066\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        this.clear();
        this.luxio = luxio;
    }

    public void clear() {
        this.trans.clear();
        this.luxio = null;
    }

    public boolean isUse() {
        return this.luxio != null && this.luxio.isUse();
    }

    public void commit() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        try {
            int len = this.trans.size();
            Object[] lst = new TransElement[len];
            Iterator<String> it = this.trans.keySet().iterator();
            int cnt = 0;
            while (it.hasNext()) {
                lst[cnt] = this.trans.get(it.next());
                ++cnt;
            }
            Arrays.sort(lst);
            int i = 0;
            while (i < len) {
                Object em = lst[i];
                if (em != null) {
                    switch (((TransElement)em).getType()) {
                        case 0: {
                            this.luxio.put(((TransElement)em).getKey(), ((TransElement)em).getValue());
                            break;
                        }
                        case 1: {
                            this.luxio.remove(((TransElement)em).getKey());
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            this.trans.clear();
        }
    }

    public void rollback() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.trans.clear();
    }

    public void put(String key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        TransElement em = new TransElement(this.trans.size(), 0, key, value);
        this.trans.put(key, em);
    }

    public byte[] get(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        TransElement em = this.trans.get(key);
        ret = em != null ? em.getValue() : this.luxio.get(key);
        return ret;
    }

    public void remove(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        TransElement em = new TransElement(this.trans.size(), 1, key, null);
        this.trans.put(key, em);
    }
}

