/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.luxio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.luxio.Os;

class NativeLuxIO {
    private static boolean initFlag = false;
    private static final Object sync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = sync = new Object();
        synchronized (object) {
            String name = "luxio";
            if (System.getProperty("org.maachang.luxio.native") != null) {
                name = System.getProperty("org.maachang.luxio.native");
            }
            String lib = String.valueOf(name) + "-" + "0.1.0";
            switch (Os.getInstance().getOS()) {
                case 33: {
                    lib = String.valueOf(lib) + ".dll";
                    System.load(NativeLuxIO.targetDynamincLib(true, lib));
                    initFlag = true;
                    break;
                }
                case 1: {
                    lib = String.valueOf(lib) + ".so";
                    System.load(NativeLuxIO.targetDynamincLib(true, lib));
                    initFlag = true;
                    break;
                }
                default: {
                    initFlag = false;
                }
            }
        }
    }

    private static final String targetDynamincLib(boolean mode, String lib) {
        String sp = System.getProperty("file.separator");
        File targetDir = null;
        targetDir = System.getProperty("org.maachang.luxio.dir") == null ? new File(System.getProperty("user.home") + sp + ".lib_work") : new File(System.getProperty("org.maachang.luxio.dir"));
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File outFile = new File(targetDir, lib);
        if (mode) {
            BufferedInputStream is;
            String ntvDir = "org/maachang/luxio/native/";
            if (!(ntvDir = ntvDir.trim()).endsWith("/")) {
                ntvDir = String.valueOf(ntvDir) + "/";
            }
            if (ntvDir.startsWith("/")) {
                ntvDir = ntvDir.substring(1);
            }
            if (NativeLuxIO.isLibFile(outFile, is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(String.valueOf(ntvDir) + lib)))) {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        try {
                            int n;
                            while ((n = ((InputStream)is).read()) > -1) {
                                ((OutputStream)os).write(n);
                            }
                            ((OutputStream)os).flush();
                        }
                        finally {
                            ((InputStream)is).close();
                            is = null;
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                        os = null;
                    }
                }
                catch (Exception e) {
                    outFile = null;
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                is = null;
            }
        }
        if (outFile != null) {
            return outFile.getAbsolutePath();
        }
        return null;
    }

    private static final boolean isLibFile(File f, InputStream in) {
        boolean ret = false;
        try {
            int len;
            ret = !f.exists() ? true : (len = (int)f.length()) <= 0 || len != in.available();
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final boolean useInit() {
        boolean ret = false;
        Object object = sync;
        synchronized (object) {
            ret = initFlag;
        }
        return ret;
    }

    protected static final byte[] nativeString(String s) {
        byte[] b = s.getBytes();
        int len = b.length;
        byte[] ret = new byte[len + 1];
        System.arraycopy(b, 0, ret, 0, len);
        ret[len] = 0;
        return ret;
    }

    protected NativeLuxIO() {
    }

    protected static native long open(byte[] var0);

    protected static native int close(long var0);

    protected static native byte[] get(long var0, byte[] var2);

    protected static native int set(long var0, byte[] var2, byte[] var3, int var4);

    protected static native int remove(long var0, byte[] var2);
}

