/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.luxio;

import java.io.IOException;
import java.io.Serializable;
import org.maachang.luxio.LuxIo;
import org.maachang.luxio.LuxioUtil;
import org.maachang.luxio.TransactionLuxIo;

public class LuxOp {
    private LuxIo luxio = null;
    private final TransactionLuxIo tran = new TransactionLuxIo();

    public LuxOp() {
    }

    public LuxOp(LuxIo luxio) throws Exception {
        this.create(luxio);
    }

    public LuxOp(boolean transaction, LuxIo luxio) throws Exception {
        this.create(transaction, luxio);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(LuxIo luxio) throws Exception {
        this.create(false, luxio);
    }

    public void create(boolean transaction, LuxIo luxio) throws Exception {
        if (luxio == null || !luxio.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        if (transaction) {
            if (luxio instanceof TransactionLuxIo) {
                throw new IOException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u30e2\u30fc\u30c9ON\u306b\u5bfe\u3057\u3066\u3001Transaction\u7528Luxio\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
            }
            this.tran.create(luxio);
            this.luxio = this.tran;
        } else {
            this.luxio = luxio;
        }
    }

    public void clear() {
        this.luxio = null;
        if (this.tran.isUse()) {
            try {
                this.tran.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tran.clear();
    }

    public boolean isUse() {
        return this.luxio != null && this.luxio.isUse();
    }

    public LuxIo luxIo() {
        return this.luxio;
    }

    public void commit() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.luxio instanceof TransactionLuxIo) {
            ((TransactionLuxIo)this.luxio).commit();
        }
    }

    public void rollback() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.luxio instanceof TransactionLuxIo) {
            ((TransactionLuxIo)this.luxio).rollback();
        }
    }

    public void put(String key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.luxio.put(key, value);
    }

    public void put(String key, Boolean value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.put(key, (boolean)value);
    }

    public void put(String key, boolean value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = new byte[]{(byte)(value ? 1 : 0)};
        this.luxio.put(key, b);
    }

    public void put(String key, Integer value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.put(key, (int)value);
    }

    public void put(String key, int value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF000000) >> 24)};
        this.luxio.put(key, b);
    }

    public void put(String key, Long value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.put(key, (long)value);
    }

    public void put(String key, long value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24), (byte)((value & 0xFF00000000L) >> 32), (byte)((value & 0xFF0000000000L) >> 40), (byte)((value & 0xFF000000000000L) >> 48), (byte)((value & 0xFF00000000000000L) >> 56)};
        this.luxio.put(key, b);
    }

    public void put(String key, Float value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.put(key, value.floatValue());
    }

    public void put(String key, float value) throws Exception {
        this.put(key, Float.floatToIntBits(value));
    }

    public void put(String key, Double value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.put(key, (double)value);
    }

    public void put(String key, double value) throws Exception {
        this.put(key, Double.doubleToLongBits(value));
    }

    public void put(String key, String value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0 || value == null || value.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.luxio.put(key, value.getBytes());
    }

    public void put(String key, Serializable value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0 || value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.luxio.put(key, LuxioUtil.toBinary(value));
    }

    public void remove(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.luxio.remove(key);
    }

    public byte[] get(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.luxio.get(key);
    }

    public Boolean getBooleanObject(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length <= 0) {
            return null;
        }
        return new Boolean(this.cbool(b));
    }

    public boolean getBoolean(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length <= 0) {
            return false;
        }
        return this.cbool(b);
    }

    public Integer getIntegerObject(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 4) {
            return null;
        }
        return new Integer(this.cint(b));
    }

    public int getInteger(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 4) {
            return -1;
        }
        return this.cint(b);
    }

    public Long getLongObject(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 8) {
            return null;
        }
        return new Long(this.clong(b));
    }

    public long getLong(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 8) {
            return -1L;
        }
        return this.clong(b);
    }

    public Float getFloatObject(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 4) {
            return null;
        }
        return new Float(Float.intBitsToFloat(this.cint(b)));
    }

    public float getFloat(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 4) {
            return -1.0f;
        }
        return Float.intBitsToFloat(this.cint(b));
    }

    public Double getDoubleObject(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 8) {
            return null;
        }
        return new Double(Double.longBitsToDouble(this.clong(b)));
    }

    public double getDouble(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null || b.length != 8) {
            return -1.0;
        }
        return Double.longBitsToDouble(this.clong(b));
    }

    public String getString(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    public Serializable getObject(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] b = this.luxio.get(key);
        if (b == null) {
            return null;
        }
        return LuxioUtil.toObject(b);
    }

    public boolean isTransaction() {
        return this.luxio instanceof TransactionLuxIo;
    }

    private boolean cbool(byte[] b) {
        return b[0] == 1;
    }

    private int cint(byte[] b) {
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
    }

    private long clong(byte[] b) {
        return (long)b[0] & 0xFFL | ((long)b[1] & 0xFFL) << 8 | ((long)b[2] & 0xFFL) << 16 | ((long)b[3] & 0xFFL) << 24 | ((long)b[4] & 0xFFL) << 32 | ((long)b[5] & 0xFFL) << 40 | ((long)b[6] & 0xFFL) << 48 | ((long)b[7] & 0xFFL) << 56;
    }
}

