package org.maachang.service.mail ;

import java.util.ArrayList;

/**
 * メール送信Bean.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class SendMail {
    
    /**
     * host.
     */
    private String host = null ;
    
    /**
     * port.
     */
    private int port = -1 ;
    
    /**
     * 接続タイムアウト値.
     */
    private long timeout = -1L ;
    
    /**
     * 認証条件.
     */
    private boolean auth = false ;
    
    /**
     * ユーザ名.
     */
    private String user = null ;
    
    /**
     * パスワード.
     */
    private String passwd = null ;
    
    /**
     * SSL.
     */
    private boolean ssl = false ;
    
    /**
     * 送信者.
     */
    private String from = null ;
    
    /**
     * 送信先.
     */
    private ArrayList<String> to = null ;
    
    /**
     * サブジェクト.
     */
    private String subject = null ;
    
    /**
     * テンプレート情報
     */
    private String body = null ;
    
    /**
     * テンプレートパラメータ.
     */
    private Object params = null ;
    
    /**
     * 添付ファイル.
     */
    private ArrayList<ResultAttached> attached = null ;
    
    /**
     * host を取得.
     * <BR><BR>
     * @return host が返されます.
     */
    public String getHost() {
        return host;
    }

    /**
     * host を設定.
     * <BR><BR>
     * @param host host を設定します.
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * auth を取得.
     * <BR><BR>
     * @return auth が返されます.
     */
    public boolean isAuth() {
        return auth;
    }

    /**
     * auth を設定.
     * <BR><BR>
     * @param auth auth を設定します.
     */
    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    /**
     * passwd を取得.
     * <BR><BR>
     * @return passwd が返されます.
     */
    public String getPasswd() {
        return passwd;
    }

    /**
     * passwd を設定.
     * <BR><BR>
     * @param passwd passwd を設定します.
     */
    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    /**
     * ssl を取得.
     * <BR><BR>
     * @return ssl が返されます.
     */
    public boolean isSsl() {
        return ssl;
    }

    /**
     * ssl を設定.
     * <BR><BR>
     * @param ssl ssl を設定します.
     */
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    /**
     * timeout を取得.
     * <BR><BR>
     * @return timeout が返されます.
     */
    public long getTimeout() {
        return timeout;
    }

    /**
     * timeout を設定.
     * <BR><BR>
     * @param timeout timeout を設定します.
     */
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /**
     * user を取得.
     * <BR><BR>
     * @return user が返されます.
     */
    public String getUser() {
        return user;
    }

    /**
     * user を設定.
     * <BR><BR>
     * @param user user を設定します.
     */
    public void setUser(String user) {
        this.user = user;
    }

    /**
     * to を取得.
     * <BR><BR>
     * @return to が返されます.
     */
    public ArrayList<String> getTo() {
        return to;
    }

    /**
     * to を設定.
     * <BR><BR>
     * @param to 対象条件 to に設定.
     */
    public void setTo(ArrayList<String> to) {
        this.to = to;
    }

    /**
     * from を取得.
     * <BR><BR>
     * @return from が返されます.
     */
    public String getFrom() {
        return from;
    }

    /**
     * from を設定.
     * <BR><BR>
     * @param from 対象条件 from に設定.
     */
    public void setFrom(String from) {
        this.from = from;
    }

    /**
     * params を取得.
     * <BR><BR>
     * @return params が返されます.
     */
    public Object getParams() {
        return params;
    }

    /**
     * params を設定.
     * <BR><BR>
     * @param params 対象条件 params に設定.
     */
    public void setParams(Object params) {
        this.params = params;
    }

    /**
     * subject を取得.
     * <BR><BR>
     * @return subject が返されます.
     */
    public String getSubject() {
        return subject;
    }

    /**
     * subject を設定.
     * <BR><BR>
     * @param subject 対象条件 subject に設定.
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    /**
     * body を取得.
     * <BR><BR>
     * @return body が返されます.
     */
    public String getBody() {
        return body;
    }

    /**
     * body を設定.
     * <BR><BR>
     * @param body 対象条件 templateName に設定.
     */
    public void setBody(String body) {
        this.body = body;
    }

    /**
     * attached を取得.
     * <BR><BR>
     * @return attached が返されます.
     */
    public ArrayList<ResultAttached> getAttached() {
        return attached;
    }

    /**
     * attached を設定.
     * <BR><BR>
     * @param attached attached を設定します.
     */
    public void setAttached(ArrayList<ResultAttached> attached) {
        this.attached = attached;
    }

    /**
     * データチェック.
     * <BR><BR>
     * 設定された内容が正しいかチェックします.
     * <BR>
     * @return boolean [true]の場合、設定条件は正常です.
     */
    public boolean check() {
        if( to == null || to.size() <= 0 ||
            from == null || ( from = from.trim() ).length() <= 0 ||
            host == null || ( host = host.trim() ).length() <= 0 ||
            subject == null || ( subject = subject.trim() ).length() <= 0 ||
            body == null || params == null ) {
            return false ;
        }
        return true ;
    }
}

