package org.maachang.service.mail ;

import java.util.ArrayList;
import java.util.Date;

/**
 * メール受信結果.
 * 
 * @version 2007/10/22.
 * @author masahito suzuki.
 * @since maaEngine 1.00.
 */
public class ResultMail {
    
    /**
     * 宛先.
     */
    private ArrayList<String> to = null ;
    
    /**
     * 差出人.
     */
    private ArrayList<String> from = null ;
    
    /**
     * タイトル.
     */
    private String subject = null ;
    
    /**
     * 受信内容.
     */
    private String body = null ;
    
    /**
     * 受信時間.
     */
    private Date date = null ;
    
    /**
     * 添付ファイル.
     */
    private ArrayList<ResultAttached> attached = null ;
    
    /**
     * コンストラクタ.
     */
    public ResultMail() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        to = null ;
        from = null ;
        subject = null ;
        body = null ;
        date = null ;
        attached = null ;
    }

    /**
     * body を取得.
     * <BR><BR>
     * @return body が返されます.
     */
    public String getBody() {
        return body;
    }

    /**
     * body を設定.
     * <BR><BR>
     * @param body body を設定します.
     */
    public void setBody(String body) {
        this.body = body;
    }

    /**
     * from を取得.
     * <BR><BR>
     * @return from が返されます.
     */
    public ArrayList<String> getFrom() {
        return from;
    }

    /**
     * from を設定.
     * <BR><BR>
     * @param from from を設定します.
     */
    public void setFrom(ArrayList<String> from) {
        this.from = from;
    }

    /**
     * subject を取得.
     * <BR><BR>
     * @return subject が返されます.
     */
    public String getSubject() {
        return subject;
    }

    /**
     * subject を設定.
     * <BR><BR>
     * @param subject subject を設定します.
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    /**
     * to を取得.
     * <BR><BR>
     * @return to が返されます.
     */
    public ArrayList<String> getTo() {
        return to;
    }

    /**
     * to を設定.
     * <BR><BR>
     * @param to to を設定します.
     */
    public void setTo(ArrayList<String> to) {
        this.to = to;
    }

    /**
     * date を取得.
     * <BR><BR>
     * @return date が返されます.
     */
    public Date getDate() {
        return date;
    }

    /**
     * date を設定.
     * <BR><BR>
     * @param date date を設定します.
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * attached を取得.
     * <BR><BR>
     * @return attached が返されます.
     */
    public ArrayList<ResultAttached> getAttached() {
        return attached;
    }

    /**
     * attached を設定.
     * <BR><BR>
     * @param attached attached を設定します.
     */
    public void setAttached(ArrayList<ResultAttached> attached) {
        this.attached = attached;
    }
}
