package org.maachang.service.http ;

import java.util.HashMap;

import org.maachang.engine.util.Reflect;

/**
 * HTTPサービス.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class HttpService {
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult post( Object param,String url )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,null,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult post( Object param,String url,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,null,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult postHttpParam( String url,HttpParam param )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,null,param,null ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult postHttpParam( String url,HttpParam param,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,null,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult post( Object param,String url,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,header,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult post( Object param,String url,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,header,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult postHttpParam( String url,HttpParam param,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,header,param,null ) ;
    }
    
    /**
     * 指定URLに対してPOSTでアクセス.
     * <BR><BR>
     * 指定URLに対してPOSTでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult postHttpParam( String url,HttpParam param,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( true,url,null,header,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult get( Object param,String url )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,null,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult get( Object param,String url,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,null,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult getHttpParam( String url,HttpParam param )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,null,param,null ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult getHttpParam( String url,HttpParam param,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,null,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult get( Object param,String url,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,header,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult get( Object param,String url,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,header,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult getHttpParam( String url,HttpParam param,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,header,param,null ) ;
    }
    
    /**
     * 指定URLに対してGETでアクセス.
     * <BR><BR>
     * 指定URLに対してGETでアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult getHttpParam( String url,HttpParam param,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connection( false,url,null,header,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,byte[] body )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,null,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,byte[] body,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,null,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,byte[] body,HttpParam param )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,null,param,null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,byte[] body,HttpParam param,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,null,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,byte[] body,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,header,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,byte[] body,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,header,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,byte[] body,HttpParam param,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,header,param,null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,byte[] body,HttpParam param,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,null,header,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,String contentType,byte[] body )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,null,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,String contentType,byte[] body,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,null,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,String contentType,byte[] body,HttpParam param )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,null,param,null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,String contentType,byte[] body,HttpParam param,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,null,param,userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,String contentType,byte[] body,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,header,getParam( param ),null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param param 対象のパラメータを設定します.
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult body( Object param,String url,String contentType,byte[] body,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,header,getParam( param ),userAgent ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,String contentType,byte[] body,HttpParam param,HttpHeader header )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,header,param,null ) ;
    }
    
    /**
     * 指定URLに対してBodyに情報を設定してアクセス.
     * <BR><BR>
     * 指定URLに対してBodyに情報を設定してアクセスします.
     * <BR>
     * @param url 対象のURLを設定します.
     * @param contentType 対象のコンテンツタイプを設定します.
     * @param body 対象のBodyを設定します.
     * @param param 対象のパラメータを設定します.
     * @param header 対象のヘッダを設定します.
     * @param userAgent 対象のユーザエージェントを設定します.
     * @return HttpResult 結果情報が返されます.
     * @exception Exception 例外.
     */
    public HttpResult bodyHttpParam( String url,String contentType,byte[] body,HttpParam param,HttpHeader header,String userAgent )
        throws Exception {
        return HttpClientAccess.connectionByInputBody( url,null,body,contentType,header,param,userAgent ) ;
    }
    
    /**
     * ObjectからHttpParamデータを生成.
     */
    private HttpParam getParam( Object params )
        throws Exception {
        if( params == null ) {
            return null ;
        }
        HashMap<String,Object> map = Reflect.getter( params ) ;
        int size = map.size() ;
        if( size > 0 ) {
            HttpParam httpParam = new HttpParam() ;
            Object[] objs = map.keySet().toArray() ;
            for( int i = 0 ; i < size ; i ++ ) {
                httpParam.addParam( ( String )objs[ i ],map.get( ( String )objs[ i ] ) ) ;
            }
            return httpParam ;
        }
        return null ;
    }
}
