package org.maachang.engine.validate ;


/**
 * [isbn]Validate.
 * 
 * @version 2007/10/24
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class IsbnValidateElement extends AbstractValidateElement implements ValidateElement {
    
    /**
     * Validate処理を実行.
     * <BR><BR>
     * Validate処理を実行します.
     * <BR>
     * @param check チェック対象内容を設定します.
     * @param args 処理パラメータを設定します.
     * @return boolean [false]の場合、Validateにマッチした条件が存在します.
     * @exception Exception 例外.
     */
    public boolean match( Object check,String[] args )
        throws Exception {
        if( check != null &&
            ( check instanceof String ) == false &&
            ( check instanceof Integer ) == false &&
            ( check instanceof Long ) == false &&
            ( check instanceof Float ) == false &&
            ( check instanceof Double ) == false ) {
            return false ;
        }
        else if( check == null ) {
            return false ;
        }
        return isMatch( check,"/ISBN\\x20(?=.{13}$)\\d{1,5}([- ])\\d{1,7}\\1\\d{1,6}\\1(\\d|X)$/" ) ;
    }
    
    /**
     * Validate処理対象要素名を取得.
     * <BR><BR>
     * Validate処理対象要素名を取得します.
     * <BR>
     * @return String Validate処理対象要素名が返されます.
     */
    public String getName() {
        return "isbn" ;
    }
}
