package org.maachang.engine.validate ;

import java.util.ArrayList;
import java.util.HashMap;

import org.apache.oro.text.perl.Perl5Util;
import org.maachang.engine.util.KeyValue;
import org.maachang.engine.util.StringUtil;

/**
 * AbstractValidateElement.
 * 
 * @version 2007/10/24
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public abstract class AbstractValidateElement {
    
    /**
     * 正規表現で条件を比較.
     * <BR><BR>
     * 指定正規表現で、条件を比較します.
     * <BR>
     * @param check チェック対象のパラメータを設定します.
     * @param match 対象の正規表現を設定します.
     * @return boolean [true]が返された場合、一致します.
     * @exception Exception 例外.
     */
    protected boolean isMatch( Object check,String match )
        throws Exception {
        if( match == null || match.length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( check == null ) {
            return false ;
        }
        String chk = null ;
        if( ( check instanceof String ) == false ) {
            chk = check.toString() ;
        }
        else {
            chk = ( String )check ;
        }
        return new Perl5Util().match( match,chk ) ;
    }
    
    /**
     * 指定パラメータの内容を分解して取得.
     * <BR><BR>
     * 指定パラメータの内容を分解して取得します.
     * <BR>
     * @param param 分解対象のパラメータを設定します.
     * @retrn KeyValue 分解されたパラメータが返されます.
     */
    protected KeyValue getKeyValue( String param ) {
        ArrayList<String> lst = StringUtil.cutString( true,true,param,"=: \t" ) ;
        if( lst == null || lst.size() <= 0 ) {
            return null ;
        }
        if( lst.size() != 2 ) {
            return null ;
        }
        KeyValue ret = new KeyValue() ;
        ret.setKey( StringUtil.catCote( lst.get( 0 ) ) ) ;
        ret.setValue( StringUtil.catCote( lst.get( 1 ) ) ) ;
        return ret ;
    }
    
    /**
     * 有効なパラメータ一覧を取得.
     * <BR><BR>
     * 有効なパラメータ一覧を取得します.
     * <BR>
     * @param params 対象のパラメータ群を設定します.
     * @return HashMap<String,KeyValue> 有効なパラメータ一覧が返されます.
     */
    public HashMap<String,KeyValue> getUseParams( String[] params ) {
        if( params == null || params.length <= 0 ) {
            return new HashMap<String,KeyValue>() ;
        }
        HashMap<String,KeyValue> ret = new HashMap<String,KeyValue>() ;
        int len = params.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            String string = ( String )params[ i ] ;
            if( string == null || ( string = string.trim() ).length() <= 0 ) {
                continue ;
            }
            KeyValue keyValue = getKeyValue( string ) ;
            if( keyValue == null ||
                keyValue.getKey() == null || keyValue.getKey().length() <= 0 ||
                keyValue.getValue() == null || keyValue.getValue().length() <= 0 ) {
                continue ;
            }
            ret.put( keyValue.getKey().trim(),keyValue ) ;
        }
        return ret ;
    }
}
